// Lego Dart Shooter Droid

// Language: Arduino Sketch
// I2C Transmitter (Master): palmArduino II
// by Sam Thongrong (Sath02)
// Jun 22, 2013

#include <SoftwareSerial.h>
#include <Wire.h>

SoftwareSerial DroidSerial = SoftwareSerial(2, 3);

#include <Servo.h>  

// control commands array
// (Pause, Torso Left, Torso Right, Shoot Angle 1, Shoot Angle 2, Shoot Angle 3, 
//  Shoot Angle 4, Shoot Angle 5, Shoot, Forward, Backward, Left, Right)
int controls[14] = {0x47, 0x67, 0x57, 0x77, 0x45, 0x65, 0x53, 
                    0x73, 0x42, 0x62, 0x4c, 0x6c, 0x2c, 0x58};

int incomingByte;

//I2C
byte i2cValue = 0;

int ledPin = 13;

int servoAimPin = 10;  // 9g Servo
int servoShootPin = 9;  // 3.7G Servo

Servo servoAim;
Servo servoShoot;

int aimAngle;   // servo position in degrees  
int angle;

//I2C
byte x = 0;

//========== Shoot Servo
void shoot() {
  digitalWrite(ledPin, HIGH); 
  // shoot at 40 deg. angle
  for(angle = 0; angle < 40; angle++) { 
    servoShoot.write(angle);      
    delay(5);         
  }
 
  for(angle = 40; angle > 0; angle--) {
    servoShoot.write(angle);      
    delay(5);         
  }
  delay(200);    // pause for the Cannon to be stable
  digitalWrite(ledPin, LOW);
}

void aimDart(int rotAngle) {

  int tempAng = aimAngle - rotAngle;
  
  if(tempAng > 0){
    for (rotAngle; rotAngle < aimAngle; rotAngle++){
      servoAim.write(rotAngle);
      delay(20); 
   }
  }
  else if(tempAng < 0){
    for (rotAngle; rotAngle > aimAngle; rotAngle--){
      servoAim.write(rotAngle);
      delay(20);      
   }
  }
  else {
    rotAngle = 90;
    servoAim.write(rotAngle);
    delay(20);
  }
  aimAngle = rotAngle;
  delay(200);    // pause for the Cannon to be stable
  
}

// I2C Transmitter
void i2cTransmit(byte value) {
  Wire.beginTransmission(7); // transmit to device ID = 7
  Wire.write(value);         // sends one byte  
  Wire.endTransmission();    // stop transmitting
}

void setup() {   
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, LOW); 
  
  // Xbee Comm. via SoftwareSerial pin 2, 3
  DroidSerial.begin(38400);
  
  // I2C Comm.
  Wire.begin();  // I'm the Sender, I do not need ID
  
  // Servos
  servoAim.attach(servoAimPin); 
  servoShoot.attach(servoShootPin);
  
  // Set servos to positions
  aimAngle = 90;   // servo position in degrees  
  servoAim.write(aimAngle);
  delay(15);
  
  angle = 0;
  servoShoot.write(angle);
  delay(15);
}   

void loop() {
  
  // XBee Comm.
  if(DroidSerial.available()) {
    //Serial.print((char)DroidSerial.read());
    incomingByte = DroidSerial.read();
    
    if(incomingByte == controls[0]){
      // pause
      i2cTransmit(controls[0]);
    }

    else if(incomingByte == controls[1]){
      // torso Left
      i2cTransmit(controls[1]);
    }
    
    else if(incomingByte == controls[2]){
      // Torso Right
      i2cTransmit(controls[2]);
    }
    
    else if(incomingByte == controls[3]){
      // Shoot Angle 1
      servoAim.write(20);
      delay(15);
    }
    
    else if(incomingByte == controls[4]){
      // Shoot Angle 2
      servoAim.write(55);
      delay(15);
    }   
    else if(incomingByte == controls[5]){
      // Shoot Angle 3 90 deg
      servoAim.write(90);
      delay(15);
    }
    else if(incomingByte == controls[6]){
      // Shoot Angle 4
      servoAim.write(125);
      delay(15);
    }
    else if(incomingByte == controls[7]){
      // Shoot Angle 5
      servoAim.write(160);
      delay(15);
    }
    else if(incomingByte == controls[8]){
      // Shoot
      shoot();
    }
    else if(incomingByte == controls[9]){
      // Forward
      i2cTransmit(controls[9]);
    }
    else if(incomingByte == controls[10]){
      // Backward
      i2cTransmit(controls[10]);
    }
    else if(incomingByte == controls[11]){
      // Turn Left
      i2cTransmit(controls[11]);
    }
    else if(incomingByte == controls[12]){
      // Turn Right
      i2cTransmit(controls[12]);
    }
  } 
  // pause for 100 milliseconds
  delay(100);
}


