#include <EEPROM.h>
#include "SerialCommand.h"
#include "EEPROMAnything.h"

#define SerialPort Serial1
int BautRate = 9600;
SerialCommand sCmd(SerialPort);   // The demo SerialCommand object

int channel [6] = {A5,A4,A3,A2,A1,A0};
int value[6];

float normalized[6];

float interpol;

float OutputPID, InputPID;

float errSum, lastErr;

int rightMotorSpeed;
int leftMotorSpeed;
int voltage;

int MotorLinks1 = 5; //pid linker motor, 1 hoog 2 laag --> vooruit
int MotorLinks2 = 6;
 
int MotorRechts1 = 9; //pid rechter motor, 1 hoog 2 laag --> vooruit
int MotorRechts2 = 10;
 
int button = 3;           // Number of input pin from button
int buttonstate = HIGH;   // Current state of the button  
int buttonreading;        // Current reading of the button
int buttonprevious = LOW; // Previous reading of the button

int ledGreen = 11;

struct param_t
{
  bool start;
  int speed;
  float kp;
  float ki;
  float kd;
  unsigned long cycleTime;
  int white  [6];
  int black  [6];  
} params;

unsigned long time, prevTime, delta, calculationTime;

void setup()
{  
  pinMode(MotorLinks1, OUTPUT);
  pinMode(MotorLinks2, OUTPUT);
  
  pinMode(MotorRechts1, OUTPUT);
  pinMode(MotorRechts2, OUTPUT);

  pinMode(ledGreen, OUTPUT);

  pinMode(button, INPUT);
  attachInterrupt(0, onInterrupt, RISING);
    
  SerialPort.begin(BautRate); 
  sCmd.addCommand("start", onStart);
  sCmd.addCommand("stop", onStop);
  sCmd.addCommand("set", onSet);
  sCmd.addCommand("debug", onDebug);
  sCmd.addCommand("reset", onReset);
  sCmd.addCommand("calibrate", onCalibrate);
  sCmd.setDefaultHandler(onUnknownCommand);

  EEPROM_readAnything(0, params);
  params.start = false;
  
  time = micros();
  prevTime = time;
  
  SerialPort.println("ready");
}

void loop()
{  

  sCmd.readSerial();     // We don't do much, just process serial commands
  
  time = micros();
  
  if (time > prevTime) delta = time - prevTime;
  else delta = 4294967295 - prevTime + time + 1;
    
  if (delta > params.cycleTime)         
  {
     prevTime = time;
     
     //NORMAILEREN
    for (int i = 0; i < 6; i++)
    {
      value[i] = analogRead(channel[i]);
      normalized[i] = value[i] - params.white[i];
      normalized[i] = normalized[i]*100;
      normalized[i] = normalized[i]/(params.white[i] - params.black[i]);
    }

   //INTERPOLEREN : gewogen gemiddelde
   interpol = (((-250*normalized[0])+(-150*normalized[1])+(-50*normalized[2])+(50*normalized[3])+(150*normalized[4])+(250 * normalized[5]))/(((normalized[2]+normalized[3])/2)+normalized[0]+normalized[1]+normalized[2]+normalized[3]+normalized[4]+normalized[5]));
   
  //PID
  //compute all the working error variables (error: P, errSum: I, lastErr: D)
  InputPID = interpol;
  float error = InputPID;
  
  errSum += error;
  float dErr = (error - lastErr);

  //compute PID output
  OutputPID = params.kp * error  + params.kd * dErr;

  //remember some variables for next time
  lastErr = error;

  //snelheid motoren
  if (OutputPID > 0){
    rightMotorSpeed = params.speed; // + (OutputPID);
    leftMotorSpeed = params.speed - (OutputPID);
  }else if (OutputPID < 0){
    rightMotorSpeed = params.speed + (OutputPID);
    leftMotorSpeed = params.speed;
  }
  
  if (rightMotorSpeed > 255){rightMotorSpeed = 255;}
  if (rightMotorSpeed < -255){rightMotorSpeed = -255;}

  if (leftMotorSpeed > 255){leftMotorSpeed = 255;}
  if (leftMotorSpeed < -255){leftMotorSpeed = -255;}

  
  analogWrite(MotorRechts1, abs(rightMotorSpeed)); 
  digitalWrite(MotorRechts2, LOW);
  if (rightMotorSpeed < 0){
    analogWrite(MotorRechts2, 0); 
    digitalWrite(MotorRechts1, LOW);
  }
      
  analogWrite(MotorLinks1, abs(leftMotorSpeed)); 
  digitalWrite(MotorLinks2, LOW);
  
  if (leftMotorSpeed < 0){
    analogWrite(MotorLinks2, 0); 
    digitalWrite(MotorLinks1, LOW);
  }
  
  
  /*if (rightMotorSpeed > 0){
    analogWrite(MotorRechts1, abs(rightMotorSpeed)); 
    digitalWrite(MotorRechts2, LOW);
  
  }
  else if (rightMotorSpeed < 0){
    analogWrite(MotorRechts2, abs(rightMotorSpeed)); 
    digitalWrite(MotorRechts1, LOW); 
  }

  if (leftMotorSpeed > 0){
    analogWrite(MotorLinks1, abs(leftMotorSpeed)); 
    digitalWrite(MotorLinks2, LOW);
  }
  else if (leftMotorSpeed < 0){
    analogWrite(MotorLinks2, abs(leftMotorSpeed)); 
    digitalWrite(MotorLinks1, LOW);
  }*/


  digitalWrite(ledGreen, HIGH);

  lastErr = error;
                                            
  unsigned long difference = micros() - time;
  if (difference > calculationTime) calculationTime = difference; 
  }
  else if (params.start == 0)
  {
   analogWrite(MotorLinks1, 0); // stil bij A
   digitalWrite(MotorLinks2, LOW);
   
   analogWrite(MotorRechts1, 0); // stil bij B
   digitalWrite(MotorRechts2, LOW);
   
   digitalWrite(ledGreen, LOW);

   
  }
}

void onUnknownCommand(char *command)
{
  SerialPort.print("unknown command: \"");
  SerialPort.print(command);
  SerialPort.println("\"");
}

void onSet()
{
  char* parameter = sCmd.next();
  char* value = sCmd.next();
  
  if (strcmp(parameter, "speed") == 0) params.speed = atoi(value);
  else if (strcmp(parameter, "kp") == 0) params.kp = atof(value);
  else if (strcmp(parameter, "cycle") == 0) params.cycleTime = atol(value);
  else if (strcmp(parameter, "ki") == 0) 
  {
    params.ki = atof(value);
    params.ki *= params.cycleTime;
    params.ki /= 1000;
  }
  else if (strcmp(parameter, "kd") == 0)
  {
    params.kd = atof(value);
    params.kd /= params.cycleTime;
    
  }
  else if (strcmp(parameter, "cycle") == 0)
  {
    float ratio = params.cycleTime;
    params.cycleTime = atol(value);
    ratio /= params.cycleTime;
    
    params.ki /= ratio;
    params.kd *= ratio;
  }
  
  EEPROM_writeAnything(0, params);
}

void onStart()
{
  params.start = true;
}

void onStop()
{
  params.start = false;
  
}

void onCalibrate()
{
  SerialPort.println();
  SerialPort.println("kalibratie gestart ...");
  SerialPort.println();
  char*arg= sCmd.next();
  if (strcmp ( arg, "white" ) == 0)
  { 
    for (int i = 0; i < 6; i++) 
    {  
     params.white[i] = 0;
     for (int j = 0; j < 100; j++)
     
     {
       int value = analogRead ( channel[i]);
       if ( value > params.white[i]);
       params.white[i] = value; 
     }
    }
      for (int k = 0; k < 6; k++)
    {
    SerialPort.print(params.white[k]);
    SerialPort.print(' ');
    }
     
  SerialPort.println("WIT");  
  SerialPort.println();
  }

     else if (strcmp ( arg, "black" ) == 0)
    { 
      for (int i = 0; i < 6; i++) 
      {  
        params.black[i] = 0;
        for (int j = 0; j < 100; j++)
        {
        int value = analogRead ( channel[i]);
        if ( value < params.black[i]);
        params.black[i] = value; 
        }
      }
      for (int k = 0; k < 6; k++)
      {
      SerialPort.print(params.black[k]);
      SerialPort.print(' ');
      }
      SerialPort.println("ZWART");
   }
   SerialPort.println();
   
   EEPROM_writeAnything(0, params);
}

void onDebug()
{
  //parameters
  SerialPort.print("speed: ");
  SerialPort.println(params.speed);
  SerialPort.print("kp: ");
  SerialPort.println(params.kp);
  SerialPort.print("ki: ");
  SerialPort.println(params.ki * 1 / params.cycleTime);
  SerialPort.print("kd: ");
  SerialPort.println(params.kd * params.cycleTime); 
  SerialPort.println();
  
  //cycle times
  SerialPort.print("- cycle time: ");
  SerialPort.println(params.cycleTime);
  SerialPort.print("- calculation time: ");
  SerialPort.println(calculationTime);
  //SerialPort.println();
  calculationTime = 0;  //reset calculation time
  
  //running
  SerialPort.print("- running: ");
  SerialPort.println(params.start); 

  // sensor
  SerialPort.println();
  SerialPort.println("- DEBUG SENSOR");
  SerialPort.println(" sensor value ");
  for (int i = 0; i < 6; i++)
  {
    SerialPort.print(analogRead (channel[i])); //wijziging
    SerialPort.print(' ');
  }

  // calibrate
  SerialPort.println();
  SerialPort.println(" calibrated white value: ");
  for (int i = 0; i < 6; i++)
  {
    SerialPort.print(params.white[i]);
    SerialPort.print(' ');
  }

  SerialPort.println();
  SerialPort.println(" calibrated black value: ");
  for (int i = 0; i < 6; i++)
  {
    SerialPort.print(params.black[i]);
    SerialPort.print(' ');
  }
  
  //normalized
  SerialPort.println();
  SerialPort.println("- Normalized values");
  for (int i = 0; i < 6; i++)
  {
    SerialPort.print(normalized[i]);
    SerialPort.print(' ');
  }

  // Interpoleren
  SerialPort.println();
  SerialPort.print("- interpoleren: ");
  SerialPort.println(interpol);

 // Output PID
  SerialPort.println();
  SerialPort.print("- pid output: ");
  SerialPort.println(OutputPID);

 // motorspeed
  SerialPort.println();
  SerialPort.print("- motorspeed right: ");
  SerialPort.println(rightMotorSpeed);
  SerialPort.print("- motorspeed left: ");
  SerialPort.println(leftMotorSpeed);
  SerialPort.println();
}

void onReset()
{
  SerialPort.print("resetting parameters... ");
  EEPROM_resetAnything(0, params);
  EEPROM_readAnything(0, params);  
  SerialPort.println("done");
}

void onInterrupt()
{
  params.start = not params.start;
}

