'''
PIL_Logger.py - 
Part of the "Propeller Based Internet Logging Pill Dispenser" or "P.I.L. Box" Project
A Parallax microMedic 2013 Contest Entry by Tim Massaro

Created July, 2013

@author: tmassaro
#Serial code is based on an example I found here: 
#http://www.roborealm.com/forum/index.php?thread_id=3878

NOTE: This server must be started AFTER the P.I.L. Box is started
It uses the same COM port as the Propeller Tool uses for the Serial Terminal, 
thus no Serial Terminal output can be sent from the spin side 

'''
import sys
import serial                          # use PySerial to talk to the P.I.L. Box
import re                              # use regular expressions to determine twitterable msgs
import logging                         #python package that provides good file logging support
import datetime

__requires__ = 'twitter==1.10.0'

import twitter
from twitter import Twitter

def send_twitter(msg):
    	"""   
	send_twitter 
    	this app is registered with twitter so we can use REST to send msgs and the like
	My PIL Application https://dev.twitter.com/apps/4864995/show    
	Consumer key -> con_secret -> A5L0pUdcq1Pmgp4flZvpg	
	Consumer secret ->con_secret_key -> qGr4zIioUzfEzg2MH6C3Qy59AX6IoP2dQyZMKrSJtEI	
	Access token -> token -> 12983392-ShaDwMlcZqhCCM0wdk4RbWEbkleWr7iwQfj4b9rYQ	
	Access token secret -> token_key -> CUnh3OgJ3fCjuk5xIi8TBZMq3CkRUqIhmBCmFx8ejg
 	Followed instructions here to enable Twitter APIs
 	http://wilsonericn.wordpress.com/2011/08/22/tweeting-in-python-the-easy-way/  
    	"""

#	my_auth = twitter.OAuth(TOKEN,TOKEN_KEY,CON_SEC,CON_SEC_KEY)
	my_auth = twitter.OAuth("12983392-ShaDwMlcZqhCCM0wdk4RbWEbkleWr7iwQfj4b9rYQ", "CUnh3OgJ3fCjuk5xIi8TBZMq3CkRUqIhmBCmFx8ejg", "A5L0pUdcq1Pmgp4flZvpg",  "qGr4zIioUzfEzg2MH6C3Qy59AX6IoP2dQyZMKrSJtEI")
	twit = twitter.Twitter(auth=my_auth)
	twit.statuses.update(status=msg +  "#microMedic #PILboxMM ")
    	return 
   	
# Set up Serial Communication with the P.I.L. Box 
ser = serial.Serial()
ser.baudrate = 115200
ser.port = 'COM8'                      #Customize serial port here, this is the value seen on the Propeller Tool 
ser.open()
ser.flushInput()
#ser.timeout = 10                      #By default no timeout on Serial port  
logger = logging.getLogger('IPD')
hdlr = logging.FileHandler('microMedicPillLog.log')             			   #Customize name and location of file here
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')         #Customize format of log entry if desired here
hdlr.setFormatter(formatter)
logger.addHandler(hdlr) 
logger.setLevel(logging.INFO)
outputOld = -1
logger.info('Internet Pill Dispenser Starting:')
outputOld = "blah"
outputNew = ser.readline()   # P.I.L. Box starts by telling us it's time
logger.info('P.I.L. Box starting: ' + outputNew + " time.\n")
print ">>>>>>Server Starting with msg: " + outputNew
print ">>>>>>NOTE: Press Enter Button on P.I.L. Box\n"

while True:	
	outputNew = ser.readline()# read in a byte
	print "outputNew: " + outputNew
	if outputNew != outputOld:
		print ">>>>>>newoutput" + outputNew + "\n"
		outputOld = outputNew
		#TODO: Might be a problem if user presses same button twice in a row...check that out....
		if re.search(r"^Error,", outputNew):           #if the message begins with "Error,"
			logger.error(outputNew)                    #log as error rather than just info
 			send_twitter(outputNew)                    #send a tweet, that'd be sweet
		else:	
		    	logger.info(outputNew)
	
sys.exit()
 


