
/* ATTiny85 sketch for 78.125 KHz LED driver.
   External oscillator: 20 MHz
   Code contains settings for brightness levels.
   For 700 mA LEDs.
*/
int onTime = 0;
const int period = 255; // Determines the frequency and resolution.
const int maxOnTime = period * 0.5; // Determines the maximum output voltage. Do not exceed the ratings of the components.

int brightness;
const int brightnessTop = 4;
const int boostPwmPin = 1;
const int brightnessButtonPin = 0;
const int feedbackPin = A1;

// use two third for maximum

int feedbackReading;
int desiredFeedback;
const int debounceDelay = 100 * 64; // Compensated for prescalar selection and the change of clock speed.
boolean buttonReading;

void setup() {
  // put your setup code here, to run once:
  pinMode(boostPwmPin, OUTPUT);
  pinMode(brightnessButtonPin, INPUT_PULLUP);
  pinMode(feedbackPin, INPUT);
  TCCR0A = _BV(COM0B1) | _BV(WGM01) | _BV(WGM00);
  TCCR0B = _BV(WGM02) | _BV(CS00);
  OCR0A = period; // PWM period.
  OCR0B = 0; // On time.

  analogReference(INTERNAL);
}

void loop() {
  // put your main code here, to run repeatedly:
  buttonReading = digitalRead(brightnessButtonPin);
  feedbackReading = analogRead(feedbackPin);

  if (buttonReading == LOW) { // Pressing the button cycles through the drive current levels.
    OCR0B = 0;
    onTime = 0;

    delay(debounceDelay);
    if (brightness < brightnessTop) {
      brightness++;
    }
    else if (brightness >= brightnessTop) {
      brightness = 0;
    }
  }

  if (brightness == 0) {
    desiredFeedback = 0; // Determines the selected drive current.
  }
  else if (brightness == 1) {
    desiredFeedback = 67;
  }
  else if (brightness == 2) {
    desiredFeedback = 133;
  }
  else if (brightness == 3) {
    desiredFeedback = 266;
  }
  else if (brightness == 4) {
    desiredFeedback = 534;
  }

  // Keeps the drive current stable.
  if (feedbackReading < desiredFeedback && onTime < maxOnTime) {
    onTime++;
  }
  else if (feedbackReading > desiredFeedback && onTime > 0) {
    onTime--;
  }

  OCR0B = onTime;
}
