/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2016 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Translatable string constants for Accessible Blockly.
 * @author madeeha@google.com (Madeeha Ghori)
 */
'use strict';

Blockly.Msg.TOOLBOX = 'Toolbox';
Blockly.Msg.WORKSPACE = 'Workspace';
Blockly.Msg.TOOLBOX_BLOCK = 'toolbox block. Move right to view submenu.';
Blockly.Msg.WORKSPACE_BLOCK = 'workspace block. Move right to view submenu.';

Blockly.Msg.CLEAR_WORKSPACE = 'Erase Workspace';

Blockly.Msg.COPY_TO_CLIPBOARD = 'Copy to clipboard.';
Blockly.Msg.COPY_TO_MARKED_SPOT = 'Attach to link.';
Blockly.Msg.COPY_TO_WORKSPACE = 'Add to workspace.';

Blockly.Msg.COPY_BLOCK = 'Copy block.';
Blockly.Msg.DELETE = 'Delete block.';
Blockly.Msg.MARK_SPOT_BEFORE = 'Add link before.';
Blockly.Msg.MARK_SPOT_AFTER = 'Add link after.';
Blockly.Msg.MARK_THIS_SPOT = 'Add link inside.';
Blockly.Msg.MOVE_TO_MARKED_SPOT = 'Attach to link.';
Blockly.Msg.PASTE_AFTER = 'Paste after.';
Blockly.Msg.PASTE_BEFORE = 'Paste before.';
Blockly.Msg.PASTE_INSIDE = 'Paste inside.';

Blockly.Msg.ANY = 'any';
Blockly.Msg.BLOCK = 'block';
Blockly.Msg.BUTTON = 'Button.';
Blockly.Msg.FOR = 'for';
Blockly.Msg.VALUE = 'value';

Blockly.Msg.BLOCK_OPTIONS = 'Block options: ';

Blockly.Msg.BLOCK_MOVED_TO_MARKED_SPOT_MSB = 'Block moved to marked spot: ';
Blockly.Msg.COPIED_BLOCK_MSG = 'copied. ';
Blockly.Msg.MARKED_SPOT_MSG = 'Marked spot. ';
Blockly.Msg.PASTED_BLOCK_FROM_CLIPBOARD_MSG = 'pasted. ';
Blockly.Msg.PASTED_BLOCK_TO_MARKED_SPOT_MSG = 'moved to marked spot. ';
