//MODIFIED Version of Adafruit Trinket code to give attiny85 PCM capability
//The Attiny will take a very short sound sample that will sound good if looped
//I used the sound of a sonic screwdriver to example this capability
//Crete PCM using a program such as http://thieumsweb.free.fr/english/gbacss.html, copy the code right after PROGMEM = {    and make sure that it ends with the };
//I use 8000 as my sample rate as allows the longest soundbyte to be uploaded to the chip
/*
if you change the sample rate, alter the sample_rate value
Otherwise the program will create a looped sound on pin 4 of the attiny85
*/
// Audio playback sketch for Adafruit Trinket.  Requires 3.3V
// Trinket board and Winbond W25Q80BV serial flash loaded with
// audio data.  PWM output on pin 4; add ~25 KHz low-pass filter
// prior to amplification.  Uses ATtiny-specific registers;
// WILL NOT RUN ON OTHER ARDUINOS.



int sample_rate = 8000;
const unsigned char sample[] PROGMEM = {32, 242, 67, 102, 211, 46, 156, 163, 54, 197, 94, 112, 183, 56, 183, 112, 97, 187, 69, 158, 136, 87, 177, 95, 126, 164, 77, 162, 129, 95, 164, 115, 104, 174, 84, 146, 138, 101, 148, 129, 103, 161, 104, 131, 142, 107, 144, 122, 122, 143, 108, 145, 118, 127, 135, 119, 134, 125, 126, 130, 129, 115, 148, 108, 137, 129, 123, 125, 140, 110, 144, 111, 145, 110, 142, 118, 135, 119, 136, 124, 123, 137, 118, 132, 129, 123, 132, 126, 126, 135, 114, 145, 110, 137, 133, 102, 169, 83, 157, 125, 100, 171, 92, 131, 167, 56, 200, 91, 106, 199, 43, 175, 151, 42, 221, 93, 72, 244, 26, 148, 195, 24, 196, 132, 62, 209, 74, 130, 174, 53, 199, 89, 116, 181, 59, 179, 115, 99, 181, 76, 151, 145, 80, 176, 108, 105, 174, 91, 125, 170, 72, 159, 140, 80, 176, 109, 107, 169, 93, 139, 139, 104, 150, 114, 127, 142, 104, 152, 111, 132, 132, 118, 137, 123, 125, 135, 122, 124, 140, 112, 139, 121, 134, 116, 143, 110, 143, 113, 143, 112, 142, 115, 137, 123, 127, 133, 119, 138, 115, 139, 121, 124, 139, 114, 134, 135, 107, 154, 106, 133, 145, 89, 177, 83, 153, 129, 97, 175, 86, 137, 165, 51, 211, 75, 121, 192, 34, 201, 119, 59, 234, 54, 113, 225, 11, 184, 165, 31, 213, 106, 79, 210, 60, 148, 162, 55, 207, 75, 131, 173, 56, 191, 101, 107, 184, 65, 165, 134, 80, 189, 88, 122, 176, 69, 154, 153, 66, 182, 119, 84, 192, 82, 132, 156, 92, 148, 131, 104, 160, 99, 142, 130, 111, 149, 110, 137, 127, 120, 137, 123, 124, 137, 119, 131, 130, 122, 136, 116, 143, 112, 140, 116, 141, 113, 138, 124, 126, 129, 128, 129, 121, 139, 115, 138, 118, 137, 119, 131, 131, 119, 135, 127, 118, 145, 110, 137, 133, 103, 167, 82, 165, 114, 105, 181, 66, 164, 141, 63, 217, 54, 148, 178, 26, 228, 90, 70, 250, 17, 154, 201, 6, 216, 121, 61, 212, 79, 115, 186, 61, 166, 135, 79, 193, 74, 146, 151, 73, 188, 91, 121, 175, 64, 174, 124, 84, 197, 70, 140, 170, 57, 180, 128, 75, 193, 96, 104, 189, 67, 157, 136, 99, 152, 127, 102, 168, 90, 149, 122, 122, 137, 117, 135, 126, 122, 137, 121, 125, 136, 117, 136, 121, 131, 130, 117, 141, 118, 130, 126, 132, 120, 132, 131, 121, 132, 127, 128, 122, 140, 112, 141, 118, 134, 125, 128, 130, 123, 131, 130, 116, 147, 109, 134, 141, 95, 171, 86, 151, 134, 86, 190, 72, 147, 158, 56, 212, 68, 131, 191, 21, 223, 102, 60, 252, 21, 152, 195, 18, 208, 119, 72, 202, 84, 115, 182, 69, 154, 147, 77, 180, 96, 126, 157, 82, 168, 111, 106, 180, 67, 164, 136, 75, 198, 76, 130, 175, 57, 178, 124, 90, 175, 107, 106, 178, 76, 155, 131, 105, 146, 131, 99, 165, 98, 142, 122, 133, 118, 136, 122, 131, 122, 134, 124, 125, 134, 121, 133, 124, 128, 132, 119, 136, 125, 124, 133, 123, 131, 124, 131, 125, 129, 125, 134, 117, 139, 119, 131, 130, 121, 134, 126, 122, 138, 115, 140, 114, 142, 116, 131, 138, 102, 166, 86, 158, 124, 95, 188, 64, 163, 143, 60, 226, 40, 158, 178, 15, 244, 72, 91, 231, 21, 177, 157, 45, 211, 88, 110, 180, 79, 141, 152, 89, 151, 135, 97, 161, 110, 122, 153, 91, 162, 110, 117, 166, 77, 163, 129, 83, 195, 73, 138, 167, 61, 186, 104, 114, 156, 109, 120, 161, 85, 160, 119, 114, 145, 123, 113, 152, 107, 140, 119, 137, 116, 138, 120, 135, 118, 137, 121, 127, 135, 116, 138, 122, 125, 135, 122, 126, 136, 117, 134, 126, 127, 127, 129, 126, 131, 120, 138, 117, 133, 129, 120, 140, 115, 138, 123, 126, 135, 115, 146, 102, 155, 107, 131, 147, 86, 182, 75, 160, 130, 87, 196, 53, 179, 125, 68, 237, 8, 202, 137, 38, 248, 40, 137, 192, 30, 203, 111, 84, 200, 69, 140, 160, 77, 161, 129, 100, 156, 118, 114, 154, 104, 136, 137, 103, 159, 102, 136, 142, 96, 157, 123, 96, 185, 72, 150, 152, 69, 192, 84, 139, 140, 110, 131, 148, 91, 163, 109, 126, 138, 121, 125, 136, 121, 131, 124, 134, 118, 137, 120, 132, 125, 128, 129, 123, 135, 118, 136, 123, 126, 132, 126, 123, 135, 123, 127, 131, 124, 129, 127, 127, 129, 124, 132, 125, 126, 135, 114, 145, 108, 144, 118, 129, 134, 112, 153, 92, 166, 98, 136, 147, 83, 187, 69, 169, 115, 104, 186, 46, 207, 84, 109, 212, 8, 231, 87, 92, 215, 36, 180, 135, 70, 203, 72, 140, 155, 83, 158, 125, 109, 148, 121, 118, 144, 115, 129, 136, 114, 140, 121, 125, 137, 117, 132, 136, 109, 144, 127, 104, 169, 87, 147, 140, 86, 183, 76, 161, 115, 128, 124, 145, 96, 162, 103, 137, 128, 125, 127, 131, 124, 129, 128, 127, 126, 132, 122, 133, 125, 126, 132, 121, 134, 123, 129, 129, 126, 129, 127, 129, 125, 130, 128, 124, 129, 132, 116, 141, 118, 131, 129, 126, 125, 136, 111, 150, 101, 152, 110, 135, 132, 112, 154, 92, 169, 89, 153, 123, 106, 174, 64, 195, 75, 146, 158, 50, 229, 42, 160, 163, 41, 226, 59, 142, 167, 57, 195, 91, 119, 174, 67, 174, 111, 116, 152, 107, 135, 132, 120, 131, 130, 120, 137, 120, 131, 129, 121, 137, 116, 140, 114, 142, 116, 129, 141, 97, 168, 88, 153, 126, 103, 174, 70, 182, 88, 150, 116, 138, 111, 149, 109, 137, 129, 121, 132, 129, 123, 130, 130, 121, 134, 124, 125, 134, 119, 134, 126, 125, 133, 123, 129, 128, 127, 127, 129, 127, 126, 129, 127, 127, 127, 133, 116, 141, 115, 138, 116, 142, 110, 148, 105, 152, 102, 153, 106, 142, 122, 122, 144, 98, 170, 77, 173, 102, 121, 170, 56, 209, 60, 159, 145, 64, 219, 40, 181, 124, 84, 197, 63, 161, 138, 79, 193, 73, 149, 144, 87, 170, 101, 131, 139, 114, 135, 126, 126, 130, 125, 128, 131, 118, 144, 110, 138, 132, 107, 159, 93, 153, 120, 113, 162, 80, 176, 88, 150, 126, 108, 165, 78, 180, 82, 160, 109, 136, 124, 126, 135, 114, 144, 113, 136, 123, 132, 119, 140, 115, 138, 120, 135, 119, 135, 121, 133, 122, 132, 125, 129, 126, 132, 118, 139, 117, 135, 123, 132, 123, 129, 132, 114, 148, 106, 145, 114, 142, 108, 154, 99, 154, 105, 146, 114, 133, 130, 114, 155, 86, 177, 80, 161, 118, 108, 173, 67, 188, 84, 138, 156, 70, 199, 63, 167, 123, 100, 172, 85, 149, 137, 90, 180, 80, 152, 133, 100, 158, 104, 145, 113, 141, 119, 128, 135, 120, 125, 140, 117, 123, 154, 87, 162, 120, 100, 180, 73, 161, 127, 93, 185, 64, 177, 105, 121, 157, 85, 174, 82, 164, 104, 136, 131, 115, 146, 106, 154, 99, 154, 108, 139, 121, 134, 116, 144, 109, 145, 111, 145, 109, 144, 118, 129, 131, 127, 123, 139, 111, 146, 110, 141, 120, 126, 136, 118, 137, 118, 141, 107, 154, 99, 152, 110, 138, 121, 136, 114, 145, 114, 133, 130, 115, 150, 93, 171, 78, 178, 89, 145, 136, 93, 180, 72, 167, 115, 110, 175, 64, 189, 88, 138, 141, 98, 159, 103, 138, 137, 97, 168, 95, 141, 135, 103, 158, 99, 153, 101, 153, 116, 118, 156, 95, 144, 135, 108, 130, 158, 75, 173, 117, 92, 196, 59, 163, 142, 67, 210, 52, 171, 127, 89, 193, 57, 184, 94, 136, 140, 100, 162, 91, 163, 96, 154, 105, 148, 110, 139, 120, 133, 121, 137, 116, 145, 103, 156, 101, 143, 126, 115, 144, 118, 122, 149, 98, 158, 107, 132, 135, 114, 144, 110, 146, 111, 143, 113, 141, 115, 134, 129, 120, 136, 120, 135, 121, 137, 109, 160, 83, 179, 71, 184, 75, 172, 101, 130, 150, 91, 165, 94, 147, 133, 92, 185, 63, 182, 100, 123, 156, 90, 156, 117, 119, 144, 110, 145, 117, 125, 145, 104, 149, 108, 146, 106, 148, 125, 99, 185, 69, 161, 129, 101, 147, 144, 71, 193, 96, 104, 196, 53, 166, 146, 58, 221, 43, 173, 135, 73, 209, 45, 186, 109, 104, 179, 63, 189, 80, 157, 115, 131, 128, 130, 116, 145, 109, 138, 127, 125, 127, 139, 105, 155, 106, 132, 142, 98, 159, 107, 125, 156, 85, 167, 106, 124, 152, 91, 160, 104, 143, 116, 140, 116, 135, 127, 121, 137, 113, 145, 109, 147, 107, 153, 96, 168, 79, 179, 75, 177, 87, 149, 129, 107, 162, 89, 159, 112, 127, 141, 101, 166, 86, 160, 118, 110, 165, 90, 150, 122, 119, 139, 123, 123, 140, 115, 141, 116, 133, 121, 141, 106, 146, 128, 93, 200, 42, 186, 124, 83, 180, 110, 89, 203, 64, 137, 179, 47, 190, 117, 81, 205, 53, 168, 135, 75, 208, 47, 188, 106, 104, 185, 56, 189, 88, 142, 136, 107, 151, 113, 127, 139, 115, 127, 144, 102, 148, 124, 116, 147, 113, 124, 153, 86, 167, 103, 130, 150, 88, 169, 108, 110, 175, 69, 175, 101, 136, 127, 127, 128, 129, 128, 122, 136, 117, 140, 109, 153, 98, 159, 101, 151, 99, 162, 94, 147, 124, 113, 161, 83, 170, 99, 141, 125, 125, 130, 124, 133, 121, 129, 136, 110, 152, 105, 138, 131, 119, 125, 147, 96, 160, 110, 127, 142, 109, 143, 122, 114, 149, 121, 99, 196, 38, 204, 103, 88, 201, 72, 122, 194, 42, 176, 148, 56, 205, 89, 110, 186, 60, 173, 119, 99, 181, 70, 170, 112, 113, 168, 70, 184, 82, 154, 122, 113, 156, 101, 137, 138, 107, 137, 139, 98, 157, 119, 110, 162, 95, 143, 134, 101, 162, 102, 130, 149, 92, 161, 113, 115, 161, 89, 154, 118, 125, 132, 125, 133, 114, 148, 108, 141, 119, 134, 112, 156, 91, 163, 102, 141, 124, 133, 113, 144, 123, 113, 157, 90, 163, 106, 130, 139, 111, 141, 120, 128, 130, 122, 138, 116, 136, 128, 116, 148, 106, 133, 148, 87, 170, 106, 115, 174, 69, 174, 106, 117, 162, 91, 133, 174, 42, 217, 80, 105, 206, 44, 156, 174, 34, 207, 113, 75, 208, 73, 129, 173, 61, 184, 99, 124, 155, 89, 166, 101, 137, 139, 94, 177, 71, 174, 106, 117, 168, 80, 155, 137, 92, 158, 124, 101, 162, 110, 116, 164, 87, 154, 124, 112, 149, 112, 128, 144, 102, 153, 113, 128, 140, 111, 139, 121, 131, 124, 128, 134, 115, 143, 117, 131, 127, 130, 118, 144, 104, 149, 116, 129, 131, 126, 124, 136, 122, 120, 149, 101, 151, 116, 127, 139, 113, 139, 119, 132, 127, 123, 136, 119, 132, 134, 110, 152, 104, 137, 141, 90, 172, 99, 126, 164, 70, 182, 100, 116, 173, 67, 169, 136, 63, 217, 69, 115, 213, 16, 194, 147, 35, 230, 80, 96, 210, 52, 154, 156, 69, 183, 96, 128, 150, 93, 164, 99, 144, 126, 113, 158, 81, 176, 97, 121, 173, 66, 172, 128, 85, 180, 104, 105, 178, 84, 136, 157, 81, 167, 113, 117, 150, 109, 130, 143, 102, 150, 119, 122, 143, 110, 142, 116, 136, 121, 128, 134, 118, 132, 137, 106, 154, 107, 135, 130, 118, 140, 120, 126, 140, 111, 142, 117, 135, 117, 143, 109, 142, 121, 129, 128, 129, 124, 130, 129, 123, 127, 137, 114, 137, 131, 108, 157, 100, 139, 141, 86, 184, 80, 142, 155, 70, 191, 89, 118, 186, 44, 194, 115, 74, 220, 54, 130, 207, 8, 216, 122, 52, 229, 67, 115, 195, 53, 167, 134, 94, 163, 105, 134, 134, 113, 146, 110, 142, 120, 126, 141, 100, 165, 95, 134, 157, 73, 174, 122, 86, 192, 81, 126, 170, 77, 151, 146, 81, 176, 101, 127, 146, 110, 129, 145, 100, 149, 122, 117, 143, 118, 126, 135, 120, 130, 127, 130, 123, 131, 131, 117, 142, 114, 138, 119, 136, 120, 132, 125, 133, 116, 143, 113, 138, 118, 137, 116, 137, 125, 122, 134, 126, 120, 143, 110, 143, 117, 131, 132, 113, 152, 97, 155, 114, 119, 161, 74, 186, 86, 130, 172, 52, 201, 93, 101, 207, 30, 194, 129, 56, 229, 57, 119, 218, 4, 214, 125, 54, 221, 77, 105, 201, 52, 163, 139, 91, 163, 109, 130, 135, 113, 148, 103, 151, 112, 129, 143, 97, 164, 100, 129, 159, 77, 167, 130, 78, 199, 75, 131, 168, 74, 157, 138, 90, 164, 116, 109, 161, 99, 136, 138, 108, 141, 128, 115, 141, 124, 118, 143, 116, 130, 133, 121, 130, 127, 129, 122, 136, 119, 135, 118, 139, 115, 137, 121, 134, 118, 139, 116, 135, 125, 128, 127, 129, 127, 126, 129, 130, 119, 142, 112, 141, 120, 127, 140, 100, 167, 84, 162, 116, 107, 177, 61, 189, 96, 113, 190, 37, 209, 91, 98, 211, 29, 189, 138, 44, 244, 40, 138, 198, 21, 205, 123, 63, 212, 82, 105, 199, 54, 163, 140, 88, 164, 112, 124, 139, 118, 134, 120, 138, 115, 137, 127, 115, 149, 108, 133, 144, 97, 151, 134, 86, 184, 88, 125, 169, 74, 159, 132, 98, 154, 130, 92, 181, 79, 154, 124, 118, 135, 132, 110, 150, 110, 136, 126, 127, 125, 133, 121, 134, 124, 129, 127, 128, 127, 130, 121, 139, 115, 137, 125, 124, 132, 126, 123, 136, 116, 139, 118, 135, 122, 133, 120, 139, 111, 148, 107, 144, 118, 127, 142, 98, 171, 80, 164, 115, 106, 183, 51, 200, 85, 121, 185, 36, 218, 74, 119, 195, 33, 201
};

int fish = 0;
int sizesample = sizeof(sample);

void setup() {

  PLLCSR |= _BV(PLLE);               // Enable 64 MHz PLL
  delayMicroseconds(100);            // Stabilize
  while(!(PLLCSR & _BV(PLOCK)));     // Wait for it...
  PLLCSR |= _BV(PCKE);               // Timer1 source = PLL

  // Set up Timer/Counter1 for PWM output
  TIMSK  = 0;                        // Timer interrupts OFF
  TCCR1  = _BV(CS10);                // 1:1 prescale
  GTCCR  = _BV(PWM1B) | _BV(COM1B1); // PWM B, clear on match
  OCR1C  = 255;                      // Full 8-bit PWM cycle
  OCR1B  = 127;                      // 50% duty at start

  pinMode(4, OUTPUT);                // Enable PWM output pin

  // Set up Timer/Counter0 for sample-playing interrupt.
  // TIMER0_OVF_vect is already in use by the Arduino runtime,
  // so TIMER0_COMPA_vect is used.  This code alters the timer
  // interval, making delay(), micros(), etc. useless (the
  // overflow interrupt is therefore disabled).

  // Timer resolution is limited to either 0.125 or 1.0 uS,
  // so it's rare that the playback rate will precisely match
  // the data, but the difference is usually imperceptible.
  TCCR0A = _BV(WGM01) | _BV(WGM00);  // Mode 7 (fast PWM)
  if(sample_rate >= 31250) {
    TCCR0B = _BV(WGM02) | _BV(CS00); // 1:1 prescale
    OCR0A  = ((F_CPU + (sample_rate / 2)) / sample_rate) - 1;
  } else {                           // Good down to about 3900 Hz
    TCCR0B = _BV(WGM02) | _BV(CS01); // 1:8 prescale
    OCR0A  = (((F_CPU / 8L) + (sample_rate / 2)) / sample_rate) - 1;
  }
  TIMSK = _BV(OCIE0A); // Enable compare match, disable overflow
}

void loop() { 
delay(1000);
}

ISR(TIMER0_COMPA_vect) {
  OCR1B = pgm_read_byte(&sample[fish]);      // Read flash, write PWM reg.
  fish ++;
  if (fish >= sizesample){fish = 0;}
  /*
  if(++index >= samples) {           // End of audio data?
    index = 0;                       // We must repeat!
    flash.endRead();
    flash.beginRead(6);              // Skip 6 byte header
  }
  */
}

