/* test program to demonstration LCD & Joystick, using a menu */
#include "Nokia_lcd.h"
#include <avr/pgmspace.h>


#define BL_PIN 8

//keypad debounce parameter
#define DEBOUNCE_MAX 15
#define DEBOUNCE_ON  10
#define DEBOUNCE_OFF 3 

#define NUM_KEYS 5

// joystick number
#define UP_KEY 3
#define LEFT_KEY 0
#define CENTER_KEY 1
#define DOWN_KEY 2
#define RIGHT_KEY 4

// adc preset value, represent top value,incl. noise & margin,that the adc reads, when a key is pressed
// set noise & margin = 30 (0.15V@5V)
int  adc_key_val[NUM_KEYS] ={30, 128, 260, 374, 515 };
// debounce counters
byte button_count[NUM_KEYS];
// button status - pressed/released
byte button_status[NUM_KEYS];
// button on flags for user program 
byte button_flag[NUM_KEYS];

Nokia_lcd lcd=Nokia_lcd();

void InitPort(){
  DDRB=0x2F;
}

 // incoming serial byte
int inByte = 0;        
//actual pixel position
int x =0;
int y=0;


void setup(void){

    // setup interrupt-driven keypad arrays  
   // reset button arrays
   for(byte i=0; i<NUM_KEYS; i++){
     button_count[i]=0;
     button_status[i]=0;
     button_flag[i]=0;
   }
  
  // Setup timer2 -- Prescaler/256
  TCCR2A &= ~((1<<WGM21) | (1<<WGM20));
  TCCR2B &= ~(1<<WGM22);
  TCCR2B = (1<<CS22)|(1<<CS21);      
  
  ASSR |=(0<<AS2);

   // Use normal mode  
   TCCR2A =0;    
     //Timer2 Overflow Interrupt Enable  
     TIMSK2 |= (0<<OCIE2A);
     TCNT2=0x6;  // counting starts from 6;  
   TIMSK2 = (1<<TOIE2);    
   
       
  SREG|=1<<SREG_I;
  
  InitPort();
  //LCD_BACKLIGHT(1);
  digitalWrite(BL_PIN, HIGH);   // turn on backlight
  //Initialize menu
  lcd.cLCD_Init();
  lcd.cLCD_Box(0,0,131,131,FILL,LIGHTBLUE);
   //menu initialization
   //init_MENU();
   lcd.cLCD_String("QR-CLOCK", 35, 65, BLACK, LIGHTBLUE);
   

   Serial.begin(9600);
}

void loop(void)
{
  
    byte i;
    for(i=0; i<NUM_KEYS; i++){
       if(button_flag[i] !=0){
            
            button_flag[i]=0;  // reset button flag
			switch(i){

				case UP_KEY:
                                        digitalWrite(BL_PIN, HIGH);   // turn on backlight
					break;
				case DOWN_KEY:
				        digitalWrite(BL_PIN, LOW);   // turn on backlight
					break;
				case LEFT_KEY:
                                     
					break;   
				case RIGHT_KEY:
                                                
					break;	
			}
				
		}
    }
    
if (Serial.available()) {
    // get the new byte:
    char inChar = (char)Serial.read(); 
    if (inChar == 'w') {
      lcd.cLCD_Box(x,y,x+1,y+1,FILL,WHITE);
      x++;
    }
    if (inChar == 'l') {
      x=0;
      y++;
    }  
    if (inChar == 'b') {
      lcd.cLCD_Box(x,y,x+1,y+1,FILL,BLACK);
      x++;
    } 
    if (inChar == 's') {
      //lcd.cLCD_Box(0,0,131,131,FILL,WHITE);
      x=0;
      y=0;
    }
    if (inChar == 'e') {
      x=0;
      y=0;
    }
  }    
    
}

         
// waiting for center key press
void waitfor_OKkey(){
  byte i;
  byte key = 0xFF;
	while (key!= CENTER_KEY){
    for(i=0; i<NUM_KEYS; i++){
       if(button_flag[i] !=0){
           button_flag[i]=0;  // reset button flag
           if(i== CENTER_KEY) key=CENTER_KEY;
        }
     }
   }
		
}

void charmap(){
  byte i,j;
  lcd.cLCD_Box(10, 5, 120,  110, FILL, WHITE);  // OK button
  for(i=0; i<10; i++){
    for(j=0; j<10; j++){
      if(i*10+j<97){
        lcd.cLCD_Char(i*10+j+0x1F,  j*10+15, i*10+10, BLACK, CYAN);
      }
    }
  }
  lcd.cLCD_Box(50, 115, 80, 127, FILL, BLUE);  // OK button
  lcd.cLCD_String("OK", 56, 117, WHITE, BLUE);
  waitfor_OKkey();
      
}

	

// The followinging are interrupt-driven keypad reading 
//  which includes DEBOUNCE ON/OFF mechanism, and continuous pressing detection


// Convert ADC value to key number
char get_key(unsigned int input)
{
	char k;
    
	for (k = 0; k < NUM_KEYS; k++)
	{
		if (input < adc_key_val[k])
		{
           
    return k;
        }
	}
    
    if (k >= NUM_KEYS)
        k = -1;     // No valid key pressed
    
    return k;
}

void update_adc_key(){
  int adc_key_in;
  char key_in;
  byte i;
  
  adc_key_in = analogRead(0);
  key_in = get_key(adc_key_in);
  for(i=0; i<NUM_KEYS; i++)
  {
    if(key_in==i)  //one key is pressed 
    { 
      if(button_count[i]<DEBOUNCE_MAX)
      {
        button_count[i]++;
        if(button_count[i]>DEBOUNCE_ON)
        {
          if(button_status[i] == 0)
          {
            button_flag[i] = 1;
            button_status[i] = 1; //button debounced to 'pressed' status
          }
		  
        }
      }
	
    }
    else // no button pressed
    {
      if (button_count[i] >0)
      {  
		button_flag[i] = 0;	
		button_count[i]--;
        if(button_count[i]<DEBOUNCE_OFF){
          button_status[i]=0;   //button debounced to 'released' status
        }
      }
    }
    
  }
}

// Timer2 interrupt routine -
// 1/(160000000/256/(256-6)) = 4ms interval

ISR(TIMER2_OVF_vect) {  
  TCNT2  = 6;
  update_adc_key();
}





