/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.rsa.RSAPadding;
import sun.security.rsa.RSASignature;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

final class P11Signature
extends SignatureSpi {
    private final Token token;
    private final String algorithm;
    private final String keyAlgorithm;
    private final long mechanism;
    private final ObjectIdentifier digestOID;
    private final int type;
    private P11Key p11Key;
    private final MessageDigest md;
    private Session session;
    private int mode;
    private boolean initialized;
    private final byte[] buffer;
    private int bytesProcessed;
    private static final int M_SIGN = 1;
    private static final int M_VERIFY = 2;
    private static final int T_DIGEST = 1;
    private static final int T_UPDATE = 2;
    private static final int T_RAW = 3;
    private static final int RAW_ECDSA_MAX = 128;

    P11Signature(Token token, String string, long l) throws NoSuchAlgorithmException, PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        switch ((int)l) {
            case 4: 
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 66: {
                this.keyAlgorithm = "RSA";
                this.type = 2;
                this.digestOID = null;
                this.buffer = new byte[1];
                this.md = null;
                break;
            }
            case 18: {
                this.keyAlgorithm = "DSA";
                this.type = 2;
                this.digestOID = null;
                this.buffer = new byte[1];
                this.md = null;
                break;
            }
            case 4162: {
                this.keyAlgorithm = "EC";
                this.type = 2;
                this.digestOID = null;
                this.buffer = new byte[1];
                this.md = null;
                break;
            }
            case 17: {
                this.keyAlgorithm = "DSA";
                this.digestOID = null;
                if (string.equals("DSA")) {
                    this.type = 1;
                    this.md = MessageDigest.getInstance("SHA-1");
                    this.buffer = null;
                    break;
                }
                if (string.equals("RawDSA")) {
                    this.type = 3;
                    this.md = null;
                    this.buffer = new byte[20];
                    break;
                }
                throw new ProviderException(string);
            }
            case 4161: {
                String string2;
                this.keyAlgorithm = "EC";
                this.digestOID = null;
                if (string.equals("NONEwithECDSA")) {
                    this.type = 3;
                    this.md = null;
                    this.buffer = new byte[128];
                    break;
                }
                if (string.equals("SHA1withECDSA")) {
                    string2 = "SHA-1";
                } else if (string.equals("SHA256withECDSA")) {
                    string2 = "SHA-256";
                } else if (string.equals("SHA384withECDSA")) {
                    string2 = "SHA-384";
                } else if (string.equals("SHA512withECDSA")) {
                    string2 = "SHA-512";
                } else {
                    throw new ProviderException(string);
                }
                this.type = 1;
                this.md = MessageDigest.getInstance(string2);
                this.buffer = null;
                break;
            }
            case 1: 
            case 3: {
                this.keyAlgorithm = "RSA";
                this.type = 1;
                this.buffer = null;
                if (string.equals("MD5withRSA")) {
                    this.md = MessageDigest.getInstance("MD5");
                    this.digestOID = AlgorithmId.MD5_oid;
                    break;
                }
                if (string.equals("SHA1withRSA")) {
                    this.md = MessageDigest.getInstance("SHA-1");
                    this.digestOID = AlgorithmId.SHA_oid;
                    break;
                }
                if (string.equals("MD2withRSA")) {
                    this.md = MessageDigest.getInstance("MD2");
                    this.digestOID = AlgorithmId.MD2_oid;
                    break;
                }
                if (string.equals("SHA256withRSA")) {
                    this.md = MessageDigest.getInstance("SHA-256");
                    this.digestOID = AlgorithmId.SHA256_oid;
                    break;
                }
                if (string.equals("SHA384withRSA")) {
                    this.md = MessageDigest.getInstance("SHA-384");
                    this.digestOID = AlgorithmId.SHA384_oid;
                    break;
                }
                if (string.equals("SHA512withRSA")) {
                    this.md = MessageDigest.getInstance("SHA-512");
                    this.digestOID = AlgorithmId.SHA512_oid;
                    break;
                }
                throw new ProviderException("Unknown signature: " + string);
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + l);
            }
        }
        this.session = token.getOpSession();
    }

    private void ensureInitialized() {
        this.token.ensureValid();
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        if (!this.session.hasObjects()) {
            this.session = this.token.killSession(this.session);
            return;
        }
        if (this.mode == 1) {
            try {
                if (this.type == 2) {
                    this.token.p11.C_SignFinal(this.session.id(), 0);
                }
                byte[] byArray = this.type == 1 ? this.md.digest() : this.buffer;
                this.token.p11.C_Sign(this.session.id(), byArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException("cancel failed", pKCS11Exception);
            }
        } else {
            try {
                byte[] byArray = this.keyAlgorithm.equals("DSA") ? new byte[40] : new byte[this.p11Key.keyLength() + 7 >> 3];
                if (this.type == 2) {
                    this.token.p11.C_VerifyFinal(this.session.id(), byArray);
                } else {
                    byte[] byArray2 = this.type == 1 ? this.md.digest() : this.buffer;
                    this.token.p11.C_Verify(this.session.id(), byArray2, byArray);
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                // empty catch block
            }
        }
    }

    private void initialize() {
        try {
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            if (this.mode == 1) {
                this.token.p11.C_SignInit(this.session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
            } else {
                this.token.p11.C_VerifyInit(this.session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
            }
            this.initialized = true;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Initialization failed", pKCS11Exception);
        }
        if (this.bytesProcessed != 0) {
            this.bytesProcessed = 0;
            if (this.md != null) {
                this.md.reset();
            }
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.cancelOperation();
        this.mode = 2;
        this.p11Key = P11KeyFactory.convertKey(this.token, publicKey, this.keyAlgorithm);
        this.initialize();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.cancelOperation();
        this.mode = 1;
        this.p11Key = P11KeyFactory.convertKey(this.token, privateKey, this.keyAlgorithm);
        this.initialize();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.ensureInitialized();
        switch (this.type) {
            case 2: {
                this.buffer[0] = by;
                this.engineUpdate(this.buffer, 0, 1);
                break;
            }
            case 1: {
                this.md.update(by);
                ++this.bytesProcessed;
                break;
            }
            case 3: {
                if (this.bytesProcessed >= this.buffer.length) {
                    this.bytesProcessed = this.buffer.length + 1;
                    return;
                }
                this.buffer[this.bytesProcessed++] = by;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureInitialized();
        if (n2 == 0) {
            return;
        }
        switch (this.type) {
            case 2: {
                try {
                    if (this.mode == 1) {
                        this.token.p11.C_SignUpdate(this.session.id(), 0L, byArray, n, n2);
                    } else {
                        this.token.p11.C_VerifyUpdate(this.session.id(), 0L, byArray, n, n2);
                    }
                    this.bytesProcessed += n2;
                    break;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    throw new ProviderException(pKCS11Exception);
                }
            }
            case 1: {
                this.md.update(byArray, n, n2);
                this.bytesProcessed += n2;
                break;
            }
            case 3: {
                if (this.bytesProcessed + n2 > this.buffer.length) {
                    this.bytesProcessed = this.buffer.length + 1;
                    return;
                }
                System.arraycopy(byArray, n, this.buffer, this.bytesProcessed, n2);
                this.bytesProcessed += n2;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.ensureInitialized();
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return;
        }
        switch (this.type) {
            case 2: {
                if (!(byteBuffer instanceof DirectBuffer)) {
                    super.engineUpdate(byteBuffer);
                    return;
                }
                long l = ((DirectBuffer)((Object)byteBuffer)).address();
                int n2 = byteBuffer.position();
                try {
                    if (this.mode == 1) {
                        this.token.p11.C_SignUpdate(this.session.id(), l + (long)n2, null, 0, n);
                    } else {
                        this.token.p11.C_VerifyUpdate(this.session.id(), l + (long)n2, null, 0, n);
                    }
                    this.bytesProcessed += n;
                    byteBuffer.position(n2 + n);
                    break;
                }
                catch (PKCS11Exception pKCS11Exception) {
                    throw new ProviderException("Update failed", pKCS11Exception);
                }
            }
            case 1: {
                this.md.update(byteBuffer);
                this.bytesProcessed += n;
                break;
            }
            case 3: {
                if (this.bytesProcessed + n > this.buffer.length) {
                    this.bytesProcessed = this.buffer.length + 1;
                    return;
                }
                byteBuffer.get(this.buffer, this.bytesProcessed, n);
                this.bytesProcessed += n;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    protected byte[] engineSign() throws SignatureException {
        this.ensureInitialized();
        try {
            byte[] byArray;
            if (this.type == 2) {
                int n = this.keyAlgorithm.equals("DSA") ? 40 : 0;
                byArray = this.token.p11.C_SignFinal(this.session.id(), n);
            } else {
                byte[] byArray2;
                if (this.type == 1) {
                    byArray2 = this.md.digest();
                } else if (this.mechanism == 17L) {
                    if (this.bytesProcessed != this.buffer.length) {
                        throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
                    }
                    byArray2 = this.buffer;
                } else {
                    if (this.bytesProcessed > this.buffer.length) {
                        throw new SignatureException("Data for NONEwithECDSA must be at most 128 bytes long");
                    }
                    byArray2 = new byte[this.bytesProcessed];
                    System.arraycopy(this.buffer, 0, byArray2, 0, this.bytesProcessed);
                }
                if (!this.keyAlgorithm.equals("RSA")) {
                    byArray = this.token.p11.C_Sign(this.session.id(), byArray2);
                } else {
                    byte[] byArray3 = this.encodeSignature(byArray2);
                    if (this.mechanism == 3L) {
                        byArray3 = this.pkcs1Pad(byArray3);
                    }
                    byArray = this.token.p11.C_Sign(this.session.id(), byArray3);
                }
            }
            if (!this.keyAlgorithm.equals("RSA")) {
                byte[] byArray4 = P11Signature.dsaToASN1(byArray);
                return byArray4;
            }
            byte[] byArray5 = byArray;
            return byArray5;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException(pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.session = this.token.releaseSession(this.session);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        this.ensureInitialized();
        try {
            if (this.keyAlgorithm.equals("DSA")) {
                byArray = P11Signature.asn1ToDSA(byArray);
            } else if (this.keyAlgorithm.equals("EC")) {
                byArray = this.asn1ToECDSA(byArray);
            }
            if (this.type == 2) {
                this.token.p11.C_VerifyFinal(this.session.id(), byArray);
            } else {
                byte[] byArray2;
                if (this.type == 1) {
                    byArray2 = this.md.digest();
                } else if (this.mechanism == 17L) {
                    if (this.bytesProcessed != this.buffer.length) {
                        throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
                    }
                    byArray2 = this.buffer;
                } else {
                    if (this.bytesProcessed > this.buffer.length) {
                        throw new SignatureException("Data for NONEwithECDSA must be at most 128 bytes long");
                    }
                    byArray2 = new byte[this.bytesProcessed];
                    System.arraycopy(this.buffer, 0, byArray2, 0, this.bytesProcessed);
                }
                if (!this.keyAlgorithm.equals("RSA")) {
                    this.token.p11.C_Verify(this.session.id(), byArray2, byArray);
                } else {
                    byte[] byArray3 = this.encodeSignature(byArray2);
                    if (this.mechanism == 3L) {
                        byArray3 = this.pkcs1Pad(byArray3);
                    }
                    this.token.p11.C_Verify(this.session.id(), byArray3, byArray);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (PKCS11Exception pKCS11Exception) {
            long l = pKCS11Exception.getErrorCode();
            if (l == 192L) {
                boolean bl = false;
                return bl;
            }
            if (l == 193L) {
                boolean bl = false;
                return bl;
            }
            if (l == 33L) {
                boolean bl = false;
                return bl;
            }
            throw new ProviderException(pKCS11Exception);
        }
        finally {
            this.initialized = false;
            this.session = this.token.releaseSession(this.session);
        }
    }

    private byte[] pkcs1Pad(byte[] byArray) {
        try {
            int n = this.p11Key.keyLength() + 7 >> 3;
            RSAPadding rSAPadding = RSAPadding.getInstance(1, n);
            byte[] byArray2 = rSAPadding.pad(byArray);
            return byArray2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ProviderException(generalSecurityException);
        }
    }

    private byte[] encodeSignature(byte[] byArray) throws SignatureException {
        try {
            return RSASignature.encodeSignature((ObjectIdentifier)this.digestOID, (byte[])byArray);
        }
        catch (IOException iOException) {
            throw new SignatureException("Invalid encoding", iOException);
        }
    }

    private static byte[] dsaToASN1(byte[] byArray) {
        int n = byArray.length >> 1;
        BigInteger bigInteger = new BigInteger(1, P11Util.subarray(byArray, 0, n));
        BigInteger bigInteger2 = new BigInteger(1, P11Util.subarray(byArray, n, n));
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error", iOException);
        }
    }

    private static byte[] asn1ToDSA(byte[] byArray) throws SignatureException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
            BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
            byte[] byArray2 = P11Signature.toByteArray(bigInteger, 20);
            byte[] byArray3 = P11Signature.toByteArray(bigInteger2, 20);
            if (byArray2 == null || byArray3 == null) {
                throw new SignatureException("Out of range value for R or S");
            }
            return P11Util.concat(byArray2, byArray3);
        }
        catch (SignatureException signatureException) {
            throw signatureException;
        }
        catch (Exception exception) {
            throw new SignatureException("invalid encoding for signature", exception);
        }
    }

    private byte[] asn1ToECDSA(byte[] byArray) throws SignatureException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
            BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
            byte[] byArray2 = P11Util.trimZeroes(bigInteger.toByteArray());
            byte[] byArray3 = P11Util.trimZeroes(bigInteger2.toByteArray());
            int n = Math.max(byArray2.length, byArray3.length);
            byte[] byArray4 = new byte[n << 1];
            System.arraycopy(byArray2, 0, byArray4, n - byArray2.length, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new SignatureException("invalid encoding for signature", exception);
        }
    }

    private static byte[] toByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        int n2 = byArray.length;
        if (n2 == n) {
            return byArray;
        }
        if (n2 == n + 1 && byArray[0] == 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            return byArray2;
        }
        if (n2 > n) {
            return null;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, n - n2, n2);
        return byArray3;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.session != null && this.token.isValid()) {
                this.cancelOperation();
                this.session = this.token.releaseSession(this.session);
            }
        }
        finally {
            super.finalize();
        }
    }
}

