/*  Arduino based - Aquarium Auto Lighing System
 *  More info can be found at: http://www.ardumotive.com
 *  Dev:Michalis Vasilakis Date:21/2/2018 Var:1.0  
*/

//Libraries (many thanks to Developers)
#include <Adafruit_NeoPixel.h>
#include <RTClib.h>


//Constants
const int DIN = 2;    //Neopixel DIN pin to Arduino Pin 2
const int PIXELS = 29; //How many neopixel leds do you have?
RTC_DS1307 rtc;       //Create an object for DS1307 I2C library
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(PIXELS, DIN, NEO_GRB + NEO_KHZ800); //Create an object for NeoPixel library

//Variables;
int H,M; //H for hour and M for minutes
String Time; // Use readTime(); Serial.print(Time); for printing the time in serial monitor
//Variables For color setting
boolean newColor = false;
int r=0;
int g=0;
int b=0;
//Following variables are used for the time setting from serial monitor
boolean newMessage = false;
boolean messageCompleted = false;
char incomingByte; 
String command;
//Delay without delay() for fade
unsigned long previousMillis = 0;
const long interval = 250; //Change this value (ms) 


void setup() {
  pixels.begin(); //Initialize the NeoPixel library
  rtc.begin();    //Initialize the RTC DS1307 library
  Serial.begin(9600); 
  //This will run only if the rtc battery is low or rtc ic has wrong time set
  if (! rtc.isrunning()) {
    Serial.println("RTC is NOT running!");
    // This line sets the RTC with an explicit date & time, for example to set
    // January 1, 2018 at 00:00am you would call:
    rtc.adjust(DateTime(2018, 01, 01, 00, 00, 0)); 
  }
  Serial.println("Aquarium Auto Lighting System"); 
  Serial.println("Visit the www.Ardumotive.com for more info \n");
  readTime();
  Serial.println(Time);
  Serial.println("- To set the time send '<SHH:MM>' (example: <S14:05>)");
}

void loop() {
  setTime(); //Check for serial set command
  readTime();

  //Change time and color values bellow if you want
  //From 00:00 to 07:00
  if (H>=0 && H <7) {
    setColor(0,0,50);
  }
  //From 07:00 to 12:00
  else if (H>=7 && H<12){
    setColor(50,50,100);
  }
  else if( H>=12 && H<19){
    setColor(180,180,180);
  }
  else if (H>=19 && H<21){
    setColor(50,50,100);
  } 
}
//Send color to led strip
void setColor(int R,int G,int B){
  while ((r!=R) || (g!=G) || (b!=B)){
      setTime(); //Check for serial set command

    unsigned long currentMillis = millis();
    if (currentMillis - previousMillis >= interval) {
      previousMillis = currentMillis;
      for(int i=0;i<PIXELS;i++){
        // pixels.Color takes RGB values, from 0,0,0 up to 255,255,255
        pixels.setPixelColor(i, pixels.Color(r,g,b)); 
        pixels.show(); 
      } 
      if (r!=R && r<R){
        r++;
      }
      else if (r!=R && r>R){
        r--;
      }
      if (g!=G && g<G){
        g++;
      }
      else if (g!=G && g>G){
        g--;
      }
      if (b!=B && b<B){
        b++;
      }
      else if (b!=B && b>B){
        b--;
      }
    }
   }
}

//Read time from RTC
void readTime(){
  DateTime now = rtc.now();
  H = now.hour();
  M = now.minute();
  Time = "Current time in RTC: " + String(H) + ":" + String(M);
} 

//Set time, send <SHH:MM> (example <S05:00>)
void setTime(){
  if (Serial.available()){
    incomingByte = Serial.read();
    if(incomingByte=='>'){
       messageCompleted=true;
       newMessage=false;
    }
    else if (incomingByte=='<'){
       newMessage=true;
    }
    if (newMessage){
       command.concat(incomingByte);
    }
  }
  if(messageCompleted){
    //Set time
    if (command.charAt(1)=='S'){
      int h = (command.substring(2,4)).toInt();
      int m = (command.substring(5,7)).toInt();
      rtc.adjust(DateTime(2018,01,01,h,m,0));
      Serial.println("Done");
      readTime();
      Serial.println(Time);
    }
    command="";
    messageCompleted=false;
  }
}
