void wakeUpNow()        // Required for the interrupt for waking up
{
  // No code will be run here
}

void sleepNow()
{
  // Blinks indicator LED three times.
  digitalWrite(batteryStatusLEDPin, HIGH);
  delay(250);
  digitalWrite(batteryStatusLEDPin, LOW);
  delay(250);
  digitalWrite(batteryStatusLEDPin, HIGH);
  delay(250);
  digitalWrite(batteryStatusLEDPin, LOW);
  delay(250);
  digitalWrite(batteryStatusLEDPin, HIGH);
  delay(250);
  digitalWrite(batteryStatusLEDPin, LOW);

  pinMode(buckPwmPin, INPUT);

  // Go to sleep
  adc_disable(); // Disable ADC to save energy
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);   // Sleep mode with the most power saving
  sleep_enable();          // enables the sleep bit in the mcucr register
  attachInterrupt(0, wakeUpNow, LOW); // use interrupt 0 (pin 2) and run function
  sleep_mode();     // The chip is put to sleep here

  // Wake up
  sleep_disable(); // When button is pressed, wake up
  detachInterrupt(0); // disables interrupt 0 on pin 2 to prevent executing wakeUpNow while running
  adc_enable();

  delayCounts = 0;

  buttonReading = digitalRead(powerButtonPin);
  while (buttonReading == LOW) {
    delay(debounceDelay);
    delayCounts++;
    buttonReading = digitalRead(powerButtonPin);
  }

  if (delayCounts <= 2) {
    sleepNow();
  }

  pinMode(buckPwmPin, OUTPUT);
  lowBattery = false;


  delay(500);
}

