/*
 * Setup.c
 *
 * Created: 01/01/2018 11:55:40
 *  Author: Thomas
 */ 

#include <asf.h>
#include <Setup.h>

void setupPins(void){
	// DDR: Direction (input/output)
	// PORT: HIGH/LOW
	
	DDRB = (1<<DDB6)|(1<<DDB7);
	DDRC = (1<<DDC3);
	DDRD = (1<<DDD3);
	
	PORTB = (1<<PB6)|(1<<PB7);
	PORTC = (1<<PC3);
	PORTD = (1<<PD3);
	
	RED_OFF();
	GREEN_OFF();
	BLUE_OFF();
}

LEDS_DRIVER_TIMER_ISR
{
	// Increase counter
	ISRcounter+=2;
	// Reset the counter and turn on the LEDS
	if (ISRcounter==250){
		ISRcounter = 0;
		RED_ON();
		GREEN_ON();
		BLUE_ON();
	}
	// Turn leds of if necessary
	if(ISRcounter>=REDcounter>>2){
		RED_OFF();
	}
	if(ISRcounter>=GREENcounter>>1){
		GREEN_OFF();
	}
	if(ISRcounter>=BLUEcounter){
		BLUE_OFF();
	}
}