#include "WProgram.h"
void cls();
void clock();
void alarm();
void pong();
void labrynth();
void jump();
void getInput();
void display(int ms_delay);
void numSet(int num,int x);
void one(int x);
void two(int x);
void three(int x);
void four(int x);
void five(int x);
void six(int x);
void seven(int x);
void eight(int x);
void nine(int x);
void zero(int x);
void a(int x);
void b(int x);
void c(int x);
void d(int x);
void e(int x);
void f(int x);
void g(int x);
void h(int x);
void i(int x);
void j(int x);
void k(int x);
void l(int x);
void m(int x);
void n(int x);
void o(int x);
void p(int x);
void q(int x);
void r(int x);
void s(int x);
void t(int x);
void u(int x);
void v(int x);
void w(int x);
void x(int x);
void y(int x);
void z(int x);
/* Wooden Clock software V1.0
 * ---------------- 
 *
 *Description
 * 
 * Created November 8, 2007
 * copyleft 2007 Jonathan Hodgins
 */

const byte red=1;//define constants to make the code more readable
const byte green=2;
const byte yellow=3;
const byte redPin=0;
const byte greenPin=1;
const byte multiplexHelpPin=13;//Turns the multiplexer on and off
const byte numCathodes=17;//the number of LED common cathode columns
const byte numCathodePins=5;//the pins going to the multiplexer
const byte cathodePin[5]={
  2,3,4,5,6};//the pins related to the Cathode columns (multiplexed output)
const byte numAnodes=5;//The number of LED common anode rows
const byte anodePin[5]={
  7,8,10,11,12};//the pins related to the LED anode rows
byte ledState[5][17];

//it is very important to note that the joystick inputs use the analog inputs, even though they are digital
const byte upPin=0;
const byte downPin=1;
const byte leftPin=2;
const byte rightPin=3;
const byte buttonPin1=4;//button to confirm a choice
const byte buttonPin2=5;
const byte potPin1=5;//Pin the potentiometer connects to
const byte potPin2=4;//Pin the potentiometer connects to
bool up,down,left,right,button1,button2;//digital values for the analog input
bool lastButton1,lastButton2;//used to calculate how long the button is being held
bool button1Held=false;
const int holdTime=2000;//how long to hold the button to count as a hold
int pot1Value,pot2Value=1023;
const int pushedValue=512;//if the analog input drops below this, it is counted as a button push

const byte speakerPin=9;//the pin the radio is connected to, can also be used as PWM for a speaker
bool speakerOut=LOW;

byte mode=0;//the current mode(clock alarm etc)
const byte numModes=5;//the max number of modes

//clock variables
byte time[4]={
  1,2,0,0};//current time
byte alarmTime[5]={
  1,2,0,0,0};  //time the alarm goes off
const byte maxNum[4]={
  1,9,5,9};//the max number for each digit of the clock
bool xm=0;//as in 'am' or 'pm'
long lastTimeChanged = millis();//used to see when a minute is up
const byte clockColour=red;//the current colour of the clock
const int titleTime=2500;//how long to display the titles(for all modes)
long tempClock;//used to find how frequently to update the time
long holdClock;//used to see if button 1 is being held
long switchedMode = millis();//used to display the title
int temp1,temp2;//used for various purposes as a disposible variable
long currentTime=millis();//the current time, so the reading stays consistant through a whole update cycle
long lastMillis=millis();//used to prevent a breakdown when millis() goes back to 0
const long oneMin=60000;//the length of 1 minute in ms
bool alarmSounded=true;//used so the alarm won't re-sound once turned off and it is the same time

//pong variables
byte ballX=2;//the x position of the ball
int ballV=1;//ball velocity
byte numPlayers;
byte score1,score2;
const int paddleTime=250;//the length the paddle is up after a button push
bool leftPaddle=false;//used to turn the paddle on and off
bool rightPaddle=false;
long leftStart,rightStart;//used to store when the paddles were first shown, to calculate when to turn them off
byte moveDelay=200;//how long to wait before moving the ball(slowly gets less as time goes on)
const byte startMoveDelay=200;//the default value for the moveDelay

//labrynth variables
const byte maxMazeSize=11;//the max size of the maze(y x y in size)
byte maze[maxMazeSize][maxMazeSize];//to store the maze pattern(condensed version)
byte ledMaze[maxMazeSize*2+1][maxMazeSize*2+1];//the full maze
const byte startingMazeSize=3;//default maze size
byte currentMazeSize=startingMazeSize;
byte level;
bool generate;//used to signal the code to make the next maze
const byte mazeColour=red,playerColour1=green,endColour=green, bonusColour=yellow;//various constants for the colour of objects
byte bonus=0;//the number of bonus to unlock the exit(number have)
bool finished=false;
const byte maxLevel=(maxMazeSize-1)/2;//the maximum level(constrained by eeprom)

//super mario variables
int score=0;
byte pX;
int pY;
int pV;//player velocity(in y direction for jumping)
byte nextLength, gap, nextHeight, nextBad;//constants for creating the platforms
const byte platformColour=yellow,playerColour2=green,badColour=red;//constants for the colours

void setup()//in this section outputs and arrays are initilized
{
  pinMode(speakerPin,OUTPUT);
  digitalWrite(speakerPin,speakerOut);

  for(int i=0;i<numCathodePins;i++)//sets the display pins to outputs ans sets them so no light shows
  {
    pinMode(cathodePin[i],OUTPUT);
    digitalWrite(cathodePin[i],LOW);
  }

  for(int i=0;i<numAnodes;i++)//sets the display pins to outputs ans sets them so no light shows
  {
    pinMode(anodePin[i],OUTPUT);
    digitalWrite(anodePin[i],LOW);
  }
  for(int i=0;i<numAnodes;i++)
    for(int j=0;j<numCathodes;j++)
      ledState[i][j]=0;

  for(int i=0;i<maxMazeSize*2+1;i++)
    for(int j=0;j<maxMazeSize*2+1;j++)
      ledMaze[i][j]=0;
  for(int i=0;i<maxMazeSize;i++)
    for(int j=0;j<maxMazeSize;j++)
      maze[i][j]=0;

  pinMode(redPin,OUTPUT);
  pinMode(greenPin,OUTPUT);
  digitalWrite(redPin,LOW);
  digitalWrite(greenPin,LOW);
  pinMode(multiplexHelpPin,OUTPUT);
}

/*The main program loop*/
void loop()
{
  getInput();//gets the current state of the buttons

  //uncomment this section to display the pot2 value on the screen
  /*mode=-1;
   numSet(pot2Value/1000,1);
   numSet((pot2Value/100)%10,5);
   numSet((pot2Value/10)%10,9);
   numSet((pot2Value/1)%10,13);*/

  //uncomment this section to display pixels around the upper colon dot to test the buttons
  /*if(button1==HIGH)            
   ledState[0][7]=yellow;
   if(button2==HIGH)
   ledState[0][9]=yellow;
   if(up==HIGH)
   ledState[0][8]=yellow;
   if(down==HIGH)
   ledState[2][8]=yellow;
   if(left==HIGH)
   ledState[1][7]=yellow;
   if(right==HIGH)
   ledState[1][9]=yellow;*/

  button1Held=false;//reset the variable
  if(button1==HIGH)//start the clock if pushed
  {
    if(lastButton1==LOW && button1==HIGH)
      holdClock=millis();
    if(millis()-holdClock>=holdTime)//finds if button1 is being held
      button1Held=true;
  } 
  if(millis()-switchedMode<titleTime || mode==0)//calculate if the button is being held
    if(lastButton1==HIGH && button1==LOW)
      if(button1Held==false && speakerOut!=HIGH)
      {
        mode=(mode+1)%numModes;
        switchedMode = millis();
      }
  if(button1Held)
  {
    do//catch the button push and wait until it is released
    {
      getInput();
    }
    while(button1==HIGH);
    if(mode!=0)//reset to clock mode if not there and button1 is held
    {
      mode=0;
      button1Held=false;
    }
  }

  //to display the title and reset variables for each mode
  if(millis()-switchedMode<titleTime)
  {
    cls();
    if(mode==0)//clock
    {
      c(0);
      l(4);
      o(6);
      c(10);
      k(14);
      temp1=0;
      temp2=0;
    }
    else if(mode==1)//alarm
    {
      a(0);
      l(4);
      a(6);
      r(10);
      m(14);
      temp1=0;
      temp2=0;
    }
    else if(mode==2)//pong
    {
      p(0);
      o(4);
      n(8);
      g(12);
      ballX=8;
      temp1=0;
      score1=0;
      score2=0;
      numPlayers=0;//signals the program it just started
    }
    else if(mode==3)//labrynth, have a better name for it? please leave a comment
    {
      m(0);
      a(4);
      z(8);
      e(12);
      level=1;
      generate=true;
    }
    else if(mode==4)//jump, inspired by super mario bros.
    {
      j(0);
      u(4);
      m(8);
      p(12);
      score=-1;//a signal it just started
    }
    else//here to allow for if statement structuring, but also indicates a failure
    {
      f(0);
      a(4);
      i(8);
      l(12);
    }
  }
  else if(mode==0)//standard clock mode
  {
    cls();
    clock();
  }
  else if(mode==1)// alarm setting mode
  {
    cls();
    alarm();
  }
  else if(mode==2)//pong
  {
    cls();
    pong();
  }
  else if(mode==3)//the maze game
  {
    labrynth();
  }
  else if(mode==4)// a platformer game
  {
    jump();
  }
  else
  {
  }

  display(50);//display the generated output on the screen
}

//clear the output matrix(not to be confused with cls, an actual keyword in some languages)
void cls()
{
  for(int i=0;i<numAnodes;i++)
    for(int j=0;j<numCathodes;j++)
      ledState[i][j]=LOW;
}

//the code to keep time and generate the clock on the screen
void clock()
{
  lastMillis=currentTime;//for when millis resets, this method results in a loss of about 1/2 min over a year
  currentTime=millis();

  if(currentTime<lastTimeChanged)//reset lastTimeChanged when the timer resets
    lastTimeChanged-=lastMillis;

  if(currentTime-oneMin>=lastTimeChanged)//update the time
  {
    lastTimeChanged+=oneMin;//update the counter

    time[3]=(time[3]+1)%(maxNum[3]+1);//get the new time
    if (time[3]==0)
    {
      time[2]=(time[2]+1)%(maxNum[2]+1);
      if(time[2]==0)
      {
        time[1]=(time[1]+1)%(maxNum[1]+1);
        if(time[1]==0)
          time[0]=(time[0]+1)%(maxNum[0]+1);
        if(time[0]==1)
        {
          if(time[1]>2)
          {
            time[0]=0;
            time[1]=1;
          }
          if(time[1]==2)
            xm=(xm+1)%2;
        }

      }
    }
  }

  if(time[0]==0 && time[1]==0)//catch an exception in the time counting
    time[1]=1;

  //set the LEDs to the current time
  if(time[0]>0)//hours
    numSet(time[0],0);
  numSet(time[1],4);
  if(currentTime%1000>=500)//the blinking colon
  {
    ledState[1][8]=xm+1;
    ledState[3][8]=xm+1;
  }
  else
  {
    ledState[1][8]=LOW;
    ledState[3][8]=LOW;
  }
  numSet(time[2],10);//the minutes
  numSet(time[3],14);

  //see if the alarm should go off
  if(alarmTime[0]==time[0] && alarmTime[1]==time[1] && alarmTime[2]==time[2] && alarmTime[3]==time[3])
  {
    if(alarmTime[4]==xm && alarmSounded==false)
    {
      speakerOut=HIGH;
      digitalWrite(speakerPin,speakerOut);
      alarmSounded=true;
    }
  }
  else
    alarmSounded=false;//arm the alarm

  if(button2==HIGH)// used to toggle the radio to listen to
  {
    if(speakerOut==LOW)
      speakerOut=HIGH;
    else
      speakerOut=LOW;
    digitalWrite(speakerPin,speakerOut);
    do//wait until released
    {
      display(100);
      getInput();
    }
    while(button2==HIGH);
  }


  if(button1Held)//set the time(let me know if there are any difficulties)
  {
    temp1=0;
    temp2=0;
    cls();
    do
    {
      if(temp2==0)
        temp2=1;
      else
        temp2=0;

      getInput();

      if(button1==HIGH)
      {
        button1Held=false;
        do
        {
          display(100);
          getInput();
        }
        while(button1==HIGH);
      }
      else if(up==HIGH)
      {
        if(temp1<4)
        {
          time[temp1] = (time[temp1]+1)%(maxNum[temp1]+1);
          if(time[0]==1)
            time[1] = time[1]%3;
        }
        else
          xm=(xm+1)%2;
        do
        {
          display(100);
          getInput();
        }
        while(up==HIGH);//loop until the button is released, the screen is now black while holding the button
      }
      else if(down==HIGH)
      {          
        if(temp1<4)
        {
          if(time[temp1]>0)
          {
            time[temp1] = time[temp1]-1;
            if(time[0]==0 && time[1]==0)
              time[1]=maxNum[1];
          }
          else
          {
            time[temp1] = maxNum[temp1];
            if(time[0]==1 && time[1]>2)
              time[1]=2;
          }
        }
        else
          xm=(xm+1)%2;
        do
        {
          display(100);
          getInput();
        }
        while(down==HIGH);//loop until the button is released, the screen is now black while holding the button
      }
      else if(right==HIGH)
      {
        temp1 = (temp1+1)%5;
        do
        {
          display(100);
          getInput();
        }
        while(right==HIGH);//loop until the button is released, the screen is now black while holding the button
      }
      else if(left==HIGH)
      {
        temp1 = temp1-1;
        if(temp1<0)
          temp1=4;
        do
        {
          display(100);
          getInput();
        }
        while(left==HIGH);//loop until the button is released, the screen is now black while holding the button
      }

      if(time[0]==0 && time[1]==0)
        time[1]=1;

      cls();
      if(temp1!=0 || temp2==1)
        numSet(time[0],0);//set the LEDs to the current time
      if(temp1!=1 || temp2==1)
        numSet(time[1],4);
      if(temp1!=4 || temp2==1)
      {
        ledState[1][8]=xm+1;
        ledState[3][8]=xm+1;
      }
      if(temp1!=2 || temp2==1)
        numSet(time[2],10);
      if(temp1!=3 || temp2==1)
        numSet(time[3],14);

      display(100);
    }
    while(button1Held==true);
    lastTimeChanged=millis();
  }

  if(speakerOut)//turn off the radio when anything is pushed
    if(up==true || down==true || left==true || right==true || button1==true)
    {
      speakerOut=LOW;
      digitalWrite(speakerPin,speakerOut);
      while(button1)//catch button1, so it dosn't change modes
      {
        getInput();
        display(100);
      }
    }
}

//the alarm setting code, same as in time() procedure
void alarm()
{
  if(temp1!=0 || temp2==1)//Sets the display to the last alarm time to prevent blackouts during button pushes
    numSet(alarmTime[0],0);//set the LEDs to the current time
  if(temp1!=1 || temp2==1)
    numSet(alarmTime[1],4);
  if(temp1!=4 || temp2==1)
  {
    ledState[1][8]=alarmTime[4]+1;
    ledState[3][8]=alarmTime[4]+1;
  }
  if(temp1!=2 || temp2==1)
    numSet(alarmTime[2],10);
  if(temp1!=3 || temp2==1)
    numSet(alarmTime[3],14);

  if(temp2==0)
    temp2=1;
  else
    temp2=0;

  if(up==HIGH)
  {
    if(temp1<4)
    {
      alarmTime[temp1] = (alarmTime[temp1]+1)%(maxNum[temp1]+1);
      if(alarmTime[0]==1)
        alarmTime[1] = alarmTime[1]%3;
    }
    else
      alarmTime[4]=(alarmTime[4]+1)%2;
    do
    {
      display(100);
      getInput();
    }
    while(up==HIGH);//loop until the button is released, the screen is now black while holding the button
  }
  else if(down==HIGH)
  {          
    if(temp1<4)
    {
      if(alarmTime[temp1]>0)
      {
        alarmTime[temp1] = alarmTime[temp1]-1;
        if(alarmTime[0]==0 && alarmTime[1]==0)
          alarmTime[1]=maxNum[1];
      }
      else
      {
        alarmTime[temp1] = maxNum[temp1];
        if(alarmTime[0]==1 && alarmTime[1]>2)
          alarmTime[1]=2;
      }
    }
    else
      alarmTime[4]=(alarmTime[4]+1)%2;
    do
    {
      display(100);
      getInput();
    }
    while(down==HIGH);//loop until the button is released, the screen is now black while holding the button
  }
  else if(right==HIGH)
  {
    temp1 = (temp1+1)%5;
    do
    {
      display(100);
      getInput();
    }
    while(right==HIGH);//loop until the button is released, the screen is now black while holding the button
  }
  else if(left==HIGH)
  {
    temp1 = temp1-1;
    if(temp1<0)
      temp1=4;
    do
    {
      display(100);
      getInput();
    }
    while(left==HIGH);//loop until the button is released, the screen is now black while holding the button
  }
  if(button1 || button2)
  {
    mode=0;
    switchedMode=millis();
  }

  if(alarmTime[0]==0 && alarmTime[1]==0)
    alarmTime[1]=1;

  cls();//Sets the display to the alarm time
  if(temp1!=0 || temp2==1)
    numSet(alarmTime[0],0);//set the LEDs to the current time
  if(temp1!=1 || temp2==1)
    numSet(alarmTime[1],4);
  if(temp1!=4 || temp2==1)
  {
    ledState[1][8]=alarmTime[4]+1;
    ledState[3][8]=alarmTime[4]+1;
  }
  if(temp1!=2 || temp2==1)
    numSet(alarmTime[2],10);
  if(temp1!=3 || temp2==1)
    numSet(alarmTime[3],14);

  display(100-50);//slow down the flickering
}

//the code for pong
void pong()
{
  if(numPlayers==0)//signals it just started and to choose the number of players
  {
    if(up || down)//change the number of players
    {
      temp1=(temp1+1)%2;
    }
    if(button1)//select the current number of players
    {
      numPlayers=temp1+1;
    }
    if(temp1==0)
    {
      one(0);
      p(4);
    }
    if(temp1==1)
    {
      two(0);
      p(4);
    }
    while(up || down)//wait until released, so they dont rapidly cycle
    {
      display(50);
      getInput();
    }
    tempClock=millis();//initiate variable for the program
    randomSeed(millis());
    temp2=random(0,10);
  }
  else
  {

    if(button1 && !lastButton1 && !leftPaddle)//flash up the paddle
    {
      leftPaddle=true;
      leftStart=millis();
      temp2=random(0,10);
    }
    if(numPlayers==1 && rightPaddle==false)//controls the computer player
    {
      if(ballX==14 && ballV>0 && !rightPaddle && temp2!=0)
      {
        rightPaddle=true;
        rightStart=millis();
      }   
    }
    else if(button2 && !lastButton2 && !rightPaddle && numPlayers==2)//if button2 was pushed
    {
      rightPaddle=true;
      rightStart=millis();
    }


    cls();//generate the output over the next lines
    if(leftPaddle)
    {
      for(int nu=0;nu<5;nu++)
        ledState[nu][0]=red;
      if(millis()-leftStart>=paddleTime)
        leftPaddle=false;
    }
    if(rightPaddle)
    {
      for(int nu=0;nu<5;nu++)
        ledState[nu][16]=red;
      if(millis()-rightStart>=paddleTime)
        rightPaddle=false;
    }

    if(ballX==1 && leftPaddle)// bounce the ball
    {
      ballV=abs(ballV);
      if(moveDelay>5)
        moveDelay-=5;
    }
    if(ballX==15 && rightPaddle)//bounce it the other way
    {
      ballV=-abs(ballV);
      if(moveDelay>5)
        moveDelay-=5;
    }

    if(millis()-tempClock>=moveDelay)//move the ball
    {
      ballX+=ballV;
      tempClock=millis();
    }

    if(ballX<1 || ballX>15)//if someone scored
    {
      if(ballX>15)//if it was player 1
      {
        score1++;
        ballX=2;
        ballV=abs(ballV);
        temp2=random(0,10);
        moveDelay=startMoveDelay;
      }
      else if(ballX<1)//or player 2
      {
        score2++;
        ballX=14;
        ballV=-abs(ballV);
        moveDelay=startMoveDelay;
      }
      cls();//display the current score
      numSet(score1/10,0);
      numSet(score1%10,4);
      numSet(score2/10,10);
      numSet(score2%10,14);
      display(2000);
      if(score1>20 || score2>20)// if someone won
      {
        cls();
        p(0);
        if(score1>20)
          one(4-2);
        if(score2>20)
          two(4);
        w(8);
        i(12);
        n(14);
        display(3000);
        switchedMode = millis();
      }
    }
    else
      ledState[2][ballX]=yellow;//display the ball
  }
}

//the maze game
void labrynth()
{
  if(generate==true)//generate the next level
  {
    if(level==1)
    {
      currentMazeSize=startingMazeSize;
    }
    else
      currentMazeSize+=2;

    cls();
    l(0);//display the current level
    e(3);
    v(7);
    e(11);
    l(15);
    display(1200);
    cls();
    numSet(level,0);
    display(1500);

    for(byte i=0;i<maxMazeSize;i++)//reset the maze
      for(byte j=0;j<maxMazeSize;j++)
        maze[i][j]=0;

    maze[((currentMazeSize)/2)][((currentMazeSize)/2)]=5;//set the start to the middle
    maze[((currentMazeSize)/2)+1][((currentMazeSize)/2)]=3;//set the first space

    temp1=random(0,2);
    temp2=random(0,2);
    maze[(currentMazeSize-1)*temp2][(currentMazeSize-1)*temp1]=6+temp1;//set the end to a corner(opening up or down)

    finished=false;

    do//generate the maze
    {
      temp1=0;
      temp2=0;
      for(byte i=0;i<100;i++)
      {
        temp1=random(0,currentMazeSize);
        temp2=random(0,currentMazeSize);
        if(maze[temp1][temp2]!=0)
        {
        }
        else if(maze[temp1][temp2+1]>0 && maze[temp1][temp2+1]<5 && temp2+1<currentMazeSize)//up
          maze[temp1][temp2]=1;
        else if(maze[temp1-1][temp2]>0 && maze[temp1-1][temp2]<5 && temp1-1>=0)//left
          maze[temp1][temp2]=3;
        else if(maze[temp1+1][temp2]>0 && maze[temp1+1][temp2]<5 && temp1+1<currentMazeSize)//right
          maze[temp1][temp2]=4;
        else if(maze[temp1][temp2-1]>0 && maze[temp1][temp2-1]<5 && temp2-1>=0)//down
          maze[temp1][temp2]=2;
      }
      temp1=currentMazeSize*currentMazeSize;
      for(byte i=0;i<currentMazeSize;i++)
        for(byte j=0;j<currentMazeSize;j++)
          if(maze[i][j]>0)
            temp1--;
      if(temp1==0)
        finished=true;
    }
    while(finished==false);

    for(byte i=0;i<maxMazeSize*2+1;i++)//clear led maze
      for(byte j=0;j<maxMazeSize*2+1;j++)
        ledMaze[i][j]=0;

    for(byte i=0;i<currentMazeSize*2+1;i++)//reset led maze to a grid
      for(byte j=0;j<currentMazeSize*2+1;j++)
        if(i%2==0 || j%2==0)
          ledMaze[i][j]=mazeColour;
        else
          ledMaze[i][j]=0;

    for(byte i=0;i<maxMazeSize*2;i+=2)//clear led maze path based on the generated maze
      for(byte j=0;j<maxMazeSize*2;j+=2)
        if(maze[i/2][j/2]==1)//up
          ledMaze[i+1][j+1+1]=0;
        else if(maze[i/2][j/2]==2)//down
          ledMaze[i+1][j+1-1]=0;
        else if(maze[i/2][j/2]==3)//left
          ledMaze[i+1-1][j+1]=0;
        else if(maze[i/2][j/2]==4)//right
          ledMaze[i+1+1][j+1]=0;
        else if(maze[i/2][j/2]==6)//end, facing up
        {
          ledMaze[i+1][j+1+1]=4;
          ledMaze[i+1][j+1]=endColour;
        }
        else if(maze[i/2][j/2]==7)//end, facing down
        {
          ledMaze[i+1][j+1-1]=5;
          ledMaze[i+1][j+1]=endColour;
        }

    bonus=0;
    for(int i=0;i<level;i++)//set the keys in the maze to the end (bonuses) must be in a corner(only one side open)
    {
      finished=false;
      do
      {
        temp1=random(1,currentMazeSize*2);
        temp2=random(0,currentMazeSize*2);
        if(ledMaze[temp1][temp2]==0)//set the current random space to a bonus if it is in a corner(3 walls around)
        {
          if(ledMaze[temp1-1][temp2]==mazeColour && ledMaze[temp1+1][temp2]==mazeColour && ledMaze[temp1][temp2-1]==mazeColour)
          {
            ledMaze[temp1][temp2]=bonusColour;
            finished=true;
          }
          else if(ledMaze[temp1-1][temp2]==mazeColour && ledMaze[temp1+1][temp2]==mazeColour && ledMaze[temp1][temp2+1]==mazeColour)
          {
            ledMaze[temp1][temp2]=bonusColour;
            finished=true;
          }
          else if(ledMaze[temp1+1][temp2]==mazeColour && ledMaze[temp1][temp2-1]==mazeColour && ledMaze[temp1][temp2+1]==mazeColour)
          {
            ledMaze[temp1][temp2]=bonusColour;
            finished=true;
          }
          else if(ledMaze[temp1-1][temp2]==mazeColour && ledMaze[temp1][temp2-1]==mazeColour && ledMaze[temp1][temp2+1]==mazeColour)
          {
            ledMaze[temp1][temp2]=bonusColour;
            finished=true;
          }
        }
      }
      while(finished==false);
    }

    //reset the variable for the program
    pX=currentMazeSize;//relative to ledMaze size, not maze
    pY=currentMazeSize;
    finished=false;
    generate=false;
  }
  else//the main maze code
  {
    if(millis()-tempClock>=moveDelay)//if it is time to check, update the screen and move
    {
      cls();
      tempClock=millis();

      //move the maze
      if(left && ledMaze[pX-1][pY]!=mazeColour)
        pX--;
      else if(right && ledMaze[pX+1][pY]!=mazeColour)
        pX++;
      else if(up && ledMaze[pX][pY-1]!=mazeColour)
        pY--;
      else if(down && ledMaze[pX][pY+1]!=mazeColour)
        pY++;

      for(int i=0;i<numCathodes;i++)//generate the output
        for(int j=0;j<numAnodes;j++)
          if(pX+(i-numCathodes/2)>=0 && pY+(j-numAnodes/2)>=0 && pX+(i-numCathodes/2)<currentMazeSize*2+1 && pY+(j-numAnodes/2)<currentMazeSize*2+1)
            if(ledMaze[pX+(i-numCathodes/2)][pY+(j-numAnodes/2)]==4)
            {
              if(bonus==level)
                ledMaze[pX+(i-numCathodes/2)][pY+(j-numAnodes/2)]=0;
              ledState[j][i]=mazeColour;
            }
            else if(ledMaze[pX+(i-numCathodes/2)][pY+(j-numAnodes/2)]==5)
            {
              if(bonus==level)
                ledMaze[pX+(i-numCathodes/2)][pY+(j-numAnodes/2)]=0;
              ledState[j][i]=mazeColour;
            }
            else if(ledMaze[pX+(i-numCathodes/2)][pY+(j-numAnodes/2)]<=yellow)
              ledState[j][i]=ledMaze[pX+(i-numCathodes/2)][pY+(j-numAnodes/2)];


      if(ledState[2][8]==endColour)//check if finished the level
        finished=true;
      if(ledState[2][8]==bonusColour)//check if got a bonus(key)
      {
        ledMaze[pX][pY]=0;
        bonus++;
      }

      ledState[2][8]=playerColour1;//display the player


      if(finished)
      {
        level++;
        generate=true;
        cls();
        if(level>maxLevel)
        {
          y(0);
          o(4);
          u(8);
          display(1200);
          cls();
          w(0);
          i(4);
          n(6);
          for(int i=0;i<numAnodes;i++)//!
            if(i!=3)
              ledState[i][10]=clockColour;
          display(3000);
          switchedMode = millis();
        }
      }
    }
  }
}

//the code for the platformer game(my favorite!)
void jump()
{
  if(score<0)//if just started
  {
    cls();//reset variables
    randomSeed(millis());
    pX=1;
    pY=1;
    pV=100;
    gap=0;
    nextLength=random(4,7);
    nextHeight=random(2,5);
    for(int i=0;i<numCathodes;i++)//set the inital platforms
    {
      if(nextLength==0)
      {
        nextLength=random(4,7);
        nextHeight=random(2,5);
      }
      ledState[nextHeight][i]=platformColour;
      nextLength--;

      nextBad=random(10,21);
      tempClock=millis();
      score=1;
    }
  }
  else//the main jump code
  {
    if(millis()-tempClock>=moveDelay)// if it is time to update the screen and move
    {
      tempClock=millis();
      if(pY>=0)
        ledState[pY][pX]=0;//remove the player from the screen
      if(left && ledState[pY][pX-1]!=platformColour)//move the player
      {
        pX--;
        score--;
      }
      if(right && ledState[pY][pX+1]!=platformColour)
      {
        pX++;
        score++;
      }

      if(pX<1)//prevent the player from running out of the matrix
      {
        pX=1;
        score++;
      }
      else if(pX>9)//keep the player in the middle of the screen
      {
        pX--;
        for(int i=0;i<numCathodes-1;i++)
        {
          for(int j=0;j<5;j++)
            ledState[j][i]=ledState[j][i+1];//update the screen
        }
        if(nextLength==0)//get the next plaform(if needed)
        {
          if(score>399 && score<900)
            gap=random(0,2);
          else if(score>999)
            gap=random(0,3);

          if(score<100)//various frequencies for different distances
            nextLength=random(4,10);
          else if(score<200)
            nextLength=random(3,10);
          else if(score<400)
            nextLength=random(1,9);
          else if(score<600)
            nextLength=random(1,7);
          else if(score<800)
            nextLength=random(1,5);
          else if(score<1000)
            nextLength=random(1,2);
          nextHeight=random(2,5);
        }

        for(int k=0;k<5;k++)//erase the last row(from the old data)
          ledState[k][16]=0;

        if(gap==0)//put the new data in the last row
        {
          ledState[nextHeight][16]=platformColour;
          nextLength--;
        }
        else
          gap--;
      }

      if(pV==100)//if not jumping
        if(up || button1 || button2)//and need to jump
        {
          pV=-2;//jump
        }
      if(pV<100)//if jumping
      {
        if(pV<0)//fall
          pY--;
        else if(pV>0)
          pY++;
        pV++;
        if(ledState[pY+1][pX]==platformColour)//stop if hit a platform
        {
          pV=100;
        }
      }

      if(nextBad<=0)//if need to draw the next bad spot(could be an enemy or spikes)
      {
        for(int i=0;i<numAnodes;i++)
        {
          if(ledState[i][16]==platformColour)
            if(i<=2)
            {
              if(ledState[i][15]==platformColour || ledState[i+1][15]==platformColour || ledState[i][14]==platformColour || ledState[i+1][14]==platformColour)
                ledState[i-1][16]=badColour;
            }
            else
              ledState[i-1][16]=badColour;
        }
        if(score>99 && score<200)//various frequencies for different distances
          nextBad=random(10,31);
        else if(score<400)
          nextBad=random(8,31);
        else if(score<800)
          nextBad=random(2,16);
        else if(score<1000)
          nextBad=random(2,13);
        else if(score<1400)
          nextBad=random(2,5);

      }
      else if(left)//more the next bad with the player
        nextBad++;
      else if(right)
        nextBad--;

      if(ledState[pY+1][pX]==0 && pY<4 && pV==100)// if the player needs to fall
        pY++;//fall

      if(pY==4 || (pY>=0 && ledState[pY][pX]==badColour))//if dead
      {
        cls();
        numSet((score/1000),0);
        numSet((score/100)%10,4);
        numSet((score/10)%10,8);
        numSet((score)%10,12);
        display(3000);
        switchedMode = millis();
      }
      if(pY>=0)
        ledState[pY][pX]=playerColour2;//draw the player
    }
  }
}

// get the button input
void getInput()
{

  if (analogRead(upPin)<pushedValue)
    up=HIGH;
  else
    up=LOW;
  if (analogRead(downPin)<pushedValue)
    down=HIGH;
  else
    down=LOW;

  if (analogRead(leftPin)<pushedValue)
    left=HIGH;
  else
    left=LOW;
  if (analogRead(rightPin)<pushedValue)
    right=HIGH;
  else
    right=LOW;

  lastButton1=button1;
  if (analogRead(buttonPin1)<pushedValue)
    button1=HIGH;
  else
    button1=LOW;

  lastButton2=button2;
  if (analogRead(buttonPin2)<pushedValue)
    button2=HIGH;
  else
    button2=LOW;

  pot1Value=analogRead(potPin1);
  pot2Value=analogRead(potPin2);
}

//displays the output
//@ms_delay the time to display the output
void display(int ms_delay)
{
  int cathodeValue=0;
  int numOn=0;
  long clock = millis();//gets the milliseconds since the program started
  int temp=0;

  while (millis()-clock < ms_delay)//loop while the current time looping is less then the delay time
  {
    for(int c=0;c<3;c++)
    {

      for(int j=0;j<numCathodes;j++)
      {

        cathodeValue=j;
        numOn=0;//reset for the next line
        digitalWrite(anodePin[0],LOW);
        digitalWrite(anodePin[1],LOW);
        digitalWrite(anodePin[2],LOW);
        digitalWrite(anodePin[3],LOW);
        digitalWrite(anodePin[4],LOW);
        digitalWrite(cathodePin[0],LOW);           
        digitalWrite(cathodePin[1],LOW);           
        digitalWrite(cathodePin[2],LOW);           
        digitalWrite(cathodePin[3],LOW);           
        digitalWrite(cathodePin[4],HIGH);
        digitalWrite(multiplexHelpPin,LOW);     
        digitalWrite(redPin,LOW);
        digitalWrite(greenPin,LOW);

        if(cathodeValue>=16)
        {
          cathodeValue-=16;
          digitalWrite(cathodePin[4],LOW);           
          digitalWrite(multiplexHelpPin,HIGH);            
        }
        if(cathodeValue>=8)
        {
          cathodeValue-=8;
          digitalWrite(cathodePin[3],HIGH);           
        }
        if(cathodeValue>=4)
        {
          cathodeValue-=4;
          digitalWrite(cathodePin[2],HIGH);           
        }
        if(cathodeValue>=2)
        {
          cathodeValue-=2;
          digitalWrite(cathodePin[1],HIGH);           
        }
        if(cathodeValue>=1)
        {
          digitalWrite(cathodePin[0],HIGH);           
        }

        for(int i=0;i<numAnodes;i++)
        {
          if(c>=1)
          {
            if(ledState[i][j]==green || ledState[i][j]==yellow)
            {
              digitalWrite(anodePin[i],HIGH);
              digitalWrite(greenPin,HIGH);
              numOn++;
            }
          }
          else if(c==0)
          {
            if(ledState[i][j]==red || ledState[i][j]==yellow)
            {
              digitalWrite(anodePin[i],HIGH);
              digitalWrite(redPin,HIGH);
              numOn=1;
            }
          }
        }
        if(j!=15)//delay the program to let the lights turn on
          for(long m=0;m<6000*numOn*(c+c*10);m++)//delay
          {
          }
      }
    }
  }
  digitalWrite(anodePin[0],LOW);//reset the output to prevent ghosting
  digitalWrite(anodePin[1],LOW);
  digitalWrite(anodePin[2],LOW);
  digitalWrite(anodePin[3],LOW);
  digitalWrite(anodePin[4],LOW);       
  digitalWrite(cathodePin[4],HIGH);
  digitalWrite(multiplexHelpPin,LOW);     
  digitalWrite(redPin,LOW);
  digitalWrite(greenPin,LOW);
}

// an easier way to set the numbers on the clock
//@num the number to display
//@ x the location to display num
void numSet(int num,int x)
{
  if(num==0)
    zero(x);
  else if(num==1)
    one(x);
  else if(num==2)
    two(x);
  else if(num==3)
    three(x);
  else if(num==4)
    four(x);
  else if(num==5)
    five(x);
  else if(num==6)
    six(x);
  else if(num==7)
    seven(x);
  else if(num==8)
    eight(x);
  else if(num==9)
    nine(x);
  else
    ledState[2][x+1]=clockColour;
}

//from here on it is just cose to draw numbers and letters at any given x location
void one(int x)
{
  ledState[0][x+2]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+2]=clockColour;
}
void two(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void three(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void four(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+2]=clockColour;
}
void five(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void six(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void seven(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+2]=clockColour;
}
void eight(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void nine(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+2]=clockColour;
}
void zero(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void a(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void b(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void c(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void d(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
}
void e(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void f(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
}
void g(int x)
{
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void h(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void i(int x)
{
  ledState[0][x]=clockColour;
  ;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
}
void j(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x+1]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x+1]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
}
void k(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void l(int x)
{
  ledState[0][x]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
}
void m(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+1]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void n(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+1]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void o(int x)
{
  ledState[0][x+1]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+1]=clockColour;
}
void p(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
}
void q(int x)
{
  ledState[0][x+1]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}
void r(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void s(int x)
{
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
}
void t(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x+1]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x+1]=clockColour;
  ledState[4][x+1]=clockColour;
}
void u(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+1]=clockColour;
}
void v(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x+1]=clockColour;
  ledState[4][x+1]=clockColour;
}
void w(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[2][x+2]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+1]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x+1]=clockColour;
}
void x(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[3][x+2]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+2]=clockColour;
}
void y(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x+1]=clockColour;
  ledState[4][x+1]=clockColour;
}
void z(int x)
{
  ledState[0][x]=clockColour;
  ledState[0][x+1]=clockColour;
  ledState[0][x+2]=clockColour;
  ledState[1][x+2]=clockColour;
  ledState[2][x+1]=clockColour;
  ledState[3][x]=clockColour;
  ledState[4][x]=clockColour;
  ledState[4][x+1]=clockColour;
  ledState[4][x+2]=clockColour;
}

int main(void)
{
	init();

	setup();
    
	for (;;)
		loop();
        
	return 0;
}

