/* 
attiny IR "Wobblebot"
Masynmachien May 12th 2013
 */
#define IRpin_PIN      PINB
#define IRpin          4
// for ATTiny needs to be pinB type, here PB4,
// wich is on the analogue-digital convertor on analogue input 2,
// on physical IC pin number 3

//variable timing references, expressed in microseconds as preparation for decoding
unsigned long IRtimer = 0;
unsigned long movementtimer = 0;
unsigned long currentmicros = 0;
unsigned long ongoingmovement = 0;

unsigned long IRinterval = 90000;
//maximum repeat interval for IR signals on common remotes
unsigned long movementinterval = 200000; // half a movement cycle
// time given for a servo movement


int servoset = 0;

#include <Servo8Bit.h> 
Servo8Bit myservo;

//for alternative to delay function:
unsigned long currentMillis = 0;
unsigned long previousMillis = 0;
unsigned long interval = 150;
int led = 0;

void setup(void) {
   
  //Attaching the Servo(s)
  myservo.attach(1,950,2050); //limits set for Hobbyking sub 2g servos
  pinMode(led, OUTPUT);
  
  digitalWrite(led, HIGH);
  myservo.write(180); 
  // because delay function doesn't work well with servo8bit library
  while(currentMillis - previousMillis < interval)
  {currentMillis = millis();}
  previousMillis = currentMillis;
  myservo.write(90); 
  while(currentMillis - previousMillis < interval)
  {currentMillis = millis();}
  previousMillis = currentMillis;
  myservo.write(0);  
  while(currentMillis - previousMillis < interval)
  {currentMillis = millis();}
  previousMillis = currentMillis;
  digitalWrite(led, LOW);
}

void loop(void) {

    currentmicros = micros();

 // while ((IRpin_PIN & _BV(IRpin)) & (currentmicros - IRtimer > IRinterval))  // waiting for pin is to become high after interval. note digitalRead(IRpin)is documented to be too slow!
 // movementtimer = currentmicros - ongoingmovement; //continue from where left
    if (! (IRpin_PIN & _BV(IRpin))) { // pin is HIGH. note digitalRead(IRpin)is documented to be too slow!
      IRtimer = currentmicros;
    }
    if (currentmicros - IRtimer < IRinterval) { // it is not longer than "interval" ago that an IR signal was detected
      digitalWrite(led, HIGH);
      if (ongoingmovement > movementinterval*2) { // servo movement has gone through it's cycle
        movementtimer = currentmicros;
      }
      ongoingmovement = currentmicros - movementtimer; // servo movement "counter"
      if (ongoingmovement < movementinterval/2) { // servomovement movement starts in it's first quarter 90 to 180
        myservo.write(90 + int(180 * ongoingmovement / movementinterval));
      }
      else {
        if (ongoingmovement < (movementinterval*1.5)) { // servo movement is in it's second or third quareter, from 180 to 90:
          myservo.write(180-int(180 * (ongoingmovement-(movementinterval/2)) / movementinterval));
        }
        else { // servo movement is in it's last quareter, from 0 to 90:
          myservo.write(0 + int(180 * ((ongoingmovement-(movementinterval*1.5)) / movementinterval)));
        }
      }
    }
    else { 
      digitalWrite(led, LOW);
      myservo.write(90);
    }  
}






