void handleClient(){
  EthernetClient webClient = ethServer.available();
  if (webClient) {
    //Serial.println("new client");
    iUserCount++;
    DateTime now = rtc.now();
    // an http request ends with a blank line
    boolean currentLineIsBlank = true;
    while (webClient.connected()) {
      if (webClient.available()) {
        char c = webClient.read();
        //Serial.write(c);
        // if you've gotten to the end of the line (received a newline
        // character) and the line is blank, the http request has ended,
        // so you can send a reply
        if (c == '\n' && currentLineIsBlank) {
          // send a standard http response header
          webClient.println(F("HTTP/1.1 200 OK"));
          webClient.println(F("Content-Type: text/html"));
          webClient.println(F("Connection: close"));  // the connection will be closed after completion of the response
          //webClient.println("Refresh: 5");  // refresh the page automatically every 5 sec
          webClient.println();
          webClient.println(F("<!DOCTYPE html>"));
          webClient.println(F("<html lang='en' class=''>"));
          webClient.println(F("<head><meta charset='utf-8'><meta name=\"viewport\" content=\"width=device-width,initial-scale=1,user-scalable=no\"/><title>HA Weather Station</title>"));
          webClient.println(F("<style>table.stats {border: 1px solid #1C6EA4;  background-color: #FAFAFA;  text-align: left;  border-collapse: collapse;}\n table.stats td, table.stats th {border: 1px solid #AAAAAA;  padding: 3px 2px;}\n table.stats tr:nth-child(even) {background: #E8F6FF;}\n table.stats tfoot td {font-size: 12px;}\n"));
          webClient.println(F("table.stats tfoot .links {text-align: right;}\n table.stats tfoot .links a{display: inline-block;  background: #1C6EA4;  color: #FFFFFF;  padding: 2px 8px;  border-radius: 5px;}\n .tab {overflow: hidden; border: 1px solid #ccc; background-color: #f1f1f1;}\n .tab button {background-color: inherit; border: none; outline: none; cursor: pointer; padding: 14px 16px; transition: 0.3s;}\n"));
          webClient.println(F(".tab button:hover {background-color: #ddd;}\n .tab button.active {background-color: #ccc;}\n .tabcontent {animation: fadeEffect 1s; display: none; padding: 6px 12px; border: 1px solid #ccc; border-top: none;}\n @keyframes fadeEffect {from {opacity: 0;} to {opacity: 1;}}</style>\n <script>function openTab(evt, tabName) {\n var i, tabcontent, tablinks;\n tabcontent = document.getElementsByClassName(\"tabcontent\");\n"));
          webClient.println("for (i = 0; i < tabcontent.length; i++) {\n tabcontent[i].style.display = \"none\";\n }\n tablinks = document.getElementsByClassName(\"tablinks\");\n for (i = 0; i < tablinks.length; i++) {\n tablinks[i].className = tablinks[i].className.replace(\" active\", \"\");\n }\n document.getElementById(tabName).style.display = \"block\";\n evt.currentTarget.className += \" active\";\n }</script>");
          //webClient.println(pageStyle);
          /*webClient.println(F("<style>table.stats {border: 1px solid #1C6EA4;  background-color: #FAFAFA;  text-align: left;  border-collapse: collapse;}"));
          webClient.println(F("table.stats td, table.stats th {border: 1px solid #AAAAAA;  padding: 3px 2px;}"));
          webClient.println(F("table.stats tr:nth-child(even) {background: #E8F6FF;}"));
          webClient.println(F("table.stats tfoot td {font-size: 12px;}"));
          webClient.println(F("table.stats tfoot .links {text-align: right;}"));
          webClient.println(F("table.stats tfoot .links a{display: inline-block;  background: #1C6EA4;  color: #FFFFFF;  padding: 2px 8px;  border-radius: 5px;}</style>"));*/
          webClient.println(F("</head><body><h2 align='center'>Home Automation<br />Weather Station</h2><div class=\"tab\" align=\"center\"><button class=\"tablinks\" onclick=\"openTab(event, 'status')\" id=\"defaultOpen\">System Status</button><button class=\"tablinks\" onclick=\"openTab(event, 'readings')\">Last Readings</button></div><div id=\"status\" class=\"tabcontent\">"));
          webClient.println(F("<table class='stats' align='center'><tbody><tr><td colspan='2' align='center'><strong><span style='font-size: 14px;'>Device Health: </span>"));
          long curTime = millis() - lastDataRecorded;
          if ((curTime > dataOverduePeriod) || (bUsingFallbackAddress == true) || (bDHTSensorError == true) || (bTHPSensorError == true) || (bLightingSensorError == true) || (bLUXSensorError == true)){
            webClient.println(F("<span style='color: #ff0000; font-size: 14px;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<span style='color: #00aa00; font-size: 14px;'>Online</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>Online Since</td><td>"));
          webClient.print(startupdtstamp);
          webClient.println(F("</td></tr><tr><td>Last Update (sec)</td><td><strong>"));
          if ((curTime < dataOverduePeriod)){
            webClient.print(F("<span style='color: #00aa00;'>"));
          } else{
            webClient.print(F("<span style='color: #ff0000;'>"));
          }
          webClient.print(curTime/1000);
          webClient.println(F("</span></strong></td></tr><tr><td>MQTT Errors</td><td>"));
          webClient.print(iMQTTErrorCount);
          webClient.println(F("</td></tr><tr><td>DB Retries</td><td>"));
          webClient.print(iDBConnectionFailures);
          webClient.println(F("</td></tr><tr><td>DB Errors <br />Since Startup</td><td>"));
          webClient.print(iDBConnectionFailuresSinceBoot);
          webClient.println(F("</td></tr><tr><td>IP Assigned</td><td>"));
          if(bUsingFallbackAddress){
            webClient.println(F("<strong><span style='color: #ff0000;'>Static</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>DHCP</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>DHT Sensor</td><td>"));
          if(bDHTSensorError){
            webClient.println(F("<strong><span style='color: #ff0000;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>OK</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>Temp/Humidity/<br />Pressure Sensor</td><td>"));
          if(bTHPSensorError){
            webClient.println(F("<strong><span style='color: #ff0000;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>OK</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>Lightning Sensor</td><td>"));
          if(bLightingSensorError){
            webClient.println(F("<strong><span style='color: #ff0000;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>OK</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>LUX Sensor</td><td>"));
          if(bLUXSensorError){
            webClient.println(F("<strong><span style='color: #ff0000;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>OK</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>UV Sensor</td><td>"));
          if(bUVSensorError){
            webClient.println(F("<strong><span style='color: #ff0000;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>OK</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>Realtime Clock</td><td>"));
          if(bRTCError){
            webClient.println(F("<strong><span style='color: #ff0000;'>ERROR</span></strong></td></tr>"));
          } else{
            webClient.println(F("<strong><span style='color: #00aa00;'>OK</span></strong></td></tr>"));
          }
          webClient.print(F("<tr><td>Internal Temp</td><td>"));
          webClient.print(sLastInternalTemperature);
          webClient.println(F("&deg;F</td></tr><tr><td>Internal Humidity</td><td>"));
          webClient.print(sLastInternalHumidity);
          webClient.println(F("%</td></tr><tr><td>Internal Dew Point</td><td>"));
          webClient.print(sLastInternalDewPoint);
          webClient.println(F("&deg;F</td></tr><tr><td>Free RAM</td><td>"));
          getMemory();
          webClient.print(freeMemory());
          webClient.println(F("</td></tr><tr><td>Min Free RAM</td><td>"));
          webClient.print(iMinMem);
          webClient.println(F("</td></tr><tr><td>Avg Free RAM</td><td>"));
          webClient.print((iAvgMem / iMemCount));
          webClient.println(F("</td></tr></tbody></table>&nbsp;</div><div id=\"readings\" class=\"tabcontent\"><table class='stats' align='center'><tbody><tr><td colspan='2' align='center'><strong><span style='font-size: 14px;'>Last Readings</span></strong></td></tr><tr><td>Temperature</td><td>"));
          webClient.print(sLastTemperature);
          webClient.println(F("&deg;F</td></tr><tr><td>Humidity</td><td>"));
          webClient.print(sLastHumidity);
          webClient.println(F("%</td></tr><tr><td>Dew Point</td><td>"));
          webClient.print(sLastDewPoint);
          webClient.println(F("&deg;F</td></tr><tr><td>Feels Like</td><td>"));
          webClient.print(sLastFeelsLike);
          webClient.println(F("&deg;F</td></tr><tr><td>Barometric Pressure</td><td>"));
          webClient.print(sLastBarometricPressure);
          webClient.println(F("</td></tr><tr><td>Wind Speed</td><td>"));
          webClient.print(sLastWindSpeed);
          webClient.println(F("mph</td></tr><tr><td>Gusts</td><td>"));
          webClient.print(sLastGusts);
          webClient.println(F("mph</td></tr><tr><td>Wind Direction</td><td>"));
          webClient.print(sLastWindDirection);
          webClient.println(F("&deg;</td></tr><tr><td>Wind Ordinal</td><td>"));
          webClient.print(sLastWindOrdinalDirection);
          webClient.println(F("</td></tr><tr><td>Is it Raining</td><td>"));
          if(sLastRaining=="1"){
            webClient.println(F("Yes</td></tr>"));
          } else{
            webClient.println(F("No</td></tr>"));
          }
          webClient.print(F("<tr><td>Rainfall</td><td>"));
          webClient.print(sLastRainfall);
          webClient.println(F("&#34;</td></tr><tr><td>Lightning Count</td><td>"));
          webClient.print(sLastLightning);
          webClient.println(F("</td></tr><tr><td>Disturber Count</td><td>"));
          webClient.print(sLastLightningDisturber);
          webClient.println(F("</td></tr><tr><td>LUX</td><td>"));
          webClient.print(sLastLux);
          webClient.println(F("</td></tr><tr><td>UVA</td><td>"));
          webClient.print(sUVA);
          webClient.println(F("</td></tr><tr><td>UVB</td><td>"));
          webClient.print(sUVB);
          webClient.print(F("<tr><td>UV Index</td><td>"));
          webClient.print(sUVIndex);
          webClient.println(F("</td></tr></tbody></table></div><script>document.getElementById(\"defaultOpen\").click();</script></body></html>"));
          getMemory();
          break;
        }
        if (c == '\n') {
          // you're starting a new line
          currentLineIsBlank = true;
        } else if (c != '\r') {
          // you've gotten a character on the current line
          currentLineIsBlank = false;
        }
      }
    }
    // give the web browser time to receive the data
    delay(1);
    // close the connection:
    webClient.stop();
    //Serial.println("client disconnected");

  }
}
