// Initialization routines (these are called during startup to test the hardware.)
// __________________________________________________________________________________________________
bool initDHT(){

  sensorDHT.begin();
  
  float h = sensorDHT.readHumidity();
  float t = sensorDHT.readTemperature();

  // check if returns are valid, if they are NaN (not a number) then something went wrong!
  if (isnan(t) || isnan(h)) {
    //Serial.println("Failed to read from DHT");
    return true;
  } else {
    //Serial.print("Humidity: "); 
    //Serial.print(h);
    //Serial.print(" %\t");
    //Serial.print("Temperature: "); 
    //Serial.print(t);
    //Serial.println(" *C");
    return false;
  }
}

//bool initBP(){
  /* Initialise the sensor */
//  if (! sensorBP.begin()) {
//    Serial.println("Couldnt find BP sensor");
//    return true;
//  }
//  Serial.print("pressure: ");
//  Serial.println(sensorBP.getPressure());
//  return false;
//}

int initEthernet(){
  /* Initialize Ethernet and test database connection */

  if (Ethernet.begin(baEthMACAddress) == 0) {
   // Serial.println("Failed to configure Ethernet using DHCP - using fallback IP address");
    bUsingFallbackAddress = true;
    Ethernet.begin(baEthMACAddress, oFallbackIP);
  }
  //Serial.print("The weather station IP is: ");
  //Serial.println(Ethernet.localIP());

  dnsClient.begin(Ethernet.dnsServerIP());
  dnsClient.getHostByName(mySQL_server, oMySQLServerAddress);
  //Serial.print("MySQL Server IP: ");
  //Serial.println(oMySQLServerAddress);

  dnsClient.getHostByName(mqtt_server, oMQTTServerAddress);
  //Serial.print("MQTT Broker IP: ");
  //Serial.println(oMQTTServerAddress);
  
  //Ethernet.begin(baEthMACAddress, oFallbackIP);
  delay(1000);
  ethServer.begin();
  
  //Serial.println("Connecting to MySQL Server...");
  if (mysqlClient.connect(oMySQLServerAddress, 3306, user, password)) {
    delay(500);
    //Serial.println("Success!  ");
    mysqlClient.close();
    return 1;
  } else {
    //Serial.println("Connection failed.");
    return 3;
  }

}

bool initTSL2561(){
  
  /* Initialise the sensor */
  if(!sensorTSL.begin())
  {
    /* There was a problem detecting the TSL2561 ... check your connections */
    Serial.print("Ooops, no TSL2561 detected ... Check your wiring or I2C ADDR!");
    return true;
  }
  sensor_t sensor;
  sensorTSL.getSensor(&sensor);
  //Serial.println("------------------------------------");
  //Serial.print  ("Sensor:       "); Serial.println(sensor.name);
  //Serial.print  ("Driver Ver:   "); Serial.println(sensor.version);
  //Serial.print  ("Unique ID:    "); Serial.println(sensor.sensor_id);
  //Serial.print  ("Max Value:    "); Serial.print(sensor.max_value); Serial.println(" lux");
  //Serial.print  ("Min Value:    "); Serial.print(sensor.min_value); Serial.println(" lux");
  //Serial.print  ("Resolution:   "); Serial.print(sensor.resolution); Serial.println(" lux");  
  //Serial.println("------------------------------------");
  //Serial.println("");
  delay(500);
  /* You can also manually set the gain or enable auto-gain support */
  // sensorTSL.setGain(TSL2561_GAIN_1X);      /* No gain ... use in bright light to avoid sensor saturation */
  // sensorTSL.setGain(TSL2561_GAIN_16X);     /* 16x gain ... use in low light to boost sensitivity */
  sensorTSL.enableAutoRange(true);            /* Auto-gain ... switches automatically between 1x and 16x */
  
  /* Changing the integration time gives you better sensor resolution (402ms = 16-bit data) */
  // sensorTSL.setIntegrationTime(TSL2561_INTEGRATIONTIME_13MS);      /* fast but low resolution */
  sensorTSL.setTiming(TSL2591_INTEGRATIONTIME_100MS);  /* medium resolution and speed   */
  // sensorTSL.setIntegrationTime(TSL2561_INTEGRATIONTIME_402MS);  /* 16-bit data but slowest conversions */

  /* Update these values depending on what you've set above! */  
  //Serial.println("------------------------------------");
  //Serial.print  ("Gain:         "); Serial.println("Auto");
  //Serial.print  ("Timing:       "); Serial.println("101 ms");
  //Serial.println("------------------------------------");

  return false;
}

bool initMOD1016(){
  mod1016.init(ciLightningIRQPin);
  //autoTuneCaps(ciLightningIRQPin);
  mod1016.setTuneCaps(7);  // The number I used here (7) came on the packaging
  mod1016.setOutdoors();
  mod1016.setNoiseFloor(5);

  //mod1016.disableDisturbers();

  //Serial.println("TUNE\tIN/OUT\tNOISEFLOOR");
  //Serial.print(mod1016.getTuneCaps(), HEX);
  //Serial.print("\t");
  //Serial.print(mod1016.getAFE(), BIN);
  //Serial.print("\t");
  //Serial.println(mod1016.getNoiseFloor(), HEX);
  //Serial.print("\n");
  attachInterrupt(digitalPinToInterrupt(ciLightningIRQPin),MOD1016Irq,RISING);
  mod1016.getIRQ();
  //Serial.println("after interrupt");
  if(mod1016.getTuneCaps() != 7){
    Serial.println("Lightning Detector not readable");
    return true;
  }
  return false;
}

bool initVEML6075(){
  if (! uv.begin()) {
    Serial.println("Failed to communicate with VEML6075 sensor, check wiring?");
    return true;
  }
  //Serial.println("Found VEML6075 sensor");

  // Set the integration constant
  uv.setIntegrationTime(VEML6075_100MS);
  // Get the integration constant and print it!
  //Serial.print("Integration time set to ");
  /*switch (uv.getIntegrationTime()) {
    case VEML6075_50MS: Serial.print("50"); break;
    case VEML6075_100MS: Serial.print("100"); break;
    case VEML6075_200MS: Serial.print("200"); break;
    case VEML6075_400MS: Serial.print("400"); break;
    case VEML6075_800MS: Serial.print("800"); break;
  }
  Serial.println("ms"); */

  // Set the high dynamic mode
  uv.setHighDynamic(false);
  // Get the mode
  if (uv.getHighDynamic()) {
    //Serial.println("High dynamic reading mode");
  } else {
    //Serial.println("Normal dynamic reading mode");
  }

  // Set the mode
  uv.setForcedMode(false);
  // Get the mode
  if (uv.getForcedMode()) {
    //Serial.println("Forced reading mode");
  } else {
    //Serial.println("Continuous reading mode");
  }

  // Set the calibration coefficients
  uv.setCoefficients(2.55, 1.00,  // UVA_A and UVA_B coefficients
                     3.80, 1.10,  // UVB_C and UVB_D coefficients
                     0.006000, 0.003100); // UVA and UVB responses

  //Serial.print("Raw UVA reading:  "); Serial.println(uv.readUVA());
  //Serial.print("Raw UVB reading:  "); Serial.println(uv.readUVB());
  //Serial.print("UV Index reading: "); Serial.println(uv.readUVI());

  return false;
}

void initLEDs()
{
  int td1 = 400;
  int td2 = 100;
  
  // Test RGB LED on startup
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);

  // Test RED
  digitalWrite(ciLedRedPin, HIGH);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);
  delay(td1);
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);
  delay(td2);
  
  // Test GREEN
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, HIGH);
  digitalWrite(ciLedBluePin, LOW);
  delay(td1);
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);
  delay(td2);

  // Test BLUE
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, HIGH);
  delay(td1);
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);
  delay(td2);

  // end test
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, HIGH);
  digitalWrite(ciLedBluePin, LOW);
  delay(100);
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);
  delay(100);
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, HIGH);
  digitalWrite(ciLedBluePin, LOW);
  delay(100);
  digitalWrite(ciLedRedPin, LOW);
  digitalWrite(ciLedGreenPin, LOW);
  digitalWrite(ciLedBluePin, LOW);
  delay(100);

}

bool initRTC(){
  rtc.begin();
  if (! rtc.isrunning()) {
    Serial.println("RTC is NOT running!");
    // following line sets the RTC to the date & time this sketch was compiled
    // rtc.adjust(DateTime(__DATE__, __TIME__));
    return true;
  }
  return false;
}

bool initTHP(){
  if(!sensorTHP.begin())
  {
    Serial.println("Could not find BME280 sensor!");
    return true;
  }
  return false;
}
