float calcDewpoint(float t, float h) {
  
  float ctemp = (t - 32.0) * 5.0/9.0;
  float k;
  k = 243.04 * (log(h/100.0) + ((17.625 * ctemp)/(243.04 + ctemp)))/(17.625 - log(h/100.0) - ((17.625 * ctemp)/(243.04 + ctemp)));
  k = k * 9.0/5.0 + 32.0;
  
  return k;
}

float calcFeelsLike(float t, float h, float g){
  if ((t < 50.0) && (g > 3.0)){
    return 35.74+0.6215*t-35.75*pow(g,0.16)+0.4275*t*pow(g,0.16);
  }
  
  if ((t > 79.9) && (h > 13.0)){
    float c1 = -42.38, c2 = 2.049, c3 = 10.14, c4 = -0.2248, c5= -6.838e-3, c6=-5.482e-2, c7=1.228e-3, c8=8.528e-4, c9=-1.99e-6  ;
    float A = (( c5 * t) + c2) * t + c1;
    float B = (((c7 * t) + c4) * t + c3) * h;
    float C = (((c9 * t) + c8) * t + c6) * h * h;
  
    return A + B + C;
  }

  return t;
}
