#! /usr/bin/python

from Phidgets.PhidgetException import *
from Phidgets.Events.Events import *
from Phidgets.Devices.InterfaceKit import *
from Phidgets.Devices.TemperatureSensor import *
from time import sleep
from datetime import *
import shlex, subprocess
import os.path

errors = ""
fileLocation = "/media/usb0/data.txt"
weatherLED = 0
usbLED = 1
errorLED = 2

def close():
    global interfaceKit
    global temperatureSensor
    global errors
    try:
        interfaceKit.setOutputState(weatherLED,0)
        interfaceKit.setOutputState(usbLED,0)
        interfaceKit.setOutputState(errorLED,0)
    except PhidgetException as e:
        errors = errors + "Phidget Exception on turning off LEDs\n"
    temperatureSensor.closePhidget()
    interfaceKit.closePhidget()

try:
    temperatureSensor = TemperatureSensor()
    interfaceKit = InterfaceKit()
except RuntimeError as e:
    errors = errors + "Runtime Exception on object creation\n"

try:
    temperatureSensor.openPhidget(142768)
    interfaceKit.openPhidget(48498)
except PhidgetException as e:
    errors = errors + "Phidget Exception on Open\n"

try:
    interfaceKit.waitForAttach(1000)
    temperatureSensor.waitForAttach(1000)
except PhidgetException as e:
    errors = errors + "Phidget Exception on Attach\n"

try:
    interfaceKit.setOutputState(weatherLED,1)
    # For temp and humidity
    interfaceKit.setRatiometric(1)
except PhidgetException as e:
    errors = errors + "Phidget Exception on Ratiometric turn on\n"

try:
    currentTemp = (interfaceKit.getSensorValue(0) * 0.22222) - 61.11
    currentRH = (interfaceKit.getSensorValue(1) * 0.1906) - 40.2
except PhidgetException as e:
    errors = errors + "Phidget Exception on reading Temperature and RH\n"

try:
    # For shortwave light sensor
    interfaceKit.setRatiometric(0)
except PhidgetException as e:
    errors = errors + "Phidget Exception on Ratiometric turn off\n"

sleep(0.5)

try:
    currentSW = interfaceKit.getSensorValue(7)
except PhidgetException as e:
    errors = errors + "Phidget Exception on reading Shortwave\n"

try:
    currentIRTemp = temperatureSensor.getTemperature(0)
    boardTemp = temperatureSensor.getAmbientTemperature()
except PhidgetException as e:
    errors = errors + "Phidget Exception on reading IR Temperature"  

outputLine = ""
outputLine = outputLine + str(datetime.now()) + ","
outputLine = outputLine + "T=" + str(currentTemp) + ","
outputLine = outputLine + "RH=" + str(currentRH) + ","
outputLine = outputLine + "SW=" + str(currentSW) + ","
outputLine = outputLine + "IR-T=" + str(currentIRTemp) + ","
outputLine = outputLine + "IR-Brd=" + str(boardTemp) + "\n"

appendFile = open(fileLocation, 'a')
appendFile.write(outputLine)
if errors is not "":
    appendFile.write(str(datetime.now()) + ":\n" + errors)
appendFile.close()

# ======= Check whether USB key is attached ======

lockFile = "/root/WeatherStation/semaphore.txt"
checkUSBcommand = "mount | grep sdb1"

checkUSBprocess = subprocess.Popen(checkUSBcommand, shell=True,
                            stdin=subprocess.PIPE, stdout=subprocess.PIPE)
output = checkUSBprocess.communicate()[0]
usbLocation = None

if len(output) > 3:  # If we have more than a newline, key is attached
    outputArray = output.split("usb")
    usbLocation = outputArray[1][0]

if usbLocation is None:
    try:
         interfaceKit.setOutputState(errorLED,1)
         sleep(0.5)
         interfaceKit.setOutputState(errorLED,0)
    except PhidgetException as e:
        print "Exception"
    # If there is no usb key, remove any locks
    file = open(lockFile, "w")
    file.write("0\n")
    file.flush()
    file.close
    close()
    print "No usb found"
    exit(0)

file = open(lockFile, "r")
lock = file.readline().rstrip()
if lock is not "0":
    # print "File already locked"
    try:
         interfaceKit.setOutputState(errorLED,1)
         sleep(0.1)
         interfaceKit.setOutputState(errorLED,0)
    except PhidgetException as e:
        print "Exception"
    close()
    exit(0)

# If we've gotten this far, there is a key and we need to write to it.
try: 
    interfaceKit.setOutputState(usbLED,1)
    sleep(0.1)
except PhidgetException as e:
    print ""

# Lock the semaphore
file = open(lockFile, "w")
file.write("1\n")
file.flush()
file.close

usbLocation = "/media/usb" + usbLocation + "/"
print usbLocation

copyDataCommand = "cp /media/usb0/data.txt " + usbLocation

dataProcess = subprocess.Popen(copyDataCommand, 
			shell=True, stdout=subprocess.PIPE)
while dataProcess.poll() != 0:
        sleep(0.1)

copyImagesCommand = "cp /media/usb0/*.jpg " + usbLocation

imageProcess = subprocess.Popen(copyImagesCommand,
                        shell=True, stdout=subprocess.PIPE)
while imageProcess.poll() != 0:
        sleep(0.1)

sleep(2)

# Unlock the semaphore
file = open(lockFile, "w")
file.write("0\n")
file.close

close()
exit(0)
