/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.UnsafeXDisposerRecord;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.java2d.Disposer;
import sun.misc.Unsafe;

public class XTranslateCoordinates {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private boolean __executed = false;
    long _scr_w;
    long _dest_w;
    int _src_x;
    int _src_y;
    long dest_x_ptr = unsafe.allocateMemory(Native.getIntSize());
    long dest_y_ptr = unsafe.allocateMemory(Native.getIntSize());
    long child_ptr = unsafe.allocateMemory(Native.getLongSize());
    UnsafeXDisposerRecord disposer;

    public XTranslateCoordinates(long l, long l2, int n, int n2) {
        this.set_scr_w(l);
        this.set_dest_w(l2);
        this.set_src_x(n);
        this.set_src_y(n2);
        this.disposer = new UnsafeXDisposerRecord("XTranslateCoordinates", this.dest_x_ptr, this.dest_y_ptr, this.child_ptr);
        Disposer.addRecord(this, this.disposer);
    }

    public int execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(XErrorHandler xErrorHandler) {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                throw new IllegalStateException("Disposed");
            }
            if (this.__executed) {
                throw new IllegalStateException("Already executed");
            }
            this.__executed = true;
            if (xErrorHandler != null) {
                XToolkit.WITH_XERROR_HANDLER(xErrorHandler);
            }
            int n = XlibWrapper.XTranslateCoordinates(XToolkit.getDisplay(), this.get_scr_w(), this.get_dest_w(), this.get_src_x(), this.get_src_y(), this.dest_x_ptr, this.dest_y_ptr, this.child_ptr);
            if (xErrorHandler != null) {
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            int n2 = n;
            return n2;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isExecuted() {
        return this.__executed;
    }

    public boolean isDisposed() {
        return this.disposer.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                return;
            }
            this.disposer.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public long get_scr_w() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._scr_w;
    }

    public void set_scr_w(long l) {
        this._scr_w = l;
    }

    public long get_dest_w() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._dest_w;
    }

    public void set_dest_w(long l) {
        this._dest_w = l;
    }

    public int get_src_x() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._src_x;
    }

    public void set_src_x(int n) {
        this._src_x = n;
    }

    public int get_src_y() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._src_y;
    }

    public void set_src_y(int n) {
        this._src_y = n;
    }

    public int get_dest_x() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getInt(this.dest_x_ptr);
    }

    public void set_dest_x(int n) {
        Native.putInt(this.dest_x_ptr, n);
    }

    public int get_dest_y() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getInt(this.dest_y_ptr);
    }

    public void set_dest_y(int n) {
        Native.putInt(this.dest_y_ptr, n);
    }

    public long get_child() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.child_ptr);
    }

    public void set_child(long l) {
        Native.putLong(this.child_ptr, l);
    }
}

