/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.Vector3D;

public class InterpolationUtil {
    public static Rotation slerp(Rotation rotation, Rotation rotation2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = rotation.getQ0();
        double d8 = rotation.getQ1();
        double d9 = rotation.getQ2();
        double d10 = rotation.getQ3();
        double d11 = rotation2.getQ0();
        double d12 = d7 * d11 + d8 * (d6 = rotation2.getQ1()) + d9 * (d5 = rotation2.getQ2()) + d10 * (d4 = rotation2.getQ3());
        if (d12 < 0.0) {
            d11 = -d11;
            d6 = -d6;
            d5 = -d5;
            d4 = -d4;
            d12 = -d12;
        }
        double d13 = Math.acos(d12);
        double d14 = Math.sqrt(1.0 - d12 * d12);
        if (d14 > 0.001) {
            d3 = Math.sin((1.0 - d) * d13) / d14;
            d2 = Math.sin(d * d13) / d14;
        } else {
            d3 = 1.0 - d;
            d2 = d;
        }
        return new Rotation(d3 * d7 + d2 * d11, d3 * d8 + d2 * d6, d3 * d9 + d2 * d5, d3 * d10 + d2 * d4, true);
    }

    public static double smooth(double d, double d2, double d3) {
        double d4 = d3 * d3 * (3.0 - 2.0 * d3);
        return d2 * d4 + d * (1.0 - d4);
    }

    public static Vector3D smooth(Vector3D vector3D, Vector3D vector3D2, double d) {
        return new Vector3D(InterpolationUtil.smooth(vector3D.getX(), vector3D2.getX(), d), InterpolationUtil.smooth(vector3D.getY(), vector3D2.getY(), d), InterpolationUtil.smooth(vector3D.getZ(), vector3D2.getZ(), d));
    }

    public static double linear(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public static Vector3D linear(Vector3D vector3D, Vector3D vector3D2, double d) {
        return new Vector3D(InterpolationUtil.linear(vector3D.getX(), vector3D2.getX(), d), InterpolationUtil.linear(vector3D.getY(), vector3D2.getY(), d), InterpolationUtil.linear(vector3D.getZ(), vector3D2.getZ(), d));
    }
}

