#include <IRremote.h> 
#include <LEDCodes.h>

int receiver = 3; //digital pin#
IRrecv irrecv(receiver); // create instance of 'irrecv'
decode_results results;

boolean understood = false;
boolean turnedOff = false;
byte command = 0;
byte lastCommand = 25;


void setup() {
  Serial.begin(115200); // for serial monitor output
  pinMode(13,OUTPUT);
  irrecv.enableIRIn(); // Start the receiver
}

void loop() 
{
   if (irrecv.decode(&results)) // have we received an IR signal?
  {
    digitalWrite(13,HIGH);
    understood = true;
    switch(results.value){
    case BRIGHTUPCODE:    command = 1;  break;
    case BRIGHTDOWNCODE:  command = 2;  break;
    case PLAYPAUSECODE:   command = 3;  break;
    case REDCODE:       command = 5;  break;
    case ONOFFCODE:
    turnedOff = !turnedOff;
    if(turnedOff)
      SendCode(4);
    if(!turnedOff)
      command = lastCommand;
    break;
    case GREENCODE:       command = 6;  break;
    case BLUECODE:        command = 7;  break;
    case WHITECODE:       command = 8;  break;
    case Button9Code:     command = 9;  break;
    case Button10Code:   command = 10;  break;
    case Button11Code:  command = 11;  break;
    case Button12Code:  command = 12;  break;
    case Button13Code:  command = 13;  break;
    case Button14Code:  command = 14;  break;
    case Button15Code:  command = 15;  break;
    case Button16Code:  command = 16;  break;
    case Button17Code:  command = 17;  break;
    case Button18Code:  command = 18;  break;
    case Button19Code:  command = 19;  break;
    case Button20Code:  command = 20;  break;
    case Button21Code:  command = 21;  break;
    case Button22Code:  command = 22;  break;
    case Button23Code:  command = 23;  break;
    case Button24Code:  command = 24;  break;
    case REDUPCODE:     command = 25;  break;
    case GREENUPCODE:   command = 26;  break;
    case BLUEUPCODE:    command = 27;  break;
    case QUICKCODE:     command = 28;  break;
    case REDDOWNCODE:   command = 29;  break;
    case GREENDOWNCODE: command = 30;  break;
    case BLUEDOWNCODE:  command = 31;  break;
    case SLOWCODE: command = 32;  break;
    case DIY1CODE: command = 33;  break;
    case DIY2CODE: command = 34;  break;
    case DIY3CODE: command = 35;  break;
    case AUTOCODE: command = 36;  break;
    case DIY4CODE: command = 37;  break;
    case DIY5CODE: command = 38;  break;
    case DIY6CODE: command = 39;  break;
    case FLASHCODE: command = 40;  break;
    case JUMP3CODE: command = 41;  break;
    case JUMP7CODE: command = 42;  break;
    case FADE3CODE: command = 43;  break;
    case FADE7CODE: command = 44;  break;    
    default:
      understood = false; 
    break;
    }
    if(understood && !turnedOff) 
    {
      SendCode(command);
      lastCommand = command;
    }
    irrecv.resume();
    delay(20);
    digitalWrite(13,LOW);
  }
}

void SendCode(byte tempCommand)
{
  int dig1 = tempCommand/10;
  int dig2 = tempCommand%10;
  Serial.write(dig1);
  Serial.write(dig2); 
}

