/*
TSJWang
September 2, 2015
Summer is ending, I've been away and I haven't built anything
I always wanted to build a watch for myself
I also have a ton of Sparkfun bubble displays lying around
This is a 24 hour format digital watch that has a flashing dot for indicating seconds
Uses the ATTiny84, but I think you can use the 44. 24 might be not enough flash.
Uses 16MHz crystal for accuracy, 74HC595 shift register and your choice of 7 segment display.
Two buttons/switches required.
*/


#include "avr/interrupt.h"  //We are using pin change interrupts

//Set these as you like
volatile int dig1 = 0;    //Hours tens
volatile int dig2 = 0;    //Hours ones
volatile int dig3 = 0;    //Minutes tens
volatile int dig4 = 0;    //Minutes ones

const int latchPin = A3;  //Pin connected to ST_CP of 74HC595
const int clockPin = A4;  //Pin connected to SH_CP of 74HC595
const int dataPin = A5;   //Pin connected to DS of 74HC595

const int dig1Pin = A0;  //Pin to multiplex and display digit1
const int dig2Pin = A1;  //Pin to multiplex and display digit2
const int dig3Pin = A2;  //Pin to multiplex and display digit3
const int dig4Pin = A6;  //Pin to multiplex and display digit4

//Two values below for debouncing.
volatile unsigned long xlastDebounceTime = 0;
volatile unsigned long ylastDebounceTime = 0;
long debounceDelay = 150;    // the debounce time; increase if the output flickers

//We will be using this value to prevent rolloever for millis() that occurs every 49 days.
unsigned long currentMillis = 0;
volatile unsigned long lastMillis = 0;

int secTime = 0;  //The seconds counter
byte tictoc = 0;  //Flashing dot

void setup()
{
  pinMode(latchPin, OUTPUT);
  pinMode(clockPin, OUTPUT);
  pinMode(dataPin, OUTPUT);
  pinMode(dig1Pin, OUTPUT);
  pinMode(dig2Pin, OUTPUT);
  pinMode(dig3Pin, OUTPUT);
  pinMode(dig4Pin, OUTPUT);
  cli();  //turns interrupts off
  GIMSK |= 0b00110000;  //turn on pin change interrupts
  PCMSK0 |= 0b10000000;  //turn on interrupts on PCINT7(A7)
  PCMSK1 |= 0b00000100;  //turn on interrupts on PCINT10(8)
  sei();  //turns interrupts back on
}

void loop()
{
  display(dig1,dig2,dig3,dig4);    //display all digits
  
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  //This part toggles the dot every second
  currentMillis = millis();
  if((unsigned long)(currentMillis - lastMillis) >= 1000)
  {
    secTime++;      //Taking use of this if loop to increment the second
    if(tictoc == 1)
    {
      dig2 = dig2 - 10;
      tictoc = 0;
    }
    else
    {
      dig2 = dig2 + 10;
      tictoc = 1;
    }
    lastMillis = millis();
  }
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
  //This part does the counting on the clock.
  if(secTime == 60)
  {
    secTime = 0;
    dig4++;
    if(dig4 == 10)
    {
      dig4 = 0;
      dig3++;
      if(dig3 == 6)
      {
        dig3 = 0;
        dig2++;
        if(dig2 == 10)
        {
          dig2 = 0;
          dig1++;
          if(dig1 == 3)
          {
            dig1 = 0;
          }
        }
      }
    }
  }
  if(dig1 == 2 && dig2 == 4)
  {
    dig1 = 0;
    dig2 = 0;
  }
  //The if loops above just tell when the digits should reset or roll over
  //////////////////////////////////////////////////////////////////////
  //////////////////////////////////////////////////////////////////////
}

/***********************************************************************/
//Below are the pin change interrupt functions

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//Executes if A7 is pushed
ISR(PCINT0_vect)
{
  secTime = 0;      //Make seconds 0
  if(tictoc == 1)   //Set the dot to 0 so we aren't confused
  {
    dig2 = dig2 - 10;
    tictoc = 0;
  }
  currentMillis = millis();
  if ((unsigned long)(currentMillis - xlastDebounceTime) >= debounceDelay)
  {
    dig4--;
    if(dig4 == -1)
    {
      dig4 = 9;
      dig3--;
      if(dig3 == -1)
      {      
        dig3 = 5;
        dig2--;
        if(dig2 == -1)
        {
          dig2 = 9;
          dig1--;
          if(dig1 == -1)
          {
            dig1 = 2;
          }
        }
      }
    }
    //The above was, again, more if loops for digit overflow and stuff.
    
    //Below is handling the problem of going to 29 instead of 00 when backing up.
    if(dig1 == 2 && dig2 == 9)
    {
      dig2 = 3;
    }
    xlastDebounceTime = millis();
  }
}
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//Executes if 8 is pushed
ISR(PCINT1_vect)
{
  secTime = 0;      //Make seconds 0
  if(tictoc == 1)   //Set the dot to 0 so we aren't confused
  {
    dig2 = dig2 - 10;
    tictoc = 0;
  }
  currentMillis = millis();
  if ((unsigned long)(currentMillis - ylastDebounceTime) >= debounceDelay)
  {
    dig4++;
    if(dig4 == 10)
    {
      dig4 = 0;
      dig3++;
      if(dig3 == 6)
      {
        dig3 = 0;
        dig2++;
        if(dig2 == 10)
        {
          dig2 = 0;
          dig1++;
          if(dig1 == 3)
          {
            dig1 = 0;
          }
        }
      }
    }
    //The above was, again, more if loops for digit overflow and stuff. 
    
    //Below is handling the problem of going to 24 instead of 00 when going forwards.
    if(dig1 == 2 && dig2 == 4)
    {
      dig1 = 0;
      dig2 = 0;
    }
    ylastDebounceTime = millis();
  }
}



