@echo off
if not exist ATmega8u2Code/Debug/batchisp.exe (
echo.
echo The program used to flash the memory couldn't be found...
echo Did you move this .bat file?  Or delete something in the ATmega8u2Code folder?
echo Press any key to exit...
goto EXIT
)
echo.
echo Abracadabra!
cd ATmega8u2Code/Debug
echo Attempting to re-flash for an Arduino Uno R1/R2
@echo on
batchisp -device at90usb82 -hardware usb -operation erase f memory flash blankcheck loadbuffer "DoubleJoy.hex" program verify start reset 1024
@echo off

if %errorlevel% NEQ 0 (
    goto R3FLASH
) else ( 
    goto SUCCESS
)

:R3FLASH
echo Trying to re-flash for an Arduino Uno R3...
@echo on
batchisp -device atmega16u2 -hardware usb -operation erase f memory flash blankcheck loadbuffer "DoubleJoy.hex" program verify start reset 1024
@echo off
if %errorlevel% NEQ 0 (
    echo %errorlevel%
    echo The firmware was NOT loaded...
    echo.
    echo Did you install the Atmel FLIP program? - http://www.atmel.com/tools/FLIP.aspx -
    echo Is the Arduino plugged in?
    echo Is is it in 'Arduino UNO DFU' mode?
    echo Press any key to exit..
    goto EXIT
) else (
    goto SUCCESS
)

:SUCCESS
echo Now, you need to unplug the Arduino and plug it back in,
echo but it will show up as a joystick! Press any key to exit....
goto EXIT


:EXIT
pause > nul