/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Button;
import controlP5.CColor;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ListBoxItem;
import controlP5.Slider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import processing.core.PApplet;
import processing.event.KeyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropdownList
extends ControlGroup<DropdownList> {
    protected int _myItemHeight = 13;
    protected int maxButtons = 0;
    protected int _myOriginalBackgroundHeight = 0;
    protected Slider _myScrollbar;
    protected String _myName;
    protected float _myScrollValue = 0.0f;
    protected boolean isScrollbarVisible = true;
    private int _myScrollbarWidth = 6;
    protected int _myHeight;
    protected List<ListBoxItem> items = new ArrayList<ListBoxItem>();
    protected List<Button> buttons = new ArrayList<Button>();
    protected int spacing = 1;
    protected boolean isMultipleChoice = false;
    protected boolean pulldown;
    private int itemOffset = 0;
    private boolean isToUpperCase = true;
    private boolean bulkadding;

    public DropdownList(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0, 0, 99, 99);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected DropdownList(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, 9);
        this._myWidth = n3;
        this._myName = string;
        this._myBackgroundHeight = n4 < 10 ? 10 : n4;
        this._myScrollbar = new Slider(this.cp5, this._myParent, string + "Scroller", 0.0f, 1.0f, 1.0f, this._myWidth - this._myScrollbarWidth, 0, this._myScrollbarWidth, this._myBackgroundHeight);
        this._myScrollbar.setBroadcast(false);
        this._myScrollbar.setSliderMode(0);
        this._myScrollbar.setMoveable(false);
        this._myScrollbar.setLabelVisible(false);
        this._myScrollbar.setParent(this);
        this._myScrollbar.addListener(this);
        this._myScrollbar.setVisible(false);
        this._myScrollbar.hide();
        this._myScrollbar.updateDisplayMode(0);
        this.add(this._myScrollbar);
        this.setHeight(this._myBackgroundHeight);
        this.actAsPulldownMenu(true);
    }

    @Override
    public String getStringValue() {
        return this.getCaptionLabel().toString();
    }

    @Override
    public DropdownList setValue(float f) {
        for (ListBoxItem listBoxItem : this.items) {
            if ((float)listBoxItem.value != f) continue;
            this._myValue = listBoxItem.value;
            this.setLabel(listBoxItem.name);
            this.cp5.getControlBroadcaster().broadcast(new ControlEvent(this), 2);
            break;
        }
        return this;
    }

    public DropdownList setIndex(int n) {
        if (n >= this.items.size() || n < 0) {
            return this;
        }
        this.setValue(this.items.get(n).getValue());
        return this;
    }

    public DropdownList hideScrollbar() {
        this.isScrollbarVisible = false;
        this._myScrollbar.hide();
        return this;
    }

    public DropdownList showScrollbar() {
        this.isScrollbarVisible = true;
        if (this.items.size() * this._myItemHeight > this._myBackgroundHeight && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        return this;
    }

    public boolean isScrollbarEnabled() {
        return this.isScrollbarVisible;
    }

    public DropdownList setScrollbarVisible(boolean bl) {
        if (bl) {
            return this.showScrollbar();
        }
        return this.hideScrollbar();
    }

    public boolean isScrollable() {
        return this._myScrollbar.isVisible();
    }

    public DropdownList scroll(float f) {
        if (this.items.size() * this._myItemHeight > this._myBackgroundHeight) {
            this._myScrollbar.setValue(PApplet.abs((float)(1.0f - PApplet.min((float)PApplet.max((float)0.0f, (float)f), (float)1.0f))));
        }
        return this;
    }

    @ControlP5.Invisible
    public float getScrollPosition() {
        return this._myScrollbar.getValue();
    }

    @ControlP5.Invisible
    public void scrolled(int n) {
        float f = 1.0f / (float)this.items.size();
        this.scroll(1.0f - this.getScrollPosition() + (float)n * f);
    }

    protected void scroll() {
        this.itemOffset = 0;
        if (this.buttons.size() < this.items.size() && this.isScrollbarVisible) {
            this._myScrollbar.show();
            this.itemOffset = (int)Math.abs(this._myScrollValue * (float)(this.items.size() - this.buttons.size()));
        } else {
            this._myScrollbar.hide();
        }
        if (!this.bulkadding) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ListBoxItem listBoxItem = this.items.get(this.itemOffset + i);
                Button button = this.buttons.get(i);
                button.getCaptionLabel().toUpperCase(this.isToUpperCase);
                button.setColor(listBoxItem.getColor());
                button.getCaptionLabel().set(listBoxItem.getText());
                button._myValue = listBoxItem.getValue();
            }
        }
    }

    @ControlP5.Invisible
    public DropdownList updateListBoxItems() {
        this.scroll();
        return this;
    }

    public DropdownList toUpperCase(boolean bl) {
        this._myLabel.toUpperCase(bl);
        this.isToUpperCase = bl;
        this.updateListBoxItems();
        return this;
    }

    public DropdownList setItemHeight(int n) {
        this._myItemHeight = n;
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get((int)i).height = n;
            this.buttons.get((int)i).position.y = (n + this.spacing) * i;
        }
        this.setHeight(this._myOriginalBackgroundHeight);
        return this;
    }

    @Override
    public DropdownList setHeight(int n) {
        this._myOriginalBackgroundHeight = n;
        this._myBackgroundHeight = this._myOriginalBackgroundHeight / (this._myItemHeight + this.spacing) * (this._myItemHeight + this.spacing);
        this.maxButtons = this._myBackgroundHeight / (this._myItemHeight + this.spacing);
        int n2 = this._myBackgroundHeight / (this._myItemHeight + this.spacing);
        int n3 = this.buttons.size();
        if (n2 < n3) {
            for (int i = this.buttons.size() - 1; i >= n2; --i) {
                this.cp5.remove(this.cp5.getController(this.buttons.get(i).getName()));
                this.controllers.remove(this.buttons.get(i));
                this.buttons.remove(i);
            }
        } else if (n3 < n2) {
            int n4 = Math.min(n2, this.items.size());
            this.addListButton(n4 -= n3);
        }
        this.updateBackground();
        this.scroll();
        return this;
    }

    @Override
    @ControlP5.Invisible
    public DropdownList updateInternalEvents(PApplet pApplet) {
        boolean bl;
        boolean bl2 = (float)this.cp5.getWindow().mouseX > this.getAbsolutePosition().x && (float)this.cp5.getWindow().mouseX < this.getAbsolutePosition().x + (float)this._myWidth;
        boolean bl3 = bl = (float)this.cp5.getWindow().mouseY > this.getAbsolutePosition().y - 1.0f && (float)this.cp5.getWindow().mouseY < this.getAbsolutePosition().y + (float)this._myBackgroundHeight;
        boolean bl4 = this.isOpen() ? bl2 && bl : (this.isInsideGroup = false);
        if (this.isBarVisible && this.isInside || this.isInsideGroup) {
            this.cp5.getWindow().setMouseOverController(this);
        }
        return this;
    }

    private void updateScroll() {
        this._myScrollValue = this._myScrollbar.getValue();
        this._myScrollbar.setValue(this._myScrollValue);
        if (this.buttons.size() < this.items.size() && this.isScrollbarVisible) {
            this._myScrollbar.show();
        }
        this.updateBackground();
        this.scroll();
    }

    private void updateBackground() {
        if (this.items.size() * (this._myItemHeight + this.spacing) < this._myOriginalBackgroundHeight) {
            this._myBackgroundHeight = this.items.size() * (this._myItemHeight + this.spacing);
        }
        if (this.buttons.size() < this.items.size()) {
            this._myScrollbar.setHeight(this._myBackgroundHeight - this.spacing);
            this._myScrollbar.show();
        } else {
            this._myScrollbar.hide();
        }
        this.updateButtonWidth();
    }

    private void updateButtonWidth() {
        boolean bl;
        boolean bl2 = bl = this.buttons.size() < this.items.size() && this.isScrollbarVisible;
        if (bl) {
            for (int i = 1; i < this.controllers.size(); ++i) {
                ((Button)this.controllers.get((int)i)).width = this._myWidth - this._myScrollbarWidth - 1;
            }
        } else {
            for (int i = 1; i < this.controllers.size(); ++i) {
                ((Button)this.controllers.get((int)i)).width = this._myWidth;
            }
        }
    }

    public DropdownList setScrollbarWidth(int n) {
        this._myScrollbar.setWidth(n);
        this._myScrollbarWidth = n;
        this.setWidth(this.getWidth());
        return this;
    }

    @Override
    public DropdownList setWidth(int n) {
        this._myWidth = n;
        this.updateButtonWidth();
        this._myScrollbar.position.x = this._myWidth - this._myScrollbarWidth;
        return this;
    }

    @Override
    public DropdownList setSize(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
        return this;
    }

    protected DropdownList addListButton(int n) {
        for (int i = 0; i < n && this.buttons.size() < this.maxButtons; ++i) {
            int n2 = this.buttons.size();
            Button button = new Button(this.cp5, this, this._myName + "Button" + n2, n2, 0, n2 * (this._myItemHeight + this.spacing), this._myWidth, this._myItemHeight);
            button.setMoveable(false);
            this.add(button);
            this.cp5.register(null, "", button);
            button.setBroadcast(false);
            button.addListener(this);
            this.buttons.add(button);
        }
        this.updateScroll();
        return this;
    }

    public void beginItems() {
        this.bulkadding = true;
    }

    public void endItems() {
        this.bulkadding = false;
        this.scroll();
    }

    public ListBoxItem addItem(String string, int n) {
        ListBoxItem listBoxItem = new ListBoxItem(this, string, n);
        this.items.add(listBoxItem);
        this.addListButton(1);
        return listBoxItem;
    }

    public DropdownList addItems(String[] stringArray) {
        this.addItems(Arrays.asList(stringArray), 0);
        return this;
    }

    public DropdownList addItems(List<?> list) {
        this.addItems(list, 0);
        return this;
    }

    public DropdownList addItems(List<?> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            this.addItem(list.get(i).toString(), i + n);
        }
        return this;
    }

    public DropdownList removeItem(String string) {
        try {
            for (int i = this.items.size() - 1; i >= 0; --i) {
                if (!this.items.get((int)i).name.equals(string)) continue;
                this.items.remove(i);
            }
            if (this.buttons.size() > this.items.size()) {
                String string2 = ((Button)this.controllers.get(this.buttons.size())).getName();
                this.buttons.remove(this.cp5.getController(string2));
                this.controllers.remove(this.cp5.getController(string2));
                this.cp5.remove(string2);
            }
            this.updateScroll();
        }
        catch (Exception exception) {
            ControlP5.logger().finer("ScrollList.removeItem exception:" + exception);
        }
        return this;
    }

    public ListBoxItem getItem(int n) {
        return this.items.get(n);
    }

    public ListBoxItem getItem(String string) {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            if (!this.items.get((int)i).name.equals(string)) continue;
            return this.items.get(i);
        }
        return null;
    }

    public ListBoxItem getItem(Controller<?> controller) {
        int n;
        if (controller instanceof Button && (n = this.buttons.indexOf(controller)) >= 0) {
            return this.items.get(n + this.itemOffset);
        }
        return null;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.getController() instanceof Button) {
            try {
                this._myValue = controlEvent.getController().getValue();
                ControlEvent controlEvent2 = new ControlEvent(this);
                if (this.pulldown) {
                    this.close();
                    this.setLabel(controlEvent.getController().getLabel());
                }
                for (ControlListener controlListener : this._myControlListener) {
                    controlListener.controlEvent(controlEvent2);
                }
                this.cp5.getControlBroadcaster().broadcast(controlEvent2, 2);
                controlEvent.getController().onLeave();
                controlEvent.getController().setIsInside(false);
                controlEvent.getController().setMouseOver(false);
            }
            catch (Exception exception) {
                ControlP5.logger().warning("ListBox.controlEvent exception:" + exception);
            }
        } else {
            this._myScrollValue = -(1.0f - controlEvent.getValue());
            this.scroll();
        }
    }

    @Override
    @ControlP5.Invisible
    public void keyEvent(KeyEvent keyEvent) {
        boolean bl;
        super.keyEvent(keyEvent);
        float f = this.getAbsolutePosition().x;
        float f2 = this.getAbsolutePosition().y;
        boolean bl2 = bl = (float)this.getWindow().mouseX > f && (float)this.getWindow().mouseX < f + (float)this._myWidth && (float)this.getWindow().mouseY > f2 - (float)this.getBarHeight() && (float)this.getWindow().mouseY < f2 + (float)this._myOriginalBackgroundHeight;
        if (bl && this.isOpen()) {
            float f3 = 1.0f / (float)this.items.size();
            if (this.cp5.isShiftDown()) {
                f3 *= 10.0f;
            } else if (this.cp5.isAltDown()) {
                f3 = 1.0f;
            }
            if (keyEvent.getAction() == 1) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        this._myScrollbar.setValue(PApplet.constrain((float)(this._myScrollbar.getValue() + f3), (float)0.0f, (float)1.0f));
                        break;
                    }
                    case 40: {
                        this._myScrollbar.setValue(PApplet.constrain((float)(this._myScrollbar.getValue() - f3), (float)0.0f, (float)1.0f));
                    }
                }
            }
        }
    }

    public DropdownList actAsPulldownMenu(boolean bl) {
        this.pulldown = bl;
        if (this.pulldown) {
            this.close();
        }
        return this;
    }

    public DropdownList clear() {
        int n;
        for (n = this.items.size() - 1; n >= 0; --n) {
            this.items.remove(n);
        }
        this.items.clear();
        for (n = this.buttons.size() - 1; n >= 0; --n) {
            String string = ((Button)this.controllers.get(this.buttons.size())).getName();
            this.buttons.remove(this.cp5.getController(string));
            this.controllers.remove(this.cp5.getController(string));
            this.cp5.remove(string);
        }
        this.updateScroll();
        this._myBackgroundHeight = 0;
        return this;
    }

    @Override
    public DropdownList setColor(CColor cColor) {
        this.setColorActive(cColor.getActive());
        this.setColorForeground(cColor.getForeground());
        this.setColorBackground(cColor.getBackground());
        this.setColorLabel(cColor.getCaptionLabel());
        this.setColorValue(cColor.getValueLabel());
        return this;
    }

    @Override
    public DropdownList setColorActive(int n) {
        super.setColorActive(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setActive(n);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorForeground(int n) {
        super.setColorForeground(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setForeground(n);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorBackground(int n) {
        super.setColorBackground(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setBackground(n);
        }
        this.scroll();
        return this;
    }

    @Override
    public DropdownList setColorLabel(int n) {
        super.setColorLabel(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setCaptionLabel(n);
        }
        this.scroll();
        return this;
    }

    @Override
    @ControlP5.Invisible
    public DropdownList setColorValue(int n) {
        super.setColorValue(n);
        for (int i = 0; i < this.items.size(); ++i) {
            this.items.get(i).getColor().setValueLabel(n);
        }
        this.scroll();
        return this;
    }

    public String[][] getListBoxItems() {
        String[][] stringArray = new String[this.items.size()][3];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String[]{this.items.get((int)i).name, this.items.get((int)i).text, Integer.toString(this.items.get((int)i).value)};
        }
        return stringArray;
    }

    public DropdownList setListBoxItems(String[][] stringArray) {
        this.clear();
        for (String[] stringArray2 : stringArray) {
            this.addItem(stringArray2[0], new Integer(stringArray2[2])).setText(stringArray2[1]);
        }
        return this;
    }

    @Deprecated
    public ListBoxItem item(int n) {
        return this.getItem(n);
    }

    @Deprecated
    public ListBoxItem item(String string) {
        return this.getItem(string);
    }

    @Deprecated
    public ListBoxItem item(Controller<?> controller) {
        return this.getItem(controller);
    }

    @Deprecated
    public boolean isScrollbarVisible() {
        return this.isScrollbarVisible;
    }

    @Override
    @Deprecated
    public String stringValue() {
        return this.captionLabel().toString();
    }
}

