/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.serial.Serial;

public class UnoJoyProcessingVisualizer
extends PApplet {
    PImage controller;
    int imageWidth = 516;
    int imageHeight = 521;
    Point offset = new Point(40.0f, 40.0f);
    int stickIndicatorSize = 20;
    int actionIndicatorSize = 35;
    int functionIndicatorSize = 35;
    int dpadIndicatorSize = 50;
    int stickDiameter = PApplet.parseInt((float)(0.134f * (float)this.imageWidth));
    Point leftStickPos;
    Point rightStickPos;
    Point trianglePos;
    Point circlePos;
    Point squarePos;
    Point crossPos;
    Point l1Pos;
    Point l2Pos;
    Point l3Pos;
    Point r1Pos;
    Point r2Pos;
    Point r3Pos;
    Point selectPos;
    Point startPos;
    Point homePos;
    Point dpadLeftPos;
    Point dpadUpPos;
    Point dpadRightPos;
    Point dpadDownPos;
    Point leftStickData;
    Point rightStickData;
    int triangleOn;
    int circleOn;
    int squareOn;
    int crossOn;
    int l1On;
    int l2On;
    int l3On;
    int r1On;
    int r2On;
    int r3On;
    int selectOn;
    int startOn;
    int homeOn;
    int dpadLeftOn;
    int dpadUpOn;
    int dpadRightOn;
    int dpadDownOn;
    int SerialPortLoaded;
    Serial SerialPort;
    PFont font;
    int counter;

    public UnoJoyProcessingVisualizer() {
        this.leftStickPos = new Point(0.351f * (float)this.imageWidth + this.offset.x, 0.581f * (float)this.imageWidth + this.offset.y);
        this.rightStickPos = new Point(0.642f * (float)this.imageWidth + this.offset.x, 0.581f * (float)this.imageWidth + this.offset.y);
        this.trianglePos = new Point(0.795f * (float)this.imageWidth + this.offset.x, 0.357f * (float)this.imageWidth + this.offset.y);
        this.circlePos = new Point(0.868f * (float)this.imageWidth + this.offset.x, 0.43f * (float)this.imageWidth + this.offset.y);
        this.squarePos = new Point(0.721f * (float)this.imageWidth + this.offset.x, 0.43f * (float)this.imageWidth + this.offset.y);
        this.crossPos = new Point(0.795f * (float)this.imageWidth + this.offset.x, 0.504f * (float)this.imageWidth + this.offset.y);
        this.l1Pos = new Point(0.201f * (float)this.imageWidth + this.offset.x, 0.068f * (float)this.imageWidth + this.offset.y);
        this.l2Pos = new Point(0.201f * (float)this.imageWidth + this.offset.x, 0.156f * (float)this.imageWidth + this.offset.y);
        this.l3Pos = new Point(this.leftStickPos.x, this.leftStickPos.y);
        this.r1Pos = new Point(0.795f * (float)this.imageWidth + this.offset.x, 0.068f * (float)this.imageWidth + this.offset.y);
        this.r2Pos = new Point(0.795f * (float)this.imageWidth + this.offset.x, 0.156f * (float)this.imageWidth + this.offset.y);
        this.r3Pos = new Point(this.rightStickPos.x, this.rightStickPos.y);
        this.selectPos = new Point(0.405f * (float)this.imageWidth + this.offset.x, 0.446f * (float)this.imageWidth + this.offset.y);
        this.startPos = new Point(0.583f * (float)this.imageWidth + this.offset.x, 0.446f * (float)this.imageWidth + this.offset.y);
        this.homePos = new Point(0.502f * (float)this.imageWidth + this.offset.x, 0.518f * (float)this.imageWidth + this.offset.y);
        this.dpadLeftPos = new Point(0.13f * (float)this.imageWidth + this.offset.x, 0.426f * (float)this.imageWidth + this.offset.y);
        this.dpadUpPos = new Point(0.2f * (float)this.imageWidth + this.offset.x, 0.357f * (float)this.imageWidth + this.offset.y);
        this.dpadRightPos = new Point(0.27f * (float)this.imageWidth + this.offset.x, 0.427f * (float)this.imageWidth + this.offset.y);
        this.dpadDownPos = new Point(0.2f * (float)this.imageWidth + this.offset.x, 0.5f * (float)this.imageWidth + this.offset.y);
        this.leftStickData = new Point(128.0f, 128.0f);
        this.rightStickData = new Point(128.0f, 128.0f);
        this.triangleOn = 0;
        this.circleOn = 0;
        this.squareOn = 0;
        this.crossOn = 0;
        this.l1On = 0;
        this.l2On = 0;
        this.l3On = 0;
        this.r1On = 0;
        this.r2On = 0;
        this.r3On = 0;
        this.selectOn = 0;
        this.startOn = 0;
        this.homeOn = 0;
        this.dpadLeftOn = 0;
        this.dpadUpOn = 0;
        this.dpadRightOn = 0;
        this.dpadDownOn = 0;
        this.SerialPortLoaded = 0;
        this.counter = 0;
    }

    public void setup() {
        if (Serial.list().length > 0) {
            this.SerialPortLoaded = 1;
            String string = Serial.list()[0];
            UnoJoyProcessingVisualizer.println((String)string);
            this.SerialPort = new Serial((PApplet)this, string, 38400);
        }
        this.font = this.loadFont("AngsanaNew-28.vlw");
        this.size(600, 600);
        this.rectMode(3);
        this.ellipseMode(3);
        this.smooth();
        this.controller = this.loadImage("data/game_controller.png");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void draw() {
        if (this.SerialPortLoaded == 1) {
            this.readController();
        }
        this.background(255);
        this.image(this.controller, this.offset.x, this.offset.y);
        if (this.SerialPortLoaded == 0) {
            this.textFont(this.font, 28.0f);
            this.fill(250.0f, 0.0f, 0.0f);
            this.text("Couldn't connect to the Arduino...", 175.0f, 500.0f);
        }
        this.noStroke();
        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
        if (this.l1On == 1) {
            this.ellipse(this.l1Pos.x, this.l1Pos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.r1On == 1) {
            this.ellipse(this.r1Pos.x, this.r1Pos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.l2On == 1) {
            this.ellipse(this.l2Pos.x, this.l2Pos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.r2On == 1) {
            this.ellipse(this.r2Pos.x, this.r2Pos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.l3On == 1) {
            this.ellipse(this.l3Pos.x, this.l3Pos.y, this.stickDiameter, this.stickDiameter);
        }
        if (this.r3On == 1) {
            this.ellipse(this.r3Pos.x, this.r3Pos.y, this.stickDiameter, this.stickDiameter);
        }
        this.strokeWeight(1.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.fill(255.0f, 255.0f, 255.0f, 100.0f);
        this.rect(this.leftStickPos.x, this.leftStickPos.y, this.stickDiameter, this.stickDiameter);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(2.0f);
        this.line(this.leftStickPos.x + (float)this.stickDiameter * (this.leftStickData.x - 128.0f) / 255.0f - (float)(this.stickIndicatorSize / 2), this.leftStickPos.y + (float)this.stickDiameter * (this.leftStickData.y - 128.0f) / 255.0f, this.leftStickPos.x + (float)this.stickDiameter * (this.leftStickData.x - 128.0f) / 255.0f + (float)(this.stickIndicatorSize / 2), this.leftStickPos.y + (float)this.stickDiameter * (this.leftStickData.y - 128.0f) / 255.0f);
        this.line(this.leftStickPos.x + (float)this.stickDiameter * (this.leftStickData.x - 128.0f) / 255.0f, this.leftStickPos.y + (float)this.stickDiameter * (this.leftStickData.y - 128.0f) / 255.0f - (float)(this.stickIndicatorSize / 2), this.leftStickPos.x + (float)this.stickDiameter * (this.leftStickData.x - 128.0f) / 255.0f, this.leftStickPos.y + (float)this.stickDiameter * (this.leftStickData.y - 128.0f) / 255.0f + (float)(this.stickIndicatorSize / 2));
        this.noStroke();
        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
        this.ellipse(this.leftStickPos.x + (float)this.stickDiameter * (this.leftStickData.x - 128.0f) / 255.0f, this.leftStickPos.y + (float)this.stickDiameter * (this.leftStickData.y - 128.0f) / 255.0f, (float)this.stickIndicatorSize / 1.5f, (float)this.stickIndicatorSize / 1.5f);
        this.strokeWeight(1.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.fill(255.0f, 255.0f, 255.0f, 100.0f);
        this.rect(this.rightStickPos.x, this.rightStickPos.y, this.stickDiameter, this.stickDiameter);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(2.0f);
        this.line(this.rightStickPos.x + (float)this.stickDiameter * (this.rightStickData.x - 128.0f) / 255.0f - (float)(this.stickIndicatorSize / 2), this.rightStickPos.y + (float)this.stickDiameter * (this.rightStickData.y - 128.0f) / 255.0f, this.rightStickPos.x + (float)this.stickDiameter * (this.rightStickData.x - 128.0f) / 255.0f + (float)(this.stickIndicatorSize / 2), this.rightStickPos.y + (float)this.stickDiameter * (this.rightStickData.y - 128.0f) / 255.0f);
        this.line(this.rightStickPos.x + (float)this.stickDiameter * (this.rightStickData.x - 128.0f) / 255.0f, this.rightStickPos.y + (float)this.stickDiameter * (this.rightStickData.y - 128.0f) / 255.0f - (float)(this.stickIndicatorSize / 2), this.rightStickPos.x + (float)this.stickDiameter * (this.rightStickData.x - 128.0f) / 255.0f, this.rightStickPos.y + (float)this.stickDiameter * (this.rightStickData.y - 128.0f) / 255.0f + (float)(this.stickIndicatorSize / 2));
        this.noStroke();
        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
        this.ellipse(this.rightStickPos.x + (float)this.stickDiameter * (this.rightStickData.x - 128.0f) / 255.0f, this.rightStickPos.y + (float)this.stickDiameter * (this.rightStickData.y - 128.0f) / 255.0f, (float)this.stickIndicatorSize / 1.5f, (float)this.stickIndicatorSize / 1.5f);
        if (this.triangleOn == 1) {
            this.ellipse(this.trianglePos.x, this.trianglePos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.circleOn == 1) {
            this.ellipse(this.circlePos.x, this.circlePos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.squareOn == 1) {
            this.ellipse(this.squarePos.x, this.squarePos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.crossOn == 1) {
            this.ellipse(this.crossPos.x, this.crossPos.y, this.actionIndicatorSize, this.actionIndicatorSize);
        }
        if (this.selectOn == 1) {
            this.ellipse(this.selectPos.x, this.selectPos.y, this.functionIndicatorSize, this.functionIndicatorSize);
        }
        if (this.startOn == 1) {
            this.ellipse(this.startPos.x, this.startPos.y, this.functionIndicatorSize, this.functionIndicatorSize);
        }
        if (this.homeOn == 1) {
            this.ellipse(this.homePos.x, this.homePos.y, this.functionIndicatorSize, this.functionIndicatorSize);
        }
        if (this.dpadLeftOn == 1) {
            this.ellipse(this.dpadLeftPos.x, this.dpadLeftPos.y, this.dpadIndicatorSize, this.dpadIndicatorSize);
        }
        if (this.dpadUpOn == 1) {
            this.ellipse(this.dpadUpPos.x, this.dpadUpPos.y, this.dpadIndicatorSize, this.dpadIndicatorSize);
        }
        if (this.dpadRightOn == 1) {
            this.ellipse(this.dpadRightPos.x, this.dpadRightPos.y, this.dpadIndicatorSize, this.dpadIndicatorSize);
        }
        if (this.dpadDownOn == 1) {
            this.ellipse(this.dpadDownPos.x, this.dpadDownPos.y, this.dpadIndicatorSize, this.dpadIndicatorSize);
        }
    }

    public int readSerialPort(int n, int n2) {
        while (this.SerialPort.available() == 0 && n > 0) {
            this.delay(1);
        }
        if (n <= 0) {
            return n2;
        }
        return this.SerialPort.read();
    }

    public void readController() {
        this.SerialPort.clear();
        this.SerialPort.write(0);
        int n = this.readSerialPort(25, 0);
        this.SerialPort.write(1);
        int n2 = this.readSerialPort(25, 0);
        this.SerialPort.write(2);
        int n3 = this.readSerialPort(25, 0);
        this.SerialPort.write(3);
        this.leftStickData.x = this.readSerialPort(25, 128);
        this.SerialPort.write(4);
        this.leftStickData.y = this.readSerialPort(25, 128);
        this.SerialPort.write(5);
        this.rightStickData.x = this.readSerialPort(25, 128);
        this.SerialPort.write(6);
        this.rightStickData.y = this.readSerialPort(25, 128);
        this.triangleOn = 1 & n >> 0;
        this.circleOn = 1 & n >> 1;
        this.squareOn = 1 & n >> 2;
        this.crossOn = 1 & n >> 3;
        this.l1On = 1 & n >> 4;
        this.l2On = 1 & n >> 5;
        this.l3On = 1 & n >> 6;
        this.r1On = 1 & n >> 7;
        this.r2On = 1 & n2 >> 0;
        this.r3On = 1 & n2 >> 1;
        this.selectOn = 1 & n2 >> 2;
        this.startOn = 1 & n2 >> 3;
        this.homeOn = 1 & n2 >> 4;
        this.dpadLeftOn = 1 & n2 >> 5;
        this.dpadUpOn = 1 & n2 >> 6;
        this.dpadRightOn = 1 & n2 >> 7;
        this.dpadDownOn = 1 & n3 >> 0;
    }

    public void turnAllOn() {
        this.triangleOn = 1;
        this.circleOn = 1;
        this.squareOn = 1;
        this.crossOn = 1;
        this.l1On = 1;
        this.l2On = 1;
        this.l3On = 1;
        this.r1On = 1;
        this.r2On = 1;
        this.r3On = 1;
        this.selectOn = 1;
        this.startOn = 1;
        this.homeOn = 1;
        this.dpadLeftOn = 1;
        this.dpadUpOn = 1;
        this.dpadRightOn = 1;
        this.dpadDownOn = 1;
    }

    public void turnAllOff() {
        this.triangleOn = 0;
        this.circleOn = 0;
        this.squareOn = 0;
        this.crossOn = 0;
        this.l1On = 0;
        this.l2On = 0;
        this.l3On = 0;
        this.r1On = 0;
        this.r2On = 0;
        this.r3On = 0;
        this.selectOn = 0;
        this.startOn = 0;
        this.homeOn = 0;
        this.dpadLeftOn = 0;
        this.dpadUpOn = 0;
        this.dpadRightOn = 0;
        this.dpadDownOn = 0;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "UnoJoyProcessingVisualizer"});
    }

    class Point {
        float x;
        float y;

        Point(float f, float f2) {
            this.x = f;
            this.y = f2;
        }
    }
}

