/***************************************************
  This is an example for the Adafruit VS1053 Codec Breakout

  Designed specifically to work with the Adafruit VS1053 Codec Breakout
  ----> https://www.adafruit.com/products/1381

  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.
  BSD license, all text above must be included in any redistribution
 ****************************************************/

#include <SoftwareSerial.h>

// See http://www.vlsi.fi/fileadmin/datasheets/vs1053.pdf Pg 31
#define VS1053_BANK_DEFAULT 0x00
#define VS1053_BANK_DRUMS1 0x78
#define VS1053_BANK_DRUMS2 0x7F
#define VS1053_BANK_MELODY 0x79

#define MIDI_NOTE_ON  0x90
#define MIDI_NOTE_OFF 0x80
#define MIDI_CHAN_MSG 0xB0
#define MIDI_CHAN_BANK 0x00
#define MIDI_CHAN_VOLUME 0x07
#define MIDI_CHAN_PROGRAM 0xC0

SoftwareSerial VS1053_MIDI(0, 2);

//int numValues = 50;
//byte mapping[30] = {0,1,2,3,4,5,6,7,8,9,   9,10,10,10,10,11,11,11,11,11,   11,11,12,12,12,12,12,12,12,12 };
byte mapping[110] = {0,1,2,3,4,5,6,7,8,8,  8,8,8,8,8,8,8,8,8,8,  9,9,9,9,9,9,9,9,9,9,   9,10,10,10,10,11,11,11,11,11,  11,11,11,11,11,11,11,11,11,11, 11,11,11,11,11,11,11,11,11,11, 11,11,11,11,11,11,11,11,11,11, 11,11,11,11,11,11,11,11,11,11, 11,11,11,11,11,11,11,11,11,11, 11,11,11,11,11,11,11,11,11,11,   11,11,12,12,12,12,12,12,12,12 };


// https://forum.arduino.cc/index.php?topic=242356.0

volatile boolean TurnDetected;
volatile boolean up;

const int PinCLK = 3;                 // Used for generating interrupts using CLK signal
const int PinDT = 4;                  // Used for reading DT signal
const int PinSW = 5;                  // Used for the push button switch

const int maxInstruments = 4;
static long virtualPosition = 1;  // without STATIC it does not count correctly!!!
bool rotSwitch = 1;
bool prevState = 1;

int currentInstrument = 80; // OCARINA

// Volume Knob
int aRead;
int volumeValue;
int aPrev = 0;
int aNoise = 2;

void setup() {

  pinMode(A14, INPUT);
  Serial.begin(9600);
  //Serial.println("VS1053 MIDI test");

  VS1053_MIDI.begin(31250); // MIDI uses a 'strange baud rate'


  midiSetChannelBank(0, VS1053_BANK_MELODY);
  midiSetInstrument(0, currentInstrument);
  volUpdate();


  // Initialize rotary button
  pinMode(PinCLK, INPUT);
  pinMode(PinDT, INPUT);
  pinMode(PinSW, INPUT);
  attachInterrupt (digitalPinToInterrupt(PinCLK), isr, FALLING);



}


void loop() {

  // PLAY MIDI
  for (uint8_t i = 60; i < 69; i++) {
    volUpdate();
    rotUpdate();
    midiNoteOn(0, i, 127);
    delay(100);
    midiNoteOff(0, i, 127);
  }

  delay(10);
}

void volUpdate() {
  aRead = analogRead(A14);
  
  //if (aRead > aPrev + aNoise || aRead < aPrev - aNoise) {

    volumeValue = map(aRead, 0, 1024, 0, 110-1); //10*mapping[map(aRead, 0, 1024, 0, 29)]; // map(aRead, 0, 1020, 0, 127);
    Serial.println(volumeValue);
    Serial.println(aRead);
    midiSetChannelVolume(0, 10*mapping[volumeValue]);
  //}
  
  //aPrev = aRead;

}




void rotUpdate() {

  // READ ROTARY AND PICK SOUND
  rotSwitch = digitalRead(PinSW);

  if (rotSwitch == 0 && prevState == 1) {  // check if pushbutton is pressed

    getInstrument(virtualPosition);
    midiSetInstrument(0, currentInstrument);
    prevState = 0;

  }
  else if (rotSwitch == 1) {
    prevState = 1;
  }

  if (TurnDetected)  {        // do this only if rotation was detected


    if (up && virtualPosition < maxInstruments)
      virtualPosition++;
    else if (up && virtualPosition == maxInstruments)
      virtualPosition = 1;
    else if (up == false && virtualPosition > 1)
      virtualPosition--;
    else if (up == false && virtualPosition == 1)
      virtualPosition = maxInstruments;

    TurnDetected = false;          // do NOT repeat IF loop until new rotation detected

  }


}



void isr ()  {                    // Interrupt service routine is executed when a HIGH to LOW transition is detected on CLK
  if (digitalRead(PinCLK))
    up = digitalRead(PinDT);
  else
    up = !digitalRead(PinDT);
  TurnDetected = true;
}


int getInstrument(int virtualPosition) {


  switch (virtualPosition) {
    case 1:
      currentInstrument = 80; // OCARINA

      break;
    case 2:
      currentInstrument = 14; // XYLAPHONE
      break;

    case 3:
      currentInstrument = 68; // SAX
      break;

    case 4:
      currentInstrument = 10; // Synth 1
      break;

    default:
      currentInstrument = 80; // OCARINA
      break;
  }

  return currentInstrument;

}



//////// MIDI FUNCTIONS //////////
void midiSetInstrument(uint8_t chan, uint8_t inst) {
  if (chan > 15) return;
  inst --; // page 32 has instruments starting with 1 not 0 :(
  if (inst > 127) return;

  VS1053_MIDI.write(MIDI_CHAN_PROGRAM | chan);
  VS1053_MIDI.write(inst);
}


void midiSetChannelVolume(uint8_t chan, uint8_t vol) {
  if (chan > 15) return;
  if (vol > 127) return;

  VS1053_MIDI.write(MIDI_CHAN_MSG | chan);
  VS1053_MIDI.write(MIDI_CHAN_VOLUME);
  VS1053_MIDI.write(vol);
}

void midiSetChannelBank(uint8_t chan, uint8_t bank) {
  if (chan > 15) return;
  if (bank > 127) return;

  VS1053_MIDI.write(MIDI_CHAN_MSG | chan);
  VS1053_MIDI.write((uint8_t)MIDI_CHAN_BANK);
  VS1053_MIDI.write(bank);
}

void midiNoteOn(uint8_t chan, uint8_t n, uint8_t vel) {
  if (chan > 15) return;
  if (n > 127) return;
  if (vel > 127) return;

  VS1053_MIDI.write(MIDI_NOTE_ON | chan);
  VS1053_MIDI.write(n);
  VS1053_MIDI.write(vel);
}

void midiNoteOff(uint8_t chan, uint8_t n, uint8_t vel) {
  if (chan > 15) return;
  if (n > 127) return;
  if (vel > 127) return;

  VS1053_MIDI.write(MIDI_NOTE_OFF | chan);
  VS1053_MIDI.write(n);
  VS1053_MIDI.write(vel);
}
