#include <math.h>

const uint8_t TEMPERATURE_SCRATCH_IDX = 2; 
// An array for 3 temperature values. The first two values are for the probes, 
// the last value is for the onboard BMA250 accelerometer which includes a thermal sensor.
float temperature[3];

// Encapsulation of a thermal probe. Each probe has it's own Stenhart-Hart coefficients
// adcPin and nominal divider resistor value.
class Thermometer {
  
  private:
    float       mA;
    float       mB;
    float       mC;
    int         mAdcPin;
    long        mNominalR;  // Measured value of the divider resistor
    
  public:
    
    Thermometer( float A, float B, float C, float nominalR, int adcPin):
       mA(A), mB(B), mC(C), mNominalR(nominalR), mAdcPin(adcPin) {
    }
  
  
    // Samples the current value presented to the analog input pin and converts it to temperature
    float temperature( void ) {
  
        float temperatureKelvin;    
        
        // Convert the measured ADC value to a resistance value and take the log for convenient formula plug 
        float logResistance = log( mNominalR *((1024.0 / analogRead(mAdcPin) ) - 1) ); 

        temperatureKelvin = 1 / (mA + (mB * logResistance) + (mC * pow(logResistance,3)));

        // Return in celcius by converting from Kelvin to C
        return temperatureKelvin - 273.15; 
    }  
};

  


Thermometer therm1(0.4471905625E-3, 2.683247185E-4, -0.8510031468E-7, 98300, 0);
Thermometer therm2(0.4471905625E-3, 2.683247185E-4, -0.8510031468E-7, 97500, 1);

void setup() {
  Bean.enableWakeOnConnect(true);
}

void loop() {

  bool connected = Bean.getConnectionState();

  if(connected) {
    Bean.setLed(0, 16, 0);
    temperature[0] = (float)Bean.getTemperature();
    temperature[1] = therm1.temperature(); 
    temperature[2] = therm2.temperature();

    // Write temperatures to scratch data area.  
    Bean.setScratchData(TEMPERATURE_SCRATCH_IDX, (uint8_t*)&temperature[0], 12);
    Bean.sleep(100);
    
  }
  else {
    
    // Set LED low power and put to sleep. 
    Bean.setLed(16, 0, 0);
    Bean.sleep(0xFFFFFFFF); 
  }
}

