//v2 - tweaked routines added some extra visuals
/* Touch screen GreenHouse (TS_Greenhouse) V2
so, DHT22, (2)HTC Soil sensors, RTC, (35) pixel NeoPixel Strip, Heat patch, 
Mega, 2.8" resistive touch TFT screen, (2) power switches (Mega and Motors) 
and a Hell of a lot of menu programming. 

Considering adding Light Sensor. No buttons or knobs or LED's. 

Menu cues include: green box active, blue box can be selected.  Changing text colors.  
Some buttons come with alerts/info.  
*/

//Graphics and Screen
#include <Adafruit_GFX.h>    
#include <Adafruit_TFTLCD.h> 
#include <TouchScreen.h>
#include <SPI.h>

#define LCD_CS A3 // Chip Select - These match the TFT panel
#define LCD_CD A2 // Command/Data 
#define LCD_WR A1 // LCD Write
#define LCD_RD A0 // LCD Read
#define LCD_RESET A4 //Reset

//Color Scheme Setup
#define	BLACK   0x0000
#define	BLUE    0x001F
#define	RED     0xF800
#define	GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

// Color definitions
#define ILI9341_BLACK       0x0000      /*   0,   0,   0 */
#define ILI9341_NAVY        0x000F      /*   0,   0, 128 */
#define ILI9341_DARKGREEN   0x03E0      /*   0, 128,   0 */
#define ILI9341_DARKCYAN    0x03EF      /*   0, 128, 128 */
#define ILI9341_MAROON      0x7800      /* 128,   0,   0 */
#define ILI9341_PURPLE      0x780F      /* 128,   0, 128 */
#define ILI9341_OLIVE       0x7BE0      /* 128, 128,   0 */
#define ILI9341_LIGHTGREY   0xC618      /* 192, 192, 192 */
#define ILI9341_DARKGREY    0x7BEF      /* 128, 128, 128 */
#define ILI9341_BLUE        0x001F      /*   0,   0, 255 */
#define ILI9341_GREEN       0x07E0      /*   0, 255,   0 */
#define ILI9341_CYAN        0x07FF      /*   0, 255, 255 */
#define ILI9341_RED         0xF800      /* 255,   0,   0 */
#define ILI9341_MAGENTA     0xF81F      /* 255,   0, 255 */
#define ILI9341_YELLOW      0xFFE0      /* 255, 255,   0 */
#define ILI9341_WHITE       0xFFFF      /* 255, 255, 255 */
#define ILI9341_ORANGE      0xFD20      /* 255, 165,   0 */
#define ILI9341_GREENYELLOW 0xAFE5      /* 173, 255,  47 */
#define ILI9341_PINK        0xF81F

int boxColor[]={ILI9341_BLUE,ILI9341_GREEN,ILI9341_WHITE,ILI9341_YELLOW}; 

#define YP A3  // must be an analog pin, use "An" notation!
#define XM A2  // must be an analog pin, use "An" notation!
#define YM 9   // can be a digital pin
#define XP 8   // can be a digital pin

#define TS_MINX 120    //calibrate the screen to see min and max X and Y.
#define TS_MAXX 920    //Note Orientation - especially if rotating
#define TS_MINY 115
#define TS_MAXY 910

Adafruit_TFTLCD tft(LCD_CS, LCD_CD, LCD_WR, LCD_RD, LCD_RESET);
TouchScreen ts = TouchScreen(XP, YP, XM, YM, 300);

#include "DHT.h"
//Greenhouse Sensor
#define DHTTYPE DHT22      //Using a DHT 22
#define DHTPIN 35          
DHT dht(DHTPIN, DHTTYPE);

//RTC Clock
#include <Wire.h>
#include "RTClib.h"
RTC_DS3231 rtc;
int signSpot;
String sign;
char daysOfTheWeek[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
char theMonth[13] [12] = {" ", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

//Menu Boxes
int boxX = 95;
int boxY = 35;
int titleY=36;
int boxSpaceX=5;

int row1=55;
int row2=115;
int row3=175;
int row4=235;
int row5=285;
int col1=15;
int col2=130;
int sBoxX=54;
int sBoxY=30;
int sBoxCol1=5;
int sBoxCol2=64;
int sBoxCol3=123;
int sBoxCol4=182;

int lightOnButton=0;
int lightOffButton=1;
int lightRelayPin=33;
int pixelCount=35;
int lightDataPin=31 ;
int wNowButton1=0;
int waterZone1Pin=45;
int wNowButton2=0;
int waterZone2Pin=41;
int heatOnButton=0;
int heatOffButton=1;
int heatPin=43;
long heatTimeStart=0; long heatTimeNow; int heatH; long heatS;
int heatM; int heatActive=0; long heatTimeCount;
int maxHeat=8;                             //default max time to run heat is 8 hours
int awayOnButton=0;
int awayOffButton=1;                       //default Away is turned off
int awayStart=16; int awayFinish=22;       //default time for away is 4pm to 10pm
int greenLight=0;
int whiteLight=1;                          //default to white light
int healthyLight=0;
int pinkLight=0;
int brightnessButton;
int brightness=75;                         //default light brightness to 75% (white light)
int brightUp,brightDown;                   //light menu bright adjust (+- 5sec)
int waterTime=10;                          //default water motors to 10 sec
int waterTimeUp,waterTimeDown, spot;       //water menu for adjust
long waterStartTime; long waterTimeNow; long sinceLastWater; int waterD, waterH;
String ghLightColor="White";               //default to white lights on setting
int dimButton, moodButton, sBrightButton, growButton;
int htcZone1=A14; int htcZone2=A15;        //Soil Humidity
int dht22=35;                              //Temp and air Humid
float d, h, m;         
int hM,t,tF;                   //DHT22 readings
int dryValue = 700;            //**Change soil values here**
int goodValue = 550;
int wetValue = 400;            //wet actually = anything below 550 
int zone1Value;
int zone2Value;
char* zoneValue[] = {"Good", "Dry", "Wet"}; int zone1Label; int zone2Label;
int putTime, theHour,theMinute, monthSpace, daySpace;    //deleted int sign
int hourAdjust=0; int minuteAdjust=0; //int sTimeCounter;
int sTimeCount=290; int mTimeCounter;  //main page/clock Menu respec...
int screen; int loopCount=0;
int ledR=47;int ledG=39;int ledB=27; int redBar;

//neoPixel Strip
#include <Adafruit_NeoPixel.h>
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(pixelCount, lightDataPin, NEO_GRB + NEO_KHZ800);
int neoPixel;                //will represent color settings - white (0), green (1), healthy (2), pink (3)
float level; int pc;

void setup() {
  Serial.begin(9600);
  #define MINPRESSURE 20

  tft.reset();
  int identifier;// = tft.readID();
  identifier=0x9341;
  tft.begin(identifier);
  tft.setRotation(2);
  pinMode(XM, OUTPUT);
  pinMode(YP, OUTPUT);
  pinMode(waterZone1Pin, OUTPUT);      //Motot1
  pinMode(waterZone2Pin, OUTPUT);      //Motor2
  pinMode(lightRelayPin, OUTPUT);      //Activate Relay for lights
  pinMode(lightDataPin, OUTPUT);       //Send the light data
  pinMode(heatPin, OUTPUT);            //Our accessories
  pinMode(htcZone1, INPUT);
  pinMode(htcZone2, INPUT);
  pinMode(dht22, INPUT);
  
  digitalWrite(waterZone1Pin, HIGH);    //Turn them off!!
  digitalWrite(waterZone2Pin, HIGH);
  digitalWrite(lightRelayPin, HIGH);
  digitalWrite(heatPin, HIGH);
  
  //Start up the accessories
  dht.begin();
  
  pixels.begin();
  pixels.show();

  rtc.begin();
  Wire.begin();
  DateTime now = rtc.now(); 
  
  tempHumidRead();               //Get an early read of the environment.
  timeCalc();
  screen=1;
  tft.fillScreen(BLACK);  
  mainMenu();
}

void loop(){
  pressCheckMain();
  Serial.print(sTimeCount); Serial.print(" Screen:");
  Serial.println(screen);Serial.println(loopCount);
}

void mainMenu(){
  screen=1;
  sTimeCount=295;
  tft.setTextColor(ILI9341_YELLOW);  // menu header 
  tft.setTextSize(3);  
  tft.setCursor(45,2);
  tft.print("Main Menu");
  drawResetTFT();
//  drawSliderPress();
  drawLightButtons();
  drawWaterButtons();
  drawHeaterButtons();
  drawAwayButtons();
  drawSettingsButtons();
  delay(50);
  pressCheckMain();
}

void drawResetTFT(){
  tft.fillCircle(20,15,10,ILI9341_RED);
  tft.setTextColor(ILI9341_WHITE); 
  tft.setTextSize(1);
  tft.setCursor(15,11);
  tft.print("ER");}

/*  //For future use, this button will go to a color selection menu
void drawSliderPress(){
  tft.fillCircle(225,15,10,ILI9341_RED);
  tft.setTextColor(ILI9341_WHITE); 
  tft.setTextSize(1);
  tft.setCursor(219,11);
  tft.print("SM");} 
*/ 
  
void drawLightButtons(){ 
//Row 1 - Side by Side Buttons
  tft.fillRoundRect(col1, row1, boxX, boxY, 8, boxColor[lightOnButton]);
  tft.fillRoundRect(col2, row1, boxX, boxY, 8, boxColor[lightOffButton]);  
//side by side button text
  tft.setTextColor(ILI9341_WHITE);  // Title
  tft.setTextSize(2);
  tft.setCursor(85,titleY);
  tft.print("Lights");
  tft.setCursor(50,65);  //Button Text
  tft.print("ON");  
  tft.setCursor(165,65);
  tft.print("OFF");
  if(lightOnButton==1){
    tft.setTextColor(ILI9341_BLACK);}
    else{
      tft.setTextColor(ILI9341_WHITE);}
  tft.setTextSize(1);
  tft.setCursor(32, 81);
  tft.print("Bright="); tft.print(brightness);tft.print("%");
  tft.setCursor(47, 56);
  tft.print(ghLightColor);
    
} 

void drawWaterButtons(){  
//Row 2 - Water Now Buttons
  tft.fillRoundRect(col1, row2, boxX, boxY, 8, boxColor[wNowButton1]);
  tft.fillRoundRect(col2, row2, boxX, boxY, 8, boxColor[wNowButton2]);
  //side by side button text
  tft.setTextColor(ILI9341_WHITE);  // Title
  tft.setTextSize(2);
  tft.setCursor(65,row2-18);
  tft.print("Water Now");
  tft.setCursor(28,row2+8);  //Button Text
  tft.print("Zone 1");  
  tft.setCursor(143,row2+8);
  tft.print("Zone 2");
  tft.setTextSize(1);   //Small labels
  tft.setCursor(52,row2+26);
  tft.print(zoneValue[zone1Label]);
  tft.setCursor(167,row2+26);
  tft.print(zoneValue[zone2Label]);    
} 

void drawHeaterButtons(){  
//Row 3 Heater - side by side
  tft.fillRoundRect(col1, row3, boxX, boxY, 8, boxColor[heatOnButton]);
  tft.fillRoundRect(col2, row3, boxX, boxY, 8, boxColor[heatOffButton]);
  //side by side button text
  tft.setTextColor(ILI9341_WHITE); // Title
  tft.setTextSize(2);
  tft.setCursor(85,row3-18);
  tft.print("Heater");
  tft.setCursor(50,row3+8); //Button Text
  tft.print("ON");  
  tft.setCursor(165,row3+8);
  tft.print("OFF"); 
  if(heatActive==1){
    heatCounter();
    showHeatCounter();}
  if(heatActive==0){
    tft.setTextSize(1);   //Small label
    tft.setCursor(38,row3+26);
    tft.setTextColor(ILI9341_WHITE);
    tft.print("Temp: "); tft.print(tF);} 
}

void drawAwayButtons(){  
//Row 4 Away Setting - side by side 
  tft.fillRoundRect(col1, row4, boxX, boxY, 8, boxColor[awayOnButton]); 
  tft.fillRoundRect(col2, row4, boxX, boxY, 8, boxColor[awayOffButton]);
  //side by side button text
  tft.setTextColor(ILI9341_WHITE);  // Title
  tft.setTextSize(2);
  tft.setCursor(48,row4-18);
  tft.print("Away Setting");
  tft.setCursor(50,row4+8);
  tft.print("ON");  
  tft.setCursor(165,row4+8);
  tft.print("OFF");  
  tft.setTextSize(1);   //Small label
  tft.setCursor(32,row4+26);
  if(awayOnButton==1){
    tft.setTextColor(ILI9341_BLACK);}
    else{
      tft.setTextColor(ILI9341_WHITE);}
  tft.print(awayStart-12); tft.print("pm");tft.print(" - ");tft.print(awayFinish-12);tft.print("pm");     
}

void drawSettingsButtons(){  
//Row 5 - submenus - 4 wide buttons
  tft.fillRoundRect(sBoxCol1, row5, sBoxX, sBoxY, 8, ILI9341_BLUE);
  tft.fillRoundRect(sBoxCol2, row5, sBoxX, sBoxY, 8, ILI9341_BLUE);
  tft.fillRoundRect(sBoxCol3, row5, sBoxX, sBoxY, 8, ILI9341_BLUE);
  tft.fillRoundRect(sBoxCol4, row5, sBoxX, sBoxY, 8, ILI9341_BLUE);
  tft.setTextColor(ILI9341_WHITE);
  tft.setTextSize(1);
  tft.setCursor(18, row5+8);
  tft.print("Light"); 
  tft.setCursor(77, row5+8);
  tft.print("Water");  
  tft.setCursor(136, row5+8);
  tft.print("Clock");
  tft.setCursor(195, row5+8);
  tft.print("Stats");  
}

void drawTime(){      //adds the small changing text to buttons (time, temp)
  if(sTimeCount>300 && screen==1){
    timeCalc();
    tft.fillRect(134, row5+17, 34, 9, ILI9341_BLUE);
    tft.setTextSize(1);
    tft.setTextColor(ILI9341_WHITE);
    tft.setCursor(136, row5+17);
    tft.print(theHour);tft.print(":");
    if(theMinute<10){
      tft.print("0");}
    tft.print(theMinute);
    sTimeCount=0;
    
    tempHumidRead();
    if(heatActive==1){
      tft.fillRect(34, row3+25, 55, 9, ILI9341_GREEN);
      heatCounter();
      showHeatCounter();}
    if(heatActive==0){
      tft.fillRect(34, row3+26, 55, 9, ILI9341_BLUE);
      tft.setTextSize(1);   //Small label
      tft.setCursor(38,row3+26);
      tft.setTextColor(ILI9341_WHITE);
      tft.print("Temp: "); tft.print(tF);}
  }
  sTimeCount=sTimeCount+1;
} 
