/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PVector;
import processing.serial.Serial;

public class SuperScope
extends PApplet {
    Serial port;
    String serialdata = "";
    String[] serialsplit = new String[]{"", ""};
    float lastedit = 0.0f;
    float editincrement = 1.0f;
    int keylast;
    int lastX;
    int lastY;
    int currentX;
    int currentY;
    int dmouseX;
    int dmouseY;
    int tolerance = 0;
    int particleslastgenerate = 0;
    int particleslastupdate = 0;
    boolean mousestatelast;
    boolean holding = false;
    boolean editing = false;
    boolean overduino = false;
    int arduinoalpha = 0;
    int graphpointcolor = this.color(0, 255, 150);
    float graphdomain = 1.0f;
    float graphrange = 1.0f;
    float desval = 0.0f;
    float phasortime = 0.0f;
    float phasortimecoefficient = -1.0f;
    float[] phasorthetas = new float[5];
    float[] phasormagnitudes = new float[5];
    int[] phasorcolors = new int[5];
    String[] phasorlabels = new String[5];
    String desunits = "NONE";
    String mode = "Low-Pass Filter (RC)";
    String modelast = "NONE";
    PImage Arduino;
    PFont font;
    PFont font2;
    Button modeswitch;
    Button addcap;
    Button addind;
    Button addres;
    Button addacs;
    Button decreasedomain;
    Button increasedomain;
    Button decreaserange;
    Button increaserange;
    Button increasephasortimecoefficient;
    Button decreasephasortimecoefficient;
    Button graphicaldisplay;
    Capacitor capacitor1;
    Capacitor capacitor2;
    Inductor inductor1;
    ACSource ac1;
    Resistor resistor1;
    ArrayList particles;
    ArrayList capacitors;
    ArrayList inductors;
    ArrayList resistors;
    ArrayList acsources;
    ArrayList schemwires;
    ArrayList schemouts;
    ArrayList schemgrounds;
    ArrayList schemcapacitors;
    ArrayList scheminductors;
    ArrayList schemresistors;
    ArrayList schemacsources;

    public void setup() {
        this.size(800, 500);
        this.port = new Serial((PApplet)this, "COM4", 9600);
        this.port.bufferUntil(10);
        this.Arduino = this.loadImage("arduino_icon.png");
        this.Arduino.resize(0, 50);
        this.font = this.loadFont("EurostileBold-20.vlw");
        this.font2 = this.loadFont("EurostileRegular-12.vlw");
        this.textFont(this.font);
        this.modeswitch = new Button(this.color(150, 100, 0), 200.0f, 400.0f, 100.0f, 30.0f, "NextCircuit");
        this.addcap = new Button(this.color(0, 0, 120), 100.0f, 15.0f, 30.0f, 30.0f, "C");
        this.addind = new Button(this.color(200, 100, 0), 200.0f, 15.0f, 30.0f, 30.0f, "L");
        this.addres = new Button(this.color(200, 0, 0), 300.0f, 15.0f, 30.0f, 30.0f, "R");
        this.addacs = new Button(this.color(0, 200, 100), 400.0f, 15.0f, 30.0f, 30.0f, "AC");
        this.decreasedomain = new Button(this.color(0, 255, 150), 550.0f, 340.0f, 90.0f, 30.0f, " -Domain");
        this.increasedomain = new Button(this.color(0, 255, 150), 640.0f, 340.0f, 90.0f, 30.0f, " +Domain");
        this.decreaserange = new Button(this.color(0, 255, 150), 550.0f, 370.0f, 90.0f, 30.0f, " -Range");
        this.increaserange = new Button(this.color(0, 255, 150), 640.0f, 370.0f, 90.0f, 30.0f, " +Range");
        this.increasephasortimecoefficient = new Button(this.color(0, 255, 150), 640.0f, 370.0f, 90.0f, 30.0f, " +Omega");
        this.decreasephasortimecoefficient = new Button(this.color(0, 255, 150), 550.0f, 370.0f, 90.0f, 30.0f, " -Omega");
        this.graphicaldisplay = new Button(this.color(0, 255, 125), 550.0f, 15.0f, 90.0f, 30.0f, "PLOT");
        this.capacitor1 = new Capacitor(this.color(0, 175, 255), 85.0f, 60.0f, 0.001f);
        this.capacitor2 = new Capacitor(this.color(0, 0, 255), 200.0f, 10.0f, 0.002f);
        this.inductor1 = new Inductor(this.color(255, 125, 0), 200.0f, 60.0f, 0.001f);
        this.ac1 = new ACSource(this.color(200, 200, 200), 400.0f, 60.0f, 1000.0f);
        this.resistor1 = new Resistor(this.color(255, 0, 0), 300.0f, 60.0f, 100.0f);
        this.particles = new ArrayList();
        this.capacitors = new ArrayList();
        this.inductors = new ArrayList();
        this.resistors = new ArrayList();
        this.acsources = new ArrayList();
        this.schemwires = new ArrayList();
        this.schemouts = new ArrayList();
        this.schemgrounds = new ArrayList();
        this.schemcapacitors = new ArrayList();
        this.scheminductors = new ArrayList();
        this.schemresistors = new ArrayList();
        this.schemacsources = new ArrayList();
        this.capacitors.add(this.capacitor1);
        this.inductors.add(this.inductor1);
        this.resistors.add(this.resistor1);
        this.acsources.add(this.ac1);
    }

    public void draw() {
        this.background(255);
        this.color(0);
        this.serialdata = "";
        this.strokeWeight(1.0f);
        this.keylast = 0;
        if (this.keyPressed) {
            this.keylast = this.key;
        }
        this.displayAll();
        this.updateAll();
        this.currentX = this.mouseX;
        this.currentY = this.mouseY;
        this.dmouseX = this.currentX - this.lastX;
        this.dmouseY = this.currentY - this.lastY;
        this.lastX = this.mouseX;
        this.lastY = this.mouseY;
        this.modeswitch.display();
        this.addcap.display();
        this.addind.display();
        this.addres.display();
        this.addacs.display();
        if (this.modeswitch.isPressed() && !this.mousestatelast) {
            if (this.mode == "Low-Pass Filter (RC)") {
                this.mode = "High-Pass Filter (RC)";
            } else if (this.mode == "High-Pass Filter (RC)") {
                this.mode = "Low-Pass Filter (RL)";
            } else if (this.mode == "Low-Pass Filter (RL)") {
                this.mode = "High-Pass Filter (RL)";
            } else if (this.mode == "High-Pass Filter (RL)") {
                this.mode = "Band-Reject (Notch): Driven LC Series";
            } else if (this.mode == "Band-Reject (Notch): Driven LC Series") {
                this.mode = "Band-Pass: Driven LC Parallel";
            } else if (this.mode == "Band-Pass: Driven LC Parallel") {
                this.mode = "Resonance (LC Tank)";
            } else if (this.mode == "Resonance (LC Tank)") {
                this.mode = "Dual Resonant Air-Core Step-Up Transformer (Tesla Coil)";
            } else if (this.mode == "Dual Resonant Air-Core Step-Up Transformer (Tesla Coil)") {
                this.mode = "Low-Pass Filter (RC)";
            }
        }
        if (this.addcap.isPressed() && !this.mousestatelast) {
            this.capacitors.add(new Capacitor(this.color(this.random(0.0f, 100.0f), this.random(0.0f, 100.0f), 55.0f + this.random(0.0f, 200.0f)), 85.0f, 60.0f, 0.001f));
        }
        if (this.addind.isPressed() && !this.mousestatelast) {
            this.inductors.add(new Inductor(this.color(200.0f + this.random(-50.0f, 50.0f), 100.0f + this.random(-50.0f, 50.0f), 0.0f), 200.0f, 60.0f, 0.001f));
        }
        if (this.addres.isPressed() && !this.mousestatelast) {
            this.resistors.add(new Resistor(this.color(100.0f + this.random(0.0f, 100.0f), this.random(0.0f, 50.0f), 0.0f), 300.0f, 60.0f, 0.001f));
        }
        if (this.addacs.isPressed() && !this.mousestatelast) {
            this.acsources.add(new ACSource(this.color(50.0f + this.random(0.0f, 200.0f), 50.0f + this.random(0.0f, 200.0f), 50.0f + this.random(0.0f, 200.0f)), 400.0f, 60.0f, 0.001f));
        }
        this.graphicaldisplay.display();
        if (this.graphicaldisplay.isPressed() && !this.mousestatelast) {
            if (this.graphicaldisplay.symbol == "PLOT") {
                this.graphicaldisplay.symbol = "VECTOR";
            } else if (this.graphicaldisplay.symbol == "VECTOR") {
                this.graphicaldisplay.symbol = "PHASOR";
            } else if (this.graphicaldisplay.symbol == "PHASOR") {
                this.graphicaldisplay.symbol = "PLOT";
            }
        }
        this.phasortime = this.graphicaldisplay.symbol == "PHASOR" ? (this.phasortime += 1.0E-9f) : 0.0f;
        if (this.graphicaldisplay.symbol == "PLOT") {
            this.decreasedomain.display();
            this.increasedomain.display();
            this.decreaserange.display();
            this.increaserange.display();
            if (this.decreasedomain.isPressed() && !this.mousestatelast) {
                this.graphdomain *= 0.1f;
            }
            if (this.increasedomain.isPressed() && !this.mousestatelast) {
                this.graphdomain *= 10.0f;
            }
            if (this.decreaserange.isPressed() && !this.mousestatelast) {
                this.graphrange *= 0.1f;
            }
            if (this.increaserange.isPressed() && !this.mousestatelast) {
                this.graphrange *= 10.0f;
            }
        }
        if (this.graphicaldisplay.symbol == "PHASOR") {
            this.decreasephasortimecoefficient.display();
            this.increasephasortimecoefficient.display();
            if (this.decreasephasortimecoefficient.isPressed() && !this.mousestatelast) {
                this.phasortimecoefficient *= 0.1f;
            }
            if (this.increasephasortimecoefficient.isPressed() && !this.mousestatelast) {
                this.phasortimecoefficient *= 10.0f;
            }
        }
        if (!this.holding) {
            this.desval = 0.0f;
            this.desunits = "NONE";
        }
        this.description();
        this.updateSchematic();
        if (this.overduino) {
            this.arduinoalpha += 10;
            if (this.arduinoalpha > 250) {
                this.arduinoalpha = 0;
            }
        } else {
            this.arduinoalpha = 255;
        }
        this.tint(255, this.arduinoalpha);
        this.image(this.Arduino, 0.0f, 200.0f);
        this.overduino = false;
        this.mouseStateUpdate(this.mousePressed);
    }

    public void serialEvent(Serial serial) {
        this.serialdata = serial.readStringUntil(10);
        this.serialsplit = SuperScope.split((String)this.serialdata, (char)'_');
    }

    public boolean overArduino(float f, float f2) {
        if (SuperScope.sqrt((float)(SuperScope.sq((float)(25.0f - f)) + SuperScope.sq((float)(225.0f - f2)))) < 30.0f) {
            this.overduino = true;
            return true;
        }
        return false;
    }

    public void requestImport(String string) {
        this.port.write("request" + string);
        this.port.write(10);
    }

    public void displayAll() {
        this.renderCapacitors();
        this.renderInductors();
        this.renderResistors();
        this.renderACSources();
        this.renderParticles();
        this.displayTrashCan();
    }

    public void updateAll() {
        this.updateCapacitors();
        this.updateInductors();
        this.updateResistors();
        this.updateACSources();
        this.updateParticles();
        this.updateSchemCap();
        this.updateSchemInd();
        this.updateSchemRes();
        this.updateSchemACS();
        this.updateSchemWire();
        this.updateSchemOUT();
    }

    public void updateCapacitors() {
        int n = this.capacitors.size() - 1;
        while (n >= 0) {
            Capacitor capacitor = (Capacitor)this.capacitors.get(n);
            if (capacitor.isfinished) {
                this.capacitors.remove(n);
            } else {
                capacitor.update();
                this.capacitors.add(capacitor);
                this.capacitors.remove(n);
            }
            --n;
        }
    }

    public void updateInductors() {
        int n = this.inductors.size() - 1;
        while (n >= 0) {
            Inductor inductor = (Inductor)this.inductors.get(n);
            if (inductor.isfinished) {
                this.inductors.remove(n);
            } else {
                inductor.update();
                this.inductors.add(inductor);
                this.inductors.remove(n);
            }
            --n;
        }
    }

    public void updateResistors() {
        int n = this.resistors.size() - 1;
        while (n >= 0) {
            Resistor resistor = (Resistor)this.resistors.get(n);
            if (resistor.isfinished) {
                this.resistors.remove(n);
            } else {
                resistor.update();
                this.resistors.add(resistor);
                this.resistors.remove(n);
            }
            --n;
        }
    }

    public void updateACSources() {
        int n = this.acsources.size() - 1;
        while (n >= 0) {
            ACSource aCSource = (ACSource)this.acsources.get(n);
            if (aCSource.isfinished) {
                this.acsources.remove(n);
            } else {
                aCSource.update();
                this.acsources.add(aCSource);
                this.acsources.remove(n);
            }
            --n;
        }
    }

    public void updateParticles() {
        if (this.particleslastupdate < this.millis() / 10 - 1) {
            int n = this.particles.size() - 1;
            while (n >= 0) {
                Sparks sparks = (Sparks)this.particles.get(n);
                if (sparks.isFinished()) {
                    this.particles.remove(n);
                } else {
                    sparks.update();
                    this.particles.add(sparks);
                    this.particles.remove(n);
                }
                --n;
            }
            this.particleslastupdate = this.millis() / 100;
        }
    }

    public void renderCapacitors() {
        int n = this.capacitors.size() - 1;
        while (n >= 0) {
            Capacitor capacitor = (Capacitor)this.capacitors.get(n);
            capacitor.display();
            --n;
        }
    }

    public void renderInductors() {
        int n = this.inductors.size() - 1;
        while (n >= 0) {
            Inductor inductor = (Inductor)this.inductors.get(n);
            inductor.display();
            --n;
        }
    }

    public void renderResistors() {
        int n = this.resistors.size() - 1;
        while (n >= 0) {
            Resistor resistor = (Resistor)this.resistors.get(n);
            resistor.display();
            --n;
        }
    }

    public void renderACSources() {
        int n = this.acsources.size() - 1;
        while (n >= 0) {
            ACSource aCSource = (ACSource)this.acsources.get(n);
            aCSource.display();
            --n;
        }
    }

    public void renderParticles() {
        int n = this.particles.size() - 1;
        while (n >= 0) {
            Sparks sparks = (Sparks)this.particles.get(n);
            sparks.render();
            --n;
        }
    }

    public void generateSparks(float f, float f2, float f3, float f4, float f5, int n) {
        if ((float)this.particleslastgenerate < (float)(this.millis() / 100) - 0.25f) {
            this.particles.add(new Sparks(f, f2, f3, f4, f5, n));
            this.particleslastgenerate = this.millis() / 100;
        }
    }

    public void mouseStateUpdate(boolean bl) {
        this.mousestatelast = bl;
    }

    public void description() {
        if (this.desunits != "NONE") {
            this.textFont(this.font);
            this.noFill();
            this.rectMode(0);
            this.rect(100.0f, 450.0f, 400.0f, 50.0f);
            this.fill(this.color(0, 0, 0));
            this.text(String.valueOf(SuperScope.str((float)this.desval)) + ' ' + this.desunits, 100.0f, 475.0f);
        }
    }

    public void graph(String string, String string2, float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.graphicaldisplay.symbol == "PLOT") {
            this.stroke(this.color(0, 255, 150));
            this.fill(this.color(0, 0, 0));
            this.rectMode(0);
            this.rect(500.0f, 100.0f, 200.0f, 200.0f);
            this.stroke(0.0f, 255.0f, 255.0f);
            this.fill(this.graphpointcolor);
            this.ellipse(SuperScope.constrain((float)(SuperScope.map((float)f5, (float)f, (float)(f2 * this.graphdomain), (float)0.0f, (float)200.0f) + 500.0f), (float)500.0f, (float)700.0f), SuperScope.constrain((float)(SuperScope.map((float)f6, (float)f3, (float)(f4 * this.graphrange), (float)0.0f, (float)-200.0f) + 300.0f), (float)100.0f, (float)300.0f), 10.0f, 10.0f);
            this.fill(this.color(0, 255, 150));
            this.text(String.valueOf(SuperScope.str((float)f6)) + "V", 500.0f, 150.0f);
            this.text(String.valueOf(SuperScope.str((float)f5)) + "Hz", 550.0f, 300.0f);
            this.text(String.valueOf(string) + "(0Hz - " + SuperScope.str((float)(10.0f * this.graphdomain)) + "Hz)", 550.0f, 320.0f);
            this.text(String.valueOf(string2) + "(0V - " + SuperScope.str((float)(5.0f * this.graphrange)) + "Vss)", 450.0f, 90.0f);
        }
    }

    public void vector(String string, String string2, PVector pVector) {
        if (this.graphicaldisplay.symbol == "VECTOR") {
            this.stroke(this.color(0, 0, 0));
            this.strokeWeight(4.0f);
            this.line(500.0f, 200.0f, 500.0f, 200.0f - SuperScope.map((float)pVector.y, (float)0.0f, (float)1000.0f, (float)0.0f, (float)100.0f));
            this.line(500.0f, 200.0f, 500.0f + SuperScope.map((float)pVector.x, (float)0.0f, (float)1000.0f, (float)0.0f, (float)100.0f), 200.0f);
            this.strokeWeight(2.0f);
            this.line(500.0f, 200.0f, 500.0f + SuperScope.map((float)pVector.x, (float)0.0f, (float)1000.0f, (float)0.0f, (float)100.0f), 200.0f - SuperScope.map((float)pVector.y, (float)0.0f, (float)1000.0f, (float)0.0f, (float)100.0f));
            this.text("(X)" + string + " " + SuperScope.str((float)SuperScope.abs((float)pVector.x)), 525.0f, 90.0f);
            this.text("(Y)" + string2 + " " + SuperScope.str((float)SuperScope.abs((float)pVector.y)), 525.0f, 100.0f);
            this.text("PhaseShift:", 525.0f, 125.0f);
            if (this.phaseShift(pVector.x, pVector.y) > 0.0f) {
                this.text("Voltage IN PHASE", 525.0f, 135.0f);
                this.text("Current LAG " + SuperScope.str((float)(SuperScope.degrees((float)this.phaseShift(pVector.x, pVector.y)) * -1.0f)) + "degrees", 525.0f, 145.0f);
            } else if (this.phaseShift(pVector.x, pVector.y) < 0.0f) {
                this.text("Voltage LAG " + SuperScope.str((float)(SuperScope.degrees((float)this.phaseShift(pVector.x, pVector.y)) * -1.0f)) + "degrees", 525.0f, 135.0f);
                this.text("Current IN PHASE", 525.0f, 145.0f);
            } else {
                this.text("Voltage IN PHASE", 525.0f, 135.0f);
                this.text("Current IN PHASE", 525.0f, 145.0f);
            }
            this.strokeWeight(1.0f);
        }
    }

    public void phasor(int n, float f, float[] fArray, float[] fArray2, int[] nArray, String[] stringArray) {
        this.strokeWeight(4.0f);
        int n2 = 0;
        while (n2 < n) {
            this.stroke(nArray[n2]);
            this.fill(nArray[n2]);
            this.line(500.0f, 200.0f, 500.0f + SuperScope.cos((float)(this.phasortimecoefficient * this.phasortime * f + fArray[n2])) * fArray2[n2] * 20.0f, 200.0f + SuperScope.sin((float)(this.phasortimecoefficient * this.phasortime * f + fArray[n2])) * fArray2[n2] * 20.0f);
            this.text(stringArray[n2], 500.0f, 400 + 10 * n2);
            this.text("[" + fArray2[n2] + "]" + "[" + "e^(j" + fArray[n2] + ")" + "]" + "e^(j" + f + this.phasortimecoefficient * this.phasortime + ")" + "]", 500.0f, 300 + 10 * n2);
            ++n2;
        }
    }

    public void updateSchematic() {
        Object object;
        Object object2;
        this.updateSchemGround();
        this.updateSchemOUT();
        this.updateSchemWire();
        this.updateSchemCap();
        this.updateSchemInd();
        this.updateSchemRes();
        this.updateSchemACS();
        if (this.mode != this.modelast) {
            Object object3;
            int n = this.schemwires.size() - 1;
            while (n >= 0) {
                this.schemwires.remove(n);
                --n;
            }
            n = this.schemouts.size() - 1;
            while (n >= 0) {
                this.schemouts.remove(n);
                --n;
            }
            n = this.schemgrounds.size() - 1;
            while (n >= 0) {
                this.schemgrounds.remove(n);
                --n;
            }
            n = this.schemcapacitors.size() - 1;
            while (n >= 0) {
                this.schemcapacitors.remove(n);
                --n;
            }
            n = this.scheminductors.size() - 1;
            while (n >= 0) {
                this.scheminductors.remove(n);
                --n;
            }
            n = this.schemresistors.size() - 1;
            while (n >= 0) {
                this.schemresistors.remove(n);
                --n;
            }
            n = this.schemacsources.size() - 1;
            while (n >= 0) {
                this.schemacsources.remove(n);
                --n;
            }
            if (this.mode == "Low-Pass Filter (RC)") {
                this.graphdomain = 1.0f;
                this.graphrange = 1.0f;
                SchemCap schemCap = new SchemCap(200.0f, 300.0f, 1);
                object2 = new SchemRes(300.0f, schemCap.leadly, 1);
                object3 = new SchemACS(250.0f, 200.0f, 1);
                this.schemcapacitors.add(schemCap);
                this.schemresistors.add(object2);
                this.schemacsources.add(object3);
                this.schemwires.add(new SchemWire(schemCap.leadrx, schemCap.leadry, ((SchemRes)object2).leadlx, ((SchemRes)object2).leadly, 1));
                this.schemwires.add(new SchemWire(schemCap.leadlx - 10.0f, schemCap.leadly, schemCap.leadlx - 10.0f, ((SchemACS)object3).leadly, 2));
                this.schemwires.add(new SchemWire(((SchemRes)object2).leadrx + 10.0f, ((SchemRes)object2).leadry, ((SchemRes)object2).leadrx + 10.0f, ((SchemACS)object3).leadry, 3));
                this.schemwires.add(new SchemWire(schemCap.leadlx - 10.0f, schemCap.leadly, schemCap.leadlx, schemCap.leadly, 4));
                this.schemwires.add(new SchemWire(((SchemRes)object2).leadrx + 10.0f, ((SchemRes)object2).leadry, ((SchemRes)object2).leadrx, ((SchemRes)object2).leadry, 5));
                this.schemwires.add(new SchemWire(schemCap.leadlx - 10.0f, ((SchemACS)object3).leadly, ((SchemACS)object3).leadlx, ((SchemACS)object3).leadly, 6));
                this.schemwires.add(new SchemWire(((SchemRes)object2).leadrx + 10.0f, ((SchemACS)object3).leadry, ((SchemACS)object3).leadrx, ((SchemACS)object3).leadry, 7));
                this.schemouts.add(new SchemOUT((schemCap.leadrx + ((SchemRes)object2).leadlx) / 2.0f, schemCap.leadry, (schemCap.leadrx + ((SchemRes)object2).leadlx) / 2.0f, schemCap.leadry + 50.0f, 1));
                this.schemgrounds.add(new SchemGround(schemCap.leadlx - 10.0f, schemCap.leadly, schemCap.leadlx - 10.0f, schemCap.leadly + 50.0f, 1));
            } else if (this.mode != "High-Pass Filter (RC)" && this.mode != "Low-Pass Filter (RL)" && this.mode != "High-Pass Filter (RL)" && this.mode != "Band-Reject (Notch): Driven LC Series") {
                if (this.mode == "Band-Pass: Driven LC Parallel") {
                    this.graphdomain = 1.0f;
                    this.graphrange = 1.0f;
                    SchemCap schemCap = new SchemCap(200.0f, 300.0f, 1);
                    object2 = new SchemInd(210.0f, 250.0f, 1);
                    object3 = new SchemRes(300.0f, schemCap.leadly, 1);
                    object = new SchemACS(250.0f, 200.0f, 1);
                    this.schemcapacitors.add(schemCap);
                    this.scheminductors.add(object2);
                    this.schemresistors.add(object3);
                    this.schemacsources.add(object);
                    this.schemwires.add(new SchemWire(schemCap.leadrx, schemCap.leadry, ((SchemRes)object3).leadlx, ((SchemRes)object3).leadly, 1));
                    this.schemwires.add(new SchemWire(schemCap.leadlx - 10.0f, schemCap.leadly, schemCap.leadlx - 10.0f, ((SchemACS)object).leadly, 2));
                    this.schemwires.add(new SchemWire(((SchemRes)object3).leadrx + 10.0f, ((SchemRes)object3).leadry, ((SchemRes)object3).leadrx + 10.0f, ((SchemACS)object).leadry, 3));
                    this.schemwires.add(new SchemWire(schemCap.leadlx - 10.0f, schemCap.leadly, schemCap.leadlx, schemCap.leadly, 4));
                    this.schemwires.add(new SchemWire(((SchemRes)object3).leadrx + 10.0f, ((SchemRes)object3).leadry, ((SchemRes)object3).leadrx, ((SchemRes)object3).leadry, 5));
                    this.schemwires.add(new SchemWire(schemCap.leadlx - 10.0f, ((SchemACS)object).leadly, ((SchemACS)object).leadlx, ((SchemACS)object).leadly, 6));
                    this.schemwires.add(new SchemWire(((SchemRes)object3).leadrx + 10.0f, ((SchemACS)object).leadry, ((SchemACS)object).leadrx, ((SchemACS)object).leadry, 7));
                    this.schemwires.add(new SchemWire(((SchemInd)object2).leadlx - 15.0f, ((SchemInd)object2).leadly, ((SchemInd)object2).leadlx, ((SchemInd)object2).leadly, 8));
                    this.schemwires.add(new SchemWire((schemCap.leadrx + ((SchemRes)object3).leadlx) / 2.0f, schemCap.leadry, (schemCap.leadrx + ((SchemRes)object3).leadlx) / 2.0f, ((SchemInd)object2).leadry, 9));
                    this.schemwires.add(new SchemWire(((SchemInd)object2).leadrx, ((SchemInd)object2).leadry, (schemCap.leadrx + ((SchemRes)object3).leadlx) / 2.0f, ((SchemInd)object2).leadry, 10));
                    this.schemouts.add(new SchemOUT((schemCap.leadrx + ((SchemRes)object3).leadlx) / 2.0f, schemCap.leadry, (schemCap.leadrx + ((SchemRes)object3).leadlx) / 2.0f, schemCap.leadry + 50.0f, 1));
                    this.schemgrounds.add(new SchemGround(schemCap.leadlx - 10.0f, schemCap.leadly, schemCap.leadlx - 10.0f, schemCap.leadly + 50.0f, 1));
                } else if (this.mode != "Resonance (LC Tank)") {
                    // empty if block
                }
            }
            this.modelast = this.mode;
        }
        if (this.mode == "Low-Pass Filter (RC)") {
            int n = this.schemcapacitors.size() - 1;
            while (n >= 0) {
                object2 = (SchemCap)this.schemcapacitors.get(n);
                if (((SchemCap)object2).id == 1) {
                    int n2 = this.schemresistors.size() - 1;
                    while (n2 >= 0) {
                        object = (SchemRes)this.schemresistors.get(n);
                        if (((SchemRes)object).id == 1) {
                            int n3 = this.schemacsources.size() - 1;
                            while (n3 >= 0) {
                                SchemACS schemACS = (SchemACS)this.schemacsources.get(n);
                                if (schemACS.id == 1) {
                                    if (this.graphicaldisplay.symbol == "PLOT") {
                                        this.graphpointcolor = !this.bandWidth(5.0f, this.voltagePoint(5.0f, this.impedance(((SchemRes)object).value, 0.0f, this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)), this.capacitiveReactance(((SchemCap)object2).value, schemACS.value))) ? this.color(255, 0, 0) : this.color(0, 255, 150);
                                        this.graph("Frequency", "OUT1 Amplitude", 0.0f, 10.0f, 0.0f, 5.0f, schemACS.value, this.voltagePoint(5.0f, this.impedance(((SchemRes)object).value, 0.0f, this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)), this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)));
                                    } else if (this.graphicaldisplay.symbol == "VECTOR") {
                                        this.vector("Resistance", "CapacitiveReactance", new PVector(((SchemRes)object).value, this.capacitiveReactance(((SchemCap)object2).value, schemACS.value) * -1.0f));
                                    } else if (this.graphicaldisplay.symbol == "PHASOR") {
                                        this.phasorthetas[0] = 0.0f;
                                        this.phasorthetas[1] = this.phaseShift(((SchemRes)object).value, this.capacitiveReactance(((SchemCap)object2).value, schemACS.value));
                                        this.phasormagnitudes[0] = 5.0f;
                                        this.phasormagnitudes[1] = this.voltagePoint(5.0f, this.impedance(((SchemRes)object).value, 0.0f, this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)), this.capacitiveReactance(((SchemCap)object2).value, schemACS.value));
                                        this.phasorcolors[0] = this.color(0, 255, 100);
                                        this.phasorcolors[1] = this.color(255, 0, 255);
                                        this.phasorlabels[0] = "SignalVoltage";
                                        this.phasorlabels[1] = "OUT1Voltage";
                                        this.phasor(2, schemACS.value * ((float)Math.PI * 2), this.phasorthetas, this.phasormagnitudes, this.phasorcolors, this.phasorlabels);
                                    }
                                }
                                --n3;
                            }
                        }
                        --n2;
                    }
                }
                --n;
            }
        } else if (this.mode != "High-Pass Filter (RC)" && this.mode != "Low-Pass Filter (RL)" && this.mode != "High-Pass Filter (RL)" && this.mode != "Band-Reject (Notch): Driven LC Series") {
            if (this.mode == "Band-Pass: Driven LC Parallel") {
                int n = this.schemcapacitors.size() - 1;
                while (n >= 0) {
                    object2 = (SchemCap)this.schemcapacitors.get(n);
                    if (((SchemCap)object2).id == 1) {
                        int n4 = this.scheminductors.size() - 1;
                        while (n4 >= 0) {
                            object = (SchemInd)this.scheminductors.get(n4);
                            if (((SchemInd)object).id == 1) {
                                int n5 = this.schemresistors.size() - 1;
                                while (n5 >= 0) {
                                    SchemRes schemRes = (SchemRes)this.schemresistors.get(n5);
                                    if (schemRes.id == 1) {
                                        int n6 = this.schemacsources.size() - 1;
                                        while (n6 >= 0) {
                                            SchemACS schemACS = (SchemACS)this.schemacsources.get(n6);
                                            if (schemACS.id == 1) {
                                                if (this.graphicaldisplay.symbol == "PLOT") {
                                                    this.graphpointcolor = !this.bandWidth(5.0f, this.voltagePoint(5.0f, this.impedance(schemRes.value, 1.0f / (1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)), 0.0f), SuperScope.abs((float)(1.0f / (1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)))))) ? this.color(255, 0, 0) : this.color(0, 255, 150);
                                                    if (schemACS.value > this.resonantFrequency(((SchemCap)object2).value, ((SchemInd)object).value) - 0.001f && schemACS.value < this.resonantFrequency(((SchemCap)object2).value, ((SchemInd)object).value) + 0.001f) {
                                                        this.graphpointcolor = this.color(255, 255, 255);
                                                    }
                                                    this.graph("Frequency", "OUT1 Amplitude", 0.0f, 10.0f, 0.0f, 5.0f, schemACS.value, this.voltagePoint(5.0f, this.impedance(schemRes.value, 1.0f / (1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)), 0.0f), SuperScope.abs((float)(1.0f / (1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value))))));
                                                } else if (this.graphicaldisplay.symbol == "VECTOR") {
                                                    this.vector("Resistance", "Reactance", new PVector(schemRes.value, 1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)));
                                                } else if (this.graphicaldisplay.symbol == "PHASOR") {
                                                    this.phasorthetas[0] = 0.0f;
                                                    this.phasorthetas[1] = this.phaseShift(schemRes.value, 1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value));
                                                    this.phasormagnitudes[0] = 5.0f;
                                                    this.phasormagnitudes[1] = this.voltagePoint(5.0f, this.impedance(schemRes.value, 1.0f / (1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)), 0.0f), SuperScope.abs((float)(1.0f / (1.0f / this.inductiveReactance(((SchemInd)object).value, schemACS.value) - 1.0f / this.capacitiveReactance(((SchemCap)object2).value, schemACS.value)))));
                                                    this.phasorcolors[0] = this.color(0, 255, 100);
                                                    this.phasorcolors[1] = this.color(255, 0, 255);
                                                    this.phasorlabels[0] = "SignalVoltage";
                                                    this.phasorlabels[1] = "OUT1Voltage";
                                                    this.phasor(2, schemACS.value * ((float)Math.PI * 2), this.phasorthetas, this.phasormagnitudes, this.phasorcolors, this.phasorlabels);
                                                }
                                            }
                                            --n6;
                                        }
                                    }
                                    --n5;
                                }
                            }
                            --n4;
                        }
                    }
                    --n;
                }
            } else if (this.mode != "Resonance (LC Tank)") {
                // empty if block
            }
        }
    }

    public void displayTrashCan() {
        this.stroke(0);
        this.fill(this.color(100, 100, 100));
        this.rectMode(0);
        this.rect(50.0f, 450.0f, 20.0f, 30.0f);
        this.rect(48.0f, 445.0f, 24.0f, 5.0f);
        this.line(55.0f, 450.0f, 55.0f, 480.0f);
        this.line(60.0f, 450.0f, 60.0f, 480.0f);
        this.line(65.0f, 450.0f, 65.0f, 480.0f);
    }

    public void updateSchemCap() {
        int n = this.schemcapacitors.size() - 1;
        while (n >= 0) {
            SchemCap schemCap = (SchemCap)this.schemcapacitors.get(n);
            schemCap.update();
            this.schemcapacitors.add(schemCap);
            this.schemcapacitors.remove(n);
            --n;
        }
    }

    public void updateSchemInd() {
        int n = this.scheminductors.size() - 1;
        while (n >= 0) {
            SchemInd schemInd = (SchemInd)this.scheminductors.get(n);
            schemInd.update();
            this.scheminductors.add(schemInd);
            this.scheminductors.remove(n);
            --n;
        }
    }

    public void updateSchemRes() {
        int n = this.schemresistors.size() - 1;
        while (n >= 0) {
            SchemRes schemRes = (SchemRes)this.schemresistors.get(n);
            schemRes.update();
            this.schemresistors.add(schemRes);
            this.schemresistors.remove(n);
            --n;
        }
    }

    public void updateSchemACS() {
        int n = this.schemacsources.size() - 1;
        while (n >= 0) {
            SchemACS schemACS = (SchemACS)this.schemacsources.get(n);
            schemACS.update();
            this.schemacsources.add(schemACS);
            this.schemacsources.remove(n);
            --n;
        }
    }

    public void updateSchemWire() {
        int n = this.schemwires.size() - 1;
        while (n >= 0) {
            SchemWire schemWire = (SchemWire)this.schemwires.get(n);
            schemWire.display();
            --n;
        }
    }

    public void updateSchemOUT() {
        int n = this.schemouts.size() - 1;
        while (n >= 0) {
            SchemOUT schemOUT = (SchemOUT)this.schemouts.get(n);
            schemOUT.display();
            --n;
        }
    }

    public void updateSchemGround() {
        int n = this.schemgrounds.size() - 1;
        while (n >= 0) {
            SchemGround schemGround = (SchemGround)this.schemgrounds.get(n);
            schemGround.display();
            --n;
        }
    }

    public float impedance(float f, float f2, float f3) {
        return SuperScope.sqrt((float)(SuperScope.sq((float)f) + SuperScope.sq((float)(f2 - f3))));
    }

    public float inductiveReactance(float f, float f2) {
        return (float)Math.PI * 2 * f2 * f;
    }

    public float capacitiveReactance(float f, float f2) {
        return 1.0f / ((float)Math.PI * 2 * f2 * f);
    }

    public float resonantFrequency(float f, float f2) {
        return 1.0f / ((float)Math.PI * 2 * SuperScope.sqrt((float)(f * f2)));
    }

    public float phaseShift(float f, float f2) {
        return SuperScope.atan((float)(f2 / f));
    }

    public float voltagePoint(float f, float f2, float f3) {
        return f * (f3 / f2);
    }

    public boolean bandWidth(float f, float f2) {
        return !(f2 < f / 2.0f);
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "SuperScope"});
    }

    class ACSource
    extends Element {
        ACSource(int n, float f, float f2, float f3) {
            this.units = "Hertz";
            this.value = f3;
            this.c = n;
            this.xpos = f;
            this.ypos = f2;
            this.centerx = this.xpos;
            this.centery = this.ypos;
        }

        public void display() {
            SuperScope.this.stroke(0);
            SuperScope.this.fill(this.c);
            SuperScope.this.ellipse(this.centerx, this.centery, 30.0f, 30.0f);
            int n = 0;
            while (n < 20) {
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery))), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) - 1.0f)), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) + 1.0f)), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) - 2.0f)), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) + 2.0f)), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) - 3.0f)), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) + 3.0f)), SuperScope.this.color(0, 255, 125));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) - 4.0f)), SuperScope.this.color(0, 0, 0));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) + 4.0f)), SuperScope.this.color(0, 0, 0));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) - 5.0f)), SuperScope.this.color(0, 0, 0));
                SuperScope.this.set(-10 + n + PApplet.parseInt((float)this.centerx), PApplet.parseInt((float)(SuperScope.sin((float)((float)n * ((float)Math.PI * 2) / 20.0f)) * -10.0f + (float)PApplet.parseInt((float)this.centery) + 5.0f)), SuperScope.this.color(0, 0, 0));
                ++n;
            }
        }
    }

    class Button {
        boolean pressed = false;
        int lastclicktime = 0;
        float xpos;
        float ypos;
        float widthv;
        float heightv;
        float leftbound;
        float rightbound;
        float upperbound;
        float lowerbound;
        int colorv;
        String symbol;

        Button(int n, float f, float f2, float f3, float f4, String string) {
            this.xpos = f;
            this.ypos = f2;
            this.widthv = f3;
            this.heightv = f4;
            this.leftbound = this.xpos - this.widthv / 2.0f;
            this.rightbound = this.xpos + this.widthv / 2.0f;
            this.upperbound = this.ypos - this.heightv / 2.0f;
            this.lowerbound = this.ypos + this.heightv / 2.0f;
            this.colorv = n;
            this.symbol = string;
        }

        public void display() {
            SuperScope.this.stroke(0);
            SuperScope.this.fill(this.colorv);
            SuperScope.this.rectMode(3);
            SuperScope.this.rect(this.xpos, this.ypos, this.widthv, this.heightv);
            SuperScope.this.fill(255);
            SuperScope.this.textFont(SuperScope.this.font);
            SuperScope.this.text(this.symbol, this.leftbound, this.ypos);
        }

        public boolean isMouseOver() {
            return (float)SuperScope.this.mouseX > this.leftbound && (float)SuperScope.this.mouseX < this.rightbound && (float)SuperScope.this.mouseY > this.upperbound && (float)SuperScope.this.mouseY < this.lowerbound;
        }

        public boolean isPressed() {
            if (SuperScope.this.mousePressed && this.isMouseOver()) {
                if (this.pressed) {
                    return true;
                }
                if (SuperScope.this.mousePressed && !SuperScope.this.mousestatelast) {
                    this.lastclicktime = SuperScope.this.millis() / 100;
                    this.pressed = true;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    class Capacitor
    extends Element {
        Capacitor(int n, float f, float f2, float f3) {
            this.units = "Farads";
            this.value = f3;
            this.c = n;
            this.xpos = f;
            this.ypos = f2;
            this.centerx = this.xpos + 10.0f;
            this.centery = this.ypos;
        }

        public void display() {
            SuperScope.this.stroke(0);
            SuperScope.this.fill(this.c);
            SuperScope.this.rectMode(3);
            SuperScope.this.rect(this.centerx - 5.0f, this.centery, 5.0f, 30.0f);
            SuperScope.this.rect(this.centerx - 5.0f + 15.0f, this.centery, 5.0f, 30.0f);
        }
    }

    class Element {
        String units;
        float value;
        int c;
        float xpos;
        float ypos;
        float centerx;
        float centery;
        int area = 50;
        boolean held;
        boolean edit = false;
        boolean applied;
        boolean isfinished = false;

        Element() {
        }

        public void update() {
            if (this.centerx > 50.0f && this.centerx < 70.0f && this.centery > 450.0f && this.centery < 480.0f) {
                this.isfinished = true;
                this.held = false;
                SuperScope.this.holding = false;
            }
            if (this.held && !SuperScope.this.mousePressed) {
                SuperScope.this.holding = false;
            }
            if (this.edit && SuperScope.this.keylast == 32) {
                SuperScope.this.editing = false;
            }
            if (this.held && SuperScope.this.mousePressed) {
                this.centerx = SuperScope.this.mouseX;
                this.centery = SuperScope.this.mouseY;
                if (!SuperScope.this.overArduino(this.centerx, this.centery)) {
                    SuperScope.this.generateSparks(0.0f, 0.7f, 0.04f, 0.04f, 3.0f, SuperScope.this.color(0, 245, 245));
                } else {
                    SuperScope.this.generateSparks(SuperScope.this.random(0.0f, 1.0f), SuperScope.this.random(-1.0f, 1.0f), 0.1f, 0.1f, 3.0f, SuperScope.this.color(0, 245, 245));
                    this.value = this.units == "Farads" || this.units == "Henrys" ? PApplet.parseFloat((String)SuperScope.this.serialsplit[0]) / 1.0E9f : PApplet.parseFloat((String)SuperScope.this.serialsplit[0]);
                    SuperScope.this.requestImport(this.units);
                }
            } else {
                this.held = false;
            }
            if (this.edit) {
                SuperScope.this.desunits = this.units;
                SuperScope.this.desval = this.value;
                SuperScope.this.description();
                SuperScope.this.stroke(SuperScope.this.color(0.0f, 255.0f, 55.0f + (SuperScope.sin((float)(PApplet.parseFloat((int)SuperScope.this.millis()) / 1000.0f)) + 1.0f) * 0.5f * 200.0f));
                SuperScope.this.noFill();
                SuperScope.this.ellipse(this.centerx, this.centery, this.area, this.area);
                SuperScope.this.ellipse(this.centerx, this.centery, (float)this.area + 3.0f * SuperScope.sin((float)(SuperScope.this.millis() / 100)), (float)this.area + 3.0f * SuperScope.cos((float)(SuperScope.this.millis() / 100)));
            }
            if (this.edit && SuperScope.this.lastedit < (float)(SuperScope.this.millis() / 10 - 10) && SuperScope.this.keyPressed) {
                if (SuperScope.this.keylast == 100) {
                    this.value += SuperScope.this.editincrement;
                }
                if (SuperScope.this.keylast == 97) {
                    this.value -= SuperScope.this.editincrement;
                }
                if (SuperScope.this.lastedit < (float)(SuperScope.this.millis() / 10 - 20)) {
                    if (SuperScope.this.keylast == 119) {
                        SuperScope.this.editincrement *= 10.0f;
                    }
                    if (SuperScope.this.keylast == 115) {
                        SuperScope.this.editincrement /= 10.0f;
                    }
                }
                SuperScope.this.lastedit = SuperScope.this.millis() / 10;
            }
            if ((float)SuperScope.this.mouseX > this.centerx - 15.0f - (float)SuperScope.this.tolerance && (float)SuperScope.this.mouseX < this.centerx + 15.0f + (float)SuperScope.this.tolerance && (float)SuperScope.this.mouseY > this.centery - 20.0f - (float)SuperScope.this.tolerance && (float)SuperScope.this.mouseY < this.centery + 20.0f + (float)SuperScope.this.tolerance && !this.held) {
                SuperScope.this.noFill();
                if (SuperScope.this.keylast == 32) {
                    SuperScope.this.editing = true;
                    this.edit = true;
                }
                if (this.edit) {
                    SuperScope.this.stroke(SuperScope.this.color(0.0f, 255.0f, 55.0f + (SuperScope.sin((float)(PApplet.parseFloat((int)SuperScope.this.millis()) / 1000.0f)) + 1.0f) * 0.5f * 200.0f));
                } else {
                    SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
                }
                SuperScope.this.ellipse(this.centerx, this.centery, this.area, this.area);
                SuperScope.this.ellipse(this.centerx, this.centery, (float)this.area + 3.0f * SuperScope.sin((float)(SuperScope.this.millis() / 100)), (float)this.area + 3.0f * SuperScope.cos((float)(SuperScope.this.millis() / 100)));
                if (SuperScope.this.mousePressed && !SuperScope.this.mousestatelast && !SuperScope.this.holding) {
                    SuperScope.this.holding = true;
                    this.held = true;
                    SuperScope.this.desval = this.value;
                    SuperScope.this.desunits = this.units;
                }
            } else if (this.edit && SuperScope.this.keylast == 32) {
                SuperScope.this.editing = false;
                this.edit = false;
            }
        }
    }

    class Inductor
    extends Element {
        Inductor(int n, float f, float f2, float f3) {
            this.units = "Henrys";
            this.value = f3;
            this.c = n;
            this.xpos = f;
            this.ypos = f2;
            this.centerx = this.xpos;
            this.centery = this.ypos;
        }

        public void display() {
            SuperScope.this.stroke(0);
            SuperScope.this.fill(this.c);
            int n = 0;
            while (n < 3) {
                SuperScope.this.fill(this.c);
                SuperScope.this.arc(this.centerx + (float)(-10 + 10 * n), this.centery + 5.0f, 10.0f, 40.0f, (float)Math.PI, (float)Math.PI * 2);
                SuperScope.this.noFill();
                SuperScope.this.arc(this.centerx + (float)(-10 + 10 * n), this.centery + 5.0f, 5.0f, 30.0f, (float)Math.PI, (float)Math.PI * 2);
                ++n;
            }
        }
    }

    class Resistor
    extends Element {
        Resistor(int n, float f, float f2, float f3) {
            this.units = "Ohms";
            this.value = f3;
            this.c = n;
            this.xpos = f;
            this.ypos = f2;
            this.centerx = this.xpos;
            this.centery = this.ypos;
        }

        public void display() {
            SuperScope.this.stroke(0);
            SuperScope.this.fill(this.c);
            SuperScope.this.beginShape();
            SuperScope.this.curveVertex(this.centerx - 20.0f, this.centery - 10.0f);
            SuperScope.this.curveVertex(this.centerx - 15.0f, this.centery);
            SuperScope.this.curveVertex(this.centerx - 10.0f, this.centery - 10.0f);
            SuperScope.this.curveVertex(this.centerx - 5.0f, this.centery);
            SuperScope.this.curveVertex(this.centerx, this.centery - 10.0f);
            SuperScope.this.curveVertex(this.centerx + 5.0f, this.centery);
            SuperScope.this.curveVertex(this.centerx + 10.0f, this.centery - 10.0f);
            SuperScope.this.curveVertex(this.centerx + 15.0f, this.centery);
            SuperScope.this.curveVertex(this.centerx + 15.0f, this.centery + 10.0f);
            SuperScope.this.curveVertex(this.centerx + 10.0f, this.centery);
            SuperScope.this.curveVertex(this.centerx + 5.0f, this.centery + 10.0f);
            SuperScope.this.curveVertex(this.centerx, this.centery);
            SuperScope.this.curveVertex(this.centerx - 5.0f, this.centery + 10.0f);
            SuperScope.this.curveVertex(this.centerx - 10.0f, this.centery);
            SuperScope.this.curveVertex(this.centerx - 15.0f, this.centery + 10.0f);
            SuperScope.this.curveVertex(this.centerx - 20.0f, this.centery);
            SuperScope.this.endShape(2);
        }
    }

    class SchemACS {
        float xpos;
        float ypos;
        float leadlx;
        float leadly;
        float leadrx;
        float leadry;
        float value;
        int id;
        boolean available;
        int check;

        SchemACS(float f, float f2, int n) {
            this.xpos = f;
            this.ypos = f2;
            this.leadlx = this.xpos - 15.0f;
            this.leadly = this.ypos;
            this.leadrx = this.xpos + 15.0f;
            this.leadry = this.ypos;
            this.id = n;
            this.available = true;
        }

        public void update() {
            if (this.available) {
                this.value = 0.0f;
            }
            int n = SuperScope.this.acsources.size() - 1;
            while (n >= 0) {
                ACSource aCSource = (ACSource)SuperScope.this.acsources.get(n);
                if (aCSource.applied) {
                    if (aCSource.held) {
                        aCSource.applied = false;
                        this.available = true;
                        this.value = 0.0f;
                    } else {
                        this.value = aCSource.value;
                    }
                }
                if (aCSource.centerx > this.xpos - 10.0f && aCSource.centerx < this.xpos + 10.0f && aCSource.centery > this.ypos - 10.0f && aCSource.centery < this.xpos + 10.0f && !aCSource.held && this.available) {
                    aCSource.centerx = this.xpos;
                    aCSource.centery = this.ypos;
                    this.value = aCSource.value;
                    this.check = n;
                    this.available = false;
                    aCSource.applied = true;
                }
                SuperScope.this.acsources.add(aCSource);
                SuperScope.this.acsources.remove(n);
                --n;
            }
            this.display();
        }

        public void display() {
            SuperScope.this.noFill();
            SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
            SuperScope.this.ellipse(this.xpos, this.ypos, 30.0f, 30.0f);
            int n = 0;
            while (n < 20) {
                SuperScope.this.set(PApplet.parseInt((float)this.xpos) - 10 + n, PApplet.parseInt((float)this.ypos) + PApplet.parseInt((float)(-10.0f * SuperScope.sin((float)((float)Math.PI * 2 * (float)n / 20.0f)))), SuperScope.this.color(0, 0, 0));
                ++n;
            }
        }
    }

    class SchemCap {
        float xpos;
        float ypos;
        float cxpos;
        float cypos;
        float leadlx;
        float leadly;
        float leadrx;
        float leadry;
        float value;
        int id;
        boolean available;
        int check;

        SchemCap(float f, float f2, int n) {
            this.xpos = f;
            this.ypos = f2;
            this.cxpos = this.xpos;
            this.cypos = this.ypos + 15.0f;
            this.leadlx = this.xpos - 5.0f;
            this.leadly = this.ypos + 15.0f;
            this.leadrx = this.xpos + 10.0f;
            this.leadry = this.ypos + 15.0f;
            this.id = n;
            this.available = true;
        }

        public void update() {
            if (this.available) {
                this.value = 0.0f;
            }
            int n = SuperScope.this.capacitors.size() - 1;
            while (n >= 0) {
                Capacitor capacitor = (Capacitor)SuperScope.this.capacitors.get(n);
                if (capacitor.applied) {
                    if (capacitor.held) {
                        this.available = true;
                        this.value = 0.0f;
                        capacitor.applied = false;
                    } else {
                        this.value = capacitor.value;
                    }
                }
                if (capacitor.centerx > this.cxpos - 15.0f && capacitor.centerx < this.cxpos + 15.0f && capacitor.centery > this.cypos - 15.0f && capacitor.centery < this.cypos + 15.0f && !capacitor.held && this.available) {
                    capacitor.centerx = this.cxpos;
                    capacitor.centery = this.cypos;
                    this.value = capacitor.value;
                    this.check = n;
                    this.available = false;
                    capacitor.applied = true;
                }
                SuperScope.this.capacitors.add(capacitor);
                SuperScope.this.capacitors.remove(n);
                --n;
            }
            this.display();
        }

        public void display() {
            SuperScope.this.stroke(0.0f, 0.0f, 0.0f);
            SuperScope.this.line(this.xpos - 5.0f, this.ypos, this.xpos - 5.0f, this.ypos + 30.0f);
            SuperScope.this.line(this.xpos + 10.0f, this.ypos, this.xpos + 10.0f, this.ypos + 30.0f);
        }
    }

    class SchemGround {
        float x1;
        float y1;
        float x2;
        float y2;
        int id;
        boolean available;

        SchemGround(float f, float f2, float f3, float f4, int n) {
            this.x1 = f;
            this.x2 = f3;
            this.y1 = f2;
            this.y2 = f4;
            this.id = n;
            this.available = true;
        }

        public void display() {
            SuperScope.this.fill(SuperScope.this.color(0, 0, 0));
            SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
            SuperScope.this.line(this.x1, this.y1, this.x2, this.y2);
            SuperScope.this.ellipse(this.x1, this.y1, 4.0f, 4.0f);
            SuperScope.this.line(this.x2 - 10.0f, this.y2, this.x2 + 10.0f, this.y2);
            SuperScope.this.line(this.x2 - 7.0f, this.y2 + 5.0f, this.x2 + 7.0f, this.y2 + 5.0f);
            SuperScope.this.line(this.x2 - 3.0f, this.y2 + 10.0f, this.x2 + 3.0f, this.y2 + 10.0f);
        }
    }

    class SchemInd {
        float xpos;
        float ypos;
        float leadlx;
        float leadly;
        float leadrx;
        float leadry;
        float value;
        int id;
        boolean available;
        int check;

        SchemInd(float f, float f2, int n) {
            this.xpos = f;
            this.ypos = f2;
            this.leadlx = this.xpos - 10.0f;
            this.leadly = this.ypos;
            this.leadrx = this.xpos + 10.0f;
            this.leadry = this.ypos;
            this.id = n;
            this.available = true;
        }

        public void update() {
            if (this.available) {
                this.value = 0.0f;
            }
            int n = SuperScope.this.inductors.size() - 1;
            while (n >= 0) {
                Inductor inductor = (Inductor)SuperScope.this.inductors.get(n);
                if (inductor.applied) {
                    if (inductor.held) {
                        this.available = true;
                        this.value = 0.0f;
                        inductor.applied = false;
                    } else {
                        this.value = inductor.value;
                    }
                }
                if (inductor.centerx > this.xpos - 10.0f && inductor.centerx < this.xpos + 10.0f && inductor.centery > this.ypos - 10.0f && inductor.centery < this.ypos + 10.0f && !inductor.held && this.available) {
                    inductor.centerx = this.xpos;
                    inductor.centery = this.ypos;
                    this.value = inductor.value;
                    this.check = n;
                    this.available = false;
                    inductor.applied = true;
                }
                SuperScope.this.inductors.add(inductor);
                SuperScope.this.inductors.remove(n);
                --n;
            }
            this.display();
        }

        public void display() {
            SuperScope.this.noFill();
            SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
            int n = 0;
            while (n < 3) {
                SuperScope.this.arc(this.xpos + (float)(-10 + 10 * n), this.ypos, 10.0f, 30.0f, (float)Math.PI, (float)Math.PI * 2);
                ++n;
            }
        }
    }

    class SchemOUT {
        float x1;
        float y1;
        float x2;
        float y2;
        int id;
        boolean available;

        SchemOUT(float f, float f2, float f3, float f4, int n) {
            this.x1 = f;
            this.x2 = f3;
            this.y1 = f2;
            this.y2 = f4;
            this.id = n;
            this.available = true;
        }

        public void display() {
            SuperScope.this.fill(SuperScope.this.color(0, 0, 0));
            SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
            SuperScope.this.line(this.x1, this.y1, this.x2, this.y2);
            SuperScope.this.ellipse(this.x1, this.y1, 4.0f, 4.0f);
            SuperScope.this.textFont(SuperScope.this.font2);
            SuperScope.this.text("OUT" + SuperScope.str((int)this.id), this.x2, this.y2);
        }
    }

    class SchemRes {
        float xpos;
        float ypos;
        float cxpos;
        float cypos;
        float leadlx;
        float leadly;
        float leadrx;
        float leadry;
        float value;
        int id;
        boolean available;
        int check;

        SchemRes(float f, float f2, int n) {
            this.xpos = f;
            this.ypos = f2;
            this.cxpos = this.xpos + 15.0f;
            this.cypos = this.ypos;
            this.leadlx = this.xpos;
            this.leadly = this.ypos;
            this.leadrx = this.xpos + 30.0f;
            this.leadry = this.ypos;
            this.id = n;
            this.available = true;
        }

        public void update() {
            if (this.available) {
                this.value = 0.0f;
            }
            int n = SuperScope.this.resistors.size() - 1;
            while (n >= 0) {
                Resistor resistor = (Resistor)SuperScope.this.resistors.get(n);
                if (resistor.applied) {
                    if (resistor.held) {
                        this.available = true;
                        this.value = 0.0f;
                        resistor.applied = false;
                    } else {
                        this.value = resistor.value;
                    }
                }
                if (resistor.centerx > this.cxpos - 10.0f && resistor.centerx < this.cxpos + 10.0f && resistor.centery > this.cypos - 10.0f && resistor.centery < this.cxpos + 10.0f && !resistor.held && this.available) {
                    resistor.centerx = this.cxpos;
                    resistor.centery = this.cypos;
                    this.value = resistor.value;
                    this.check = n;
                    this.available = false;
                    resistor.applied = true;
                }
                SuperScope.this.resistors.add(resistor);
                SuperScope.this.resistors.remove(n);
                --n;
            }
            this.display();
        }

        public void display() {
            SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
            SuperScope.this.line(this.xpos, this.ypos, this.xpos + 5.0f, this.ypos - 10.0f);
            SuperScope.this.line(this.xpos + 5.0f, this.ypos - 10.0f, this.xpos + 10.0f, this.ypos);
            SuperScope.this.line(this.xpos + 10.0f, this.ypos, this.xpos + 15.0f, this.ypos - 10.0f);
            SuperScope.this.line(this.xpos + 15.0f, this.ypos - 10.0f, this.xpos + 20.0f, this.ypos);
            SuperScope.this.line(this.xpos + 20.0f, this.ypos, this.xpos + 25.0f, this.ypos - 10.0f);
            SuperScope.this.line(this.xpos + 25.0f, this.ypos - 10.0f, this.xpos + 30.0f, this.ypos);
        }
    }

    class SchemWire {
        float x1;
        float y1;
        float x2;
        float y2;
        int id;
        boolean available;

        SchemWire(float f, float f2, float f3, float f4, int n) {
            this.x1 = f;
            this.x2 = f3;
            this.y1 = f2;
            this.y2 = f4;
            this.id = n;
            this.available = true;
        }

        public void display() {
            SuperScope.this.fill(SuperScope.this.color(0, 0, 0));
            SuperScope.this.stroke(SuperScope.this.color(0, 0, 0));
            SuperScope.this.line(this.x1, this.y1, this.x2, this.y2);
            SuperScope.this.ellipse(this.x1, this.y1, 4.0f, 4.0f);
            SuperScope.this.ellipse(this.x2, this.y2, 4.0f, 4.0f);
        }
    }

    class Sparks {
        PVector location;
        PVector movement;
        PVector acceleration;
        float[] radiusv = new float[6];
        float[] thetav = new float[6];
        float thetao;
        float omega;
        float sizev;
        int colorv;
        int birth;
        int lifetime;

        Sparks(float f, float f2, float f3, float f4, float f5, int n) {
            this.location = new PVector((float)SuperScope.this.mouseX + SuperScope.this.random(-2.0f, 2.0f), (float)SuperScope.this.mouseY + SuperScope.this.random(-2.0f, 2.0f), 0.0f);
            this.movement = new PVector(f + SuperScope.this.random(-0.1f, 0.1f), f2 + SuperScope.this.random(-0.1f, 0.1f), 0.0f);
            this.acceleration = new PVector(1.0f + f3 + SuperScope.this.random(-0.01f, 0.01f), 1.0f + f4 + SuperScope.this.random(-0.01f, 0.01f), 0.0f);
            this.radiusv[0] = 0.0f;
            this.radiusv[1] = 2.0f;
            this.radiusv[2] = SuperScope.sqrt((float)20.0f);
            this.radiusv[3] = SuperScope.sqrt((float)2.0f);
            this.radiusv[4] = SuperScope.sqrt((float)5.0f);
            this.radiusv[5] = SuperScope.sqrt((float)20.0f);
            this.thetav[0] = 0.0f;
            this.thetav[1] = (float)Math.PI;
            this.thetav[2] = SuperScope.atan((float)2.0f);
            this.thetav[3] = 0.7853982f;
            this.thetav[4] = SuperScope.atan((float)0.5f);
            this.thetav[5] = (float)Math.PI + SuperScope.atan((float)2.0f);
            this.omega = 0.0f;
            this.sizev = f5;
            this.colorv = n;
            this.birth = SuperScope.this.millis() / 1000;
            this.lifetime = 10;
        }

        public void update() {
            this.physics();
        }

        public void physics() {
            this.location.add(this.movement);
            this.movement.mult(this.acceleration);
            this.omega = SuperScope.constrain((float)SuperScope.tan((float)(this.movement.y * this.movement.x * this.acceleration.y * this.acceleration.x)), (float)-0.1f, (float)0.1f);
            this.thetao += this.omega;
        }

        public void render() {
            SuperScope.this.stroke(0);
            SuperScope.this.fill(this.colorv);
            SuperScope.this.beginShape();
            int n = 0;
            while (n < 6) {
                SuperScope.this.vertex(this.location.x + this.sizev * (SuperScope.cos((float)(this.thetav[n] + this.thetao)) * this.radiusv[n]), this.location.y + this.sizev * (SuperScope.sin((float)(this.thetav[n] + this.thetao)) * this.radiusv[n]));
                ++n;
            }
            SuperScope.this.endShape(2);
        }

        public boolean isFinished() {
            return this.lifetime < SuperScope.this.millis() / 1000 - this.birth;
        }
    }
}

