//This adds the preexisting stepper library so you can use commands like "myStepper.setSpeed()" and "myStepper.step()"
#include <Stepper.h>

//This is the number of steps in one revolution of the motor. The 28BYJ-48 motor has 2048 steps per revolution. Make sure to find the number of steps of your motor.
const int stepsPerRevolution = 2048;

// initialize the stepper library on pins 8 through 11:
Stepper myStepper(stepsPerRevolution, 8, 9, 10, 11);

void setup() {
  // set the speed at 10 rpm:
  myStepper.setSpeed(10);
}

void loop() {
  // 146 steps is 1/14th of a full rotation. Since I have 14 wells, this will index the feeder one space.
  myStepper.step(146);
  //This kills the power to the stepper to save energy and to keep it from heating up.
  digitalWrite(8, LOW);
  digitalWrite(9, LOW);
  digitalWrite(10, LOW);
  digitalWrite(11, LOW);
  //This is the delay between feeding times. During testing I found it helpful to use 1 second to make sure it was rotating well.
  //delay(1000); //Pause for 1 seconds
  delay(28800000); //Pause for 8 Hours
  
  //This section is the same as above but allows for a different delay time. After breakfast, it waits 8 hours until dinner time. Then it waits 16 hours until breakfast time.
  myStepper.step(146);
  digitalWrite(8, LOW);
  digitalWrite(9, LOW);
  digitalWrite(10, LOW);
  digitalWrite(11, LOW);
  //delay(1000); //Pause for 1 seconds
  delay(57600000); //Pause for 16 Hours
  
  
}

