/*
 * Simple demo, should work with any driver board
 *
 * Connect STEP, DIR as indicated
 *
 * Copyright (C)2015 Laurentiu Badea
 *
 * This file may be redistributed under the terms of the MIT license.
 * A copy of this license has been included with this distribution in the file LICENSE.
 */
 /*
  * Edited as found from the StepperDriver library by Ernest E Garner
  * Date: 20-Nov-2016
  * 
  * Code Description:
  *    Used to control a basic x/y gantry for the zen table created by Ernest James Garner for Instructables.com
  */
#include <Arduino.h>
#include "BasicStepperDriver.h"

//#define DEBUG

// Motor steps per revolution. Most steppers are 200 steps or 1.8 degrees/step
#define X_MOTOR_STEPS 200
#define Y_MOTOR_STEPS 200

//Motor direction to home
//    options 1 (forward)
//            -1(reverse)
#define STEP_FORWARD 1
#define STEP_REVERSE -1
#define X_DIR_HOME STEP_FORWARD
#define Y_DIR_HOME STEP_FORWARD

// All the wires needed for full functionality
#define X_MAX_PIN 6
#define X_HOME_PIN 7 //home pin.
#define X_DIR_PIN 8
#define X_STEP_PIN 9
#define X_ANALOG_PIN A0

#define Y_MAX_PIN 5
#define Y_HOME_PIN 10
#define Y_DIR_PIN 11
#define Y_STEP_PIN 12
#define Y_ANALOG_PIN A2

// Since microstepping is set externally, make sure this matches the selected mode
// 1=full step, 2=half step etc.
#define MICROSTEPS 1

// 2-wire basic config, microstepping is hardwired on the driver
BasicStepperDriver x_stepper(X_MOTOR_STEPS, X_DIR_PIN, X_STEP_PIN, X_HOME_PIN, X_MAX_PIN);
BasicStepperDriver y_stepper(Y_MOTOR_STEPS, Y_DIR_PIN, Y_STEP_PIN, Y_HOME_PIN, Y_MAX_PIN);

int x_position = 0;
int x_analog;
int y_position = 0;
int y_analog;

void setup() {
  #ifdef DEBUG
   Serial.begin(9600);
  #endif
    /*
     * Set target motor RPM.
     * These motors can do up to about 200rpm.
     * Too high will result in a high pitched whine and the motor does not move.
     * 
     * We want these motors to move slowly.
     */
    x_stepper.setRPM(100);
    y_stepper.setRPM(100);    
    
    /*
     * Tell the driver the microstep level we selected.
     * If mismatched, the motor will move at a different RPM than chosen.
     */
    x_stepper.setMicrostep(MICROSTEPS);
    y_stepper.setMicrostep(MICROSTEPS);
}

void loop() {

    /*
     * Moving motor one full revolution using the degree notation
     */
     // 1024/2 = 512
     // 512 - 40 = 472
     // 512 + 40 = 552
     x_analog = analogRead(X_ANALOG_PIN);
     // Joystick pulled to reverse and HOME not pressed
     //if ((x_analog < 472) && (digitalRead(X_HOME_PIN)==HIGH)) {
      if ((x_analog < 472)) {
       x_stepper.move(-40);
      } else if ((x_analog > 552)) {
       x_stepper.move(40);
     }
     #ifdef DEBUG
       Serial.print("X: "); Serial.print(x_analog);  //Serial.print(x_stepper.getDirection());
     #endif
     
     y_analog = analogRead(Y_ANALOG_PIN);
     
     //if ((y_analog < 472) && (digitalRead(Y_HOME_PIN)==HIGH)) {
     if ((y_analog < 472)) {
       y_stepper.move(-40);
      } else if ((y_analog > 552)) {
       y_stepper.move(40);
     }
     #ifdef DEBUG
      Serial.print("  Y: "); Serial.println(y_analog);  //Serial.getDirection(y_stepper.
     #endif

}
