﻿package com.SocketsConnection{
	import flash.display.DisplayObject;
	import flash.display.MovieClip;
	import fl.controls.Button;
	import flash.events.*;
	import flash.events.SyncEvent;
	import fl.controls.Slider;
	import fl.events.SliderEvent;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.text.TextField;
	import flash.media.Sound;
	import com.Red5Link.Red5Broadcast;
	import com.Red5Link.Red5SharedObject;
	

	public class XMLSocketController extends SocketsController {
		private var appIDNumber=0;
		private var _videoBroadcast:Red5Broadcast;
		private var _sharedObject:Red5SharedObject;
		private var sendButton:Button;
		private var playTimer:Timer;
		private var queueStatus:TextField;
		private var queuePosition;
		private var winnerStamp:MovieClip;
		public var motorX:Slider;
		public var motorY:Slider;
		public var motorZ:Slider;
		public var sliderPressed:Boolean;
		public var objectsToShare:Array;
		
		private const SECONDS_TO_PLAY=90;		
		
		public function XMLSocketController() {
			
			playTimer=new Timer(1000,SECONDS_TO_PLAY);
			playTimer.addEventListener("timer", timerHandler);
		}
				
		override public function set socketsModel(m:*):void {
			super.socketsModel=m;
			addListeners(socketsModel);
			socketsModel.addEventListener(XMLSocketModel.SOCKET_INCOMING_DATA, socketData);
			socketsModel.addEventListener(XMLSocketModel.SOCKET_PROGRESS, socketProgress);
		}
		
		override public function get socketsModel():*{
			return super.socketsModel;
		}
		
		public function set sharedObject(sharedObjParameters:Array):void {
			_sharedObject=new Red5SharedObject(sharedObjParameters[0],sharedObjParameters[1],sharedObjParameters[2]);
		}
		
		public function get sharedObject():*{
			return _sharedObject;
		}
				
		public function set videoBroadcast(broadcast:Red5Broadcast):void {
			_videoBroadcast=broadcast;
			//socketsModel.addEventListener(XMLSocketModel.SOCKET_INCOMING_DATA, socketData);
			//socketsModel.addEventListener(XMLSocketModel.SOCKET_PROGRESS, socketProgress);
		}
		
		public function get videoBroadcast():Red5Broadcast{
			return _videoBroadcast;
		}
				
		public function addSendButton(btn:Button,textObj):void {
			inputText=textObj;
			sendButton=btn;
			btn.addEventListener(MouseEvent.CLICK, sendMessage);
		}

		public function addReconnectButton(btn:DisplayObject):void {
			btn.addEventListener(MouseEvent.CLICK, reconnectServer);
		}
		
		public function addMotorButtons(motorXaxis:Slider,motorYaxis:Slider,motorZaxis:Slider):void {
			sliderPressed=false;
			motorX=motorXaxis;
			motorY=motorYaxis;
			motorZ=motorZaxis;
			motorX.addEventListener(SliderEvent.THUMB_RELEASE, sliderRelease);			
			motorY.addEventListener(SliderEvent.THUMB_RELEASE, sliderRelease);			
			motorZ.addEventListener(SliderEvent.THUMB_RELEASE, sliderRelease);
			motorX.addEventListener(SliderEvent.THUMB_PRESS, sliderPress);			
			motorY.addEventListener(SliderEvent.THUMB_PRESS, sliderPress);			
			motorZ.addEventListener(SliderEvent.THUMB_PRESS, sliderPress);
			motorX.addEventListener(Event.CHANGE, sliderChange);			
			motorY.addEventListener(Event.CHANGE, sliderChange);			
			motorZ.addEventListener(Event.CHANGE, sliderChange);
		}
		
		public function addQueueStatus(qStatus:TextField):void{
			queueStatus=qStatus;
		}
		
		public function addWinnerStamp(wStamp:MovieClip):void{
			winnerStamp=wStamp;
		}
		//////////////////////
		//THE LISTENERS		//
		//////////////////////
		public function socketData(event:Event = null):void {
			//trace("SOCKET DATA RECIVED");
			parseData(socketsModel.data);
		}
		
		
		public function socketProgress(event:Event = null):void {
			
		}
		
		private function parseData(xmlString:String):void{
			var tempStr:String = xmlString.toString();
			var xml:XML;
			xml=new XML(tempStr);   // Here new keyword is important to have otherwise it doesn't converts string to xml fomat
			if(xml.name()=="server-announce"){
				//trace(xml);
				if(xml.child(0).name()=="auth-request"){
					socketsModel.sendMessage(socketsModel.appID+appIDNumber);
					appIDNumber++;
					trace("AUTH_REQUEST");
				}else if(xml.child(0).name()=="resource-connected"){
					//@resourceID
					trace("RESOURCE-CONNECTED");
					resourceConnected(new XML(xml.children()));
				}else if(xml.child(0).name()=="resource-disconnected"){
					//@resourceID
					trace("RESOURCE-DISCONNECTED");
					resourceConnected(new XML(xml.children()));
				}else if(xml.child(0).name()=="welcome-message"){
					trace("WELCOME-MESSAGE");
					resourceConnected(new XML(xml.children()));
				}else if(xml.child(0).name()=="message"){
					//@sender
					trace("MESSAGE");
					messageRecived(new XML(xml.children()));
				}else if(xml.child(0).name()=="resource-count"){
					//@count
					trace("RESOURCE-COUNT");
				}else if(xml.child(0).name()=="queue-position"){
					//@count
					trace("QUEUE-POSITION");
					trace(xml)
					queueChanged(new XML(xml.children()));
				}
			}
		}
		
		protected function messageRecived(messageXml:XML):void{
			//trace("messageXml="+messageXml.toString());
			if (messageXml.child(0).name()=="broadcast") {
				if(messageXml.child(0)=="STARTED"){
					videoBroadcast.playStream();				
				}
			}else if(messageXml.child(0).name()=="arduino" && queuePosition=="0"){
				if(messageXml.child(0)=="WIN"){
					winnerStamp.showStamp()
					playTimer.reset();
					socketsModel.sendMessage("timeoutFromQueue");					
				}
			}
		}
		
		protected function resourceConnected(resourceXml:XML):void{
			//trace("resourceXml="+resourceXml);
			if(int(resourceXml.@resourcesCount)>1 && videoBroadcast.isconnected){
				//
			}
		}
		
		protected function queueChanged(queueXml:XML):void{
			var sound:StartSound=new StartSound();
			queuePosition=queueXml.@queue;
			if(queueXml.@queue!=""){
				if(int(queueXml.@queue)==0){
					sendButton.enabled=true;
					motorX.enabled=true;
					motorY.enabled=true;
					motorZ.enabled=true;
					objectsToShare=new Array(motorX,motorY,motorZ);
					sharedObject.addEventListener(Red5SharedObject.ON_SYNC,sharedObjectSync);
					sharedObject.startSharedObject(objectsToShare);
					queueStatus.htmlText="It's yout turn.";
					playTimer.start();
					sound.play();
				}else{
					if(int(queueXml.@queue)==1){
						queueStatus.htmlText="There is "+int(queueXml.@queue)+" user in queue before you...";
					}else if(int(queueXml.@queue)>1){
						queueStatus.htmlText="There are "+int(queueXml.@queue)+" users in queue before you...";
					}
				}
			}else{
				sendButton.enabled=false;
				motorX.enabled=false;
				motorY.enabled=false;
				motorZ.enabled=false;
				motorX.value=6;
				motorY.value=6;
				motorZ.value=6;
				sharedObject.stopSharedObject();
				socketsModel.sendMessage("getInQueue");
			}
		}
		
		protected function sliderRelease(e:SliderEvent):void {
			sliderPressed=false;
			var commandArray:Array=new Array(6,6,6);
			e.target.value=6;
			//trace("<arduino-command>"+commandArray+"</arduino-command>")
			sharedObject.pushSync();
			//socketsModel.sendMessage("<arduino-command>"+commandArray+"</arduino-command>");
		}
		
		protected function sliderPress(e:SliderEvent):void {
			sliderPressed=true;
			/*var commandArray:Array=new Array(6,6,6);
			if(e.target.name=="motorX"){
				commandArray[0]=e.target.value;
			}else if(e.target.name=="motorY"){
				commandArray[1]=e.target.value;
			}else if(e.target.name=="motorZ"){
				commandArray[2]=e.target.value;
			}
			trace(e.target.value)
			//trace("<arduino-command>"+commandArray+"</arduino-command>")
			sharedObject.pushSync();
			//socketsModel.sendMessage("<arduino-command>"+commandArray+"</arduino-command>");*/
		}
		
		protected function sliderChange(e:SliderEvent):void {
			trace("CHANGE")
			var commandArray:Array=new Array(6,6,6);
			if(e.target.name=="motorX"){
				commandArray[0]=e.target.value;
			}else if(e.target.name=="motorY"){
				commandArray[1]=e.target.value;
			}else if(e.target.name=="motorZ"){
				commandArray[2]=e.target.value;
			}
			//trace(e.target.value)
			//trace("<arduino-command>"+commandArray+"</arduino-command>")
			if(sliderPressed){
				sharedObject.pushSync();
			}
		}
		
		public function sharedObjectSync(e:SyncEvent=null):void{
			for (var i:Object in e.changeList) {
				var changeObj:Object=e.changeList[i];
				switch (changeObj.code) {
					case "success" :
						trace("success")
						break;
					
					case "change" :			
						var obj:Object=e.target.sharedObject.data[changeObj.name];
						
						for(var j:Object in objectsToShare){
							trace(j+" name "+objectsToShare[j].name+"="+obj[objectsToShare[j].name]);
							objectsToShare[j].value=obj[objectsToShare[j].name];							
						}						
						sliderChangedBySharedObject();
						break;
				}
			}
		}
		
		public function sliderChangedBySharedObject():void{
			trace("SLIDER CHANGED BY SHARED OBJECT");
			var commandArray:Array=new Array(motorX.value,motorY.value,motorZ.value);
			
		}
		
		private function timerHandler(event:TimerEvent):void {
            if(playTimer.currentCount<SECONDS_TO_PLAY){
				queueStatus.htmlText="It's yout turn. You have "+(SECONDS_TO_PLAY-playTimer.currentCount)+" seconds left";
			}else{
				playTimer.reset();
				motorX.enabled=false;
				motorY.enabled=false;
				motorZ.enabled=false;
				motorX.value=6;
				motorY.value=6;
				motorZ.value=6;
				sharedObject.pushSync();
				socketsModel.sendMessage("timeoutFromQueue");
			}
        }
		
	}
}