// IoT soil moisture monitor by Becky Stern
// full tutorial: https://www.instructables.com/lesson/EDJV9EYJ8AGQ8B0/
//
// based on examples from Adafruit IO Arduino Library:
// https://github.com/adafruit/Adafruit_IO_Arduino
//
// Adafruit invests time and resources providing this open source code.
// Please support Adafruit and open source hardware by purchasing
// products from Adafruit!
//
// Written by Todd Treece for Adafruit Industries
// Copyright (c) 2016 Adafruit Industries
// Licensed under the MIT license.
//
// All text above must be included in any redistribution.
/**
 * SHTx Arduino library:
 * https://github.com/practicalarduino/SHT1x
 * Read temperature and humidity values from an SHT1x-series (SHT10,
 * SHT11, SHT15) sensor.
 * Copyright 2009 Jonathan Oxer <jon@oxer.com.au>
 * www.practicalarduino.com
 */
/************************** Configuration ***********************************/

// edit the config.h tab and enter your Adafruit IO credentials
// and any additional configuration needed for WiFi, cellular,
// or ethernet clients.
#include "config.h"

/************************ Code Starts Here *******************************/


#include <SHT1x.h>
#include <ESP8266WiFi.h>
#include <AdafruitIO.h>
#include <Adafruit_MQTT.h>
#include <ArduinoHttpClient.h>

// Specify data and clock connections and instantiate SHT1x object
#define dataPin  12 // NodeMCU pin D6
#define clockPin 14 // NodeMCU pin D5
SHT1x sht1x(dataPin, clockPin);

// set up the feed
AdafruitIO_Feed *humidity = io.feed("humidity");
AdafruitIO_Feed *temperature = io.feed("temperature");

const int sleepTime = 15; // 15 minutes

void setup()
{
   Serial.begin(115200); // Open serial connection to report values to host
   Serial.println("Starting up");
   // connect to io.adafruit.com
  Serial.print("Connecting to Adafruit IO");
  io.connect();
  
  // wait for a connection
  while(io.status() < AIO_CONNECTED) {
    Serial.print(".");
    delay(500);
  }

  // we are connected
  Serial.println();
  Serial.println(io.statusText());
}

void loop()
{
  // io.run(); is required for all sketches.
  // it should always be present at the top of your loop
  // function. it keeps the client connected to
  // io.adafruit.com, and processes any incoming data.
  io.run();
  
  float temp_c;
  float temp_f;
  float moisture;

  // Read values from the sensor
  temp_c = sht1x.readTemperatureC();
  temp_f = sht1x.readTemperatureF();
  moisture = sht1x.readHumidity();

  // Print the values to the serial port
  Serial.print("Temperature: ");
  Serial.print(temp_c, DEC);
  Serial.print("C / ");
  Serial.print(temp_f, DEC);
  Serial.print("F. Humidity: ");
  Serial.print(moisture);
  Serial.println("%");
  
  humidity->save(moisture);
  temperature->save(temp_f);

  // Sleep
  Serial.println("ESP8266 is sleeping...");
  ESP.deepSleep(sleepTime * 1000000 * 60);
}
