﻿Imports System.IO
Imports System.Windows.Forms
Imports Strings = Microsoft.VisualBasic ' so can use things like left( and right( for strings
Imports System.Net.Mail ' for email
Imports System.Net ' for xively
Imports System.Text
' to draw lines, Toolbox, then right at the bottom, Visual Basic Powerpacks

Public Class Form1
    Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Integer) ' for sleep statements
    Public Baud As String = "1200" ' slower baud rate as environment in pump shed electrically noisy
    Dim InPacket(0 To 2000) As Byte
    Dim OutPacket(0 To 2000) As Byte
    Dim PacketInput(0 To 17) As Byte
    Dim AnalogValues(0 To 5) As Integer
    Dim PacketString As String
    Dim SolarGraph As New Bitmap(360, 100)
    Dim Units As Single
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Timer1.Enabled = True ' turn on timer
        TabControl1.SelectedTab = TabPage1
        'MsgBox("Open COM port (network tab) and turn on messages (pump tab)")
        'OpenComPort() ' open the com port 
        ' messages already on
    End Sub
    Sub OpenComPort()
        Try
            SerialPort1.PortName = TextBox1.Text
            SerialPort1.BaudRate = Baud
            SerialPort1.Parity = IO.Ports.Parity.None ' no parity
            SerialPort1.DataBits = 8 ' 8 bits
            SerialPort1.StopBits = IO.Ports.StopBits.One ' one stop bit
            'SerialPort1.ReadTimeout = 1000 ' milliseconds so times out in 1 second if no response
            SerialPort1.Open() ' open the port
            SerialPort1.DiscardInBuffer() ' clear the input buffer
            'SerialPort1.Handshake = System.IO.Ports.Handshake.RequestToSend  'handshaking on (or .None to turn off)
        Catch ex As Exception
            MsgBox("Error opening serial port - is another program using the selected COM port? Disabling messages.")
        End Try
    End Sub
    Sub SendByte(ByVal c As Byte)
        OutPacket(0) = c ' send as a byte through an array
        If SerialPort1.IsOpen = True Then
            SerialPort1.Write(OutPacket, 0, 1)
        End If
    End Sub
    Sub SendString(ByVal Lineoftext As String)
        Dim i As Integer

        For i = 1 To Strings.Len(Lineoftext)
            OutPacket(0) = Strings.Asc(Strings.Mid(Lineoftext, i, 1))
            SerialPort1.Write(OutPacket, 0, 1) ' send 1 byte
            Sleep(100) ' arduino needs a little time to process if running software serial
            System.Windows.Forms.Application.DoEvents() ' update the display
        Next i
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Static OneSec As Integer ' can only have one timer as gets very confusing with three running at once
        Static TenSec As Integer
        Static OneMinute As Integer
        Static ThreeSec As Integer
        ' collect bytes from the serial port
        Timer1.Enabled = False ' so don't get stuck in a loop reading bytes
        CollectBytes() ' fetch bytes frequently
        OneSec += 1
        TenSec += 1
        OneMinute += 1
        ThreeSec += 1
        If OneSec > 9 Then ' this time is 100ms
            OneSecTimer()
            OneSec = 0
        End If
        If TenSec > 99 Then
            TenSecTimer() ' do 10 sec tasks
            TenSec = 0
        End If
        If OneMinute > 599 Then
            OneMinTimer() ' do one minute tasks
            OneMinute = 0
        End If
        If ThreeSec > 29 Then
            FourSecTimer()
            ThreeSec = 0
        End If
        Timer1.Enabled = True
    End Sub
    Private Sub CollectBytes()
        Dim BytesToRead As Integer
        Dim i As Integer
        If SerialPort1.IsOpen = True Then
            Do
                If SerialPort1.BytesToRead = 0 Then Exit Do ' no more bytes
                BytesToRead = SerialPort1.BytesToRead
                If BytesToRead > 2000 Then BytesToRead = 2000
                SerialPort1.Read(InPacket, 0, BytesToRead) ' read in a packet
                For i = 1 To BytesToRead
                    TextBox3.Text += Strings.Chr(InPacket(i - 1))
                Next
            Loop
        End If
    End Sub


    Private Sub OneSecTimer() ' happens once a second
        Call ReceiveArduino()
        Call AnalogInputs()
        Call TallTankValue()
        Call MetalTank()
        Call CalculateSolar()
        Call CheckTime() ' check if off peak
        Call ProcessSolarDelay() ' see if enough solar power to run a pump
        Call PeakOrSolar()
        Call TankLogic()
        Call TallTank()
        Call ChooseLowerPump()
        Call chooseUpperPump()
    End Sub
    Private Sub TenSecTimer() ' happens once every 10 seconds
        CheckEmailSent() ' send just once a day
        Call SendArduino() ' send the status of the relays
    End Sub
    Private Sub FourSecTimer()

    End Sub
    Private Sub OneMinTimer() ' happens once a minute
        DrawGraph()
        If CheckBox6.Checked = True Then
            Call XivelyUpload()
        End If
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        SerialPort1.Close() ' already open when program starts so close it
        OpenComPort() ' open the com port
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        SerialPort1.Close()
    End Sub
    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        End
    End Sub
    Private Sub ProcessSolarDelay()
        ' if solar >4800w and delay =0 then turn red - label38
        ' if goes under 4800w then delay = 180 and turn green - label17
        ' if no change for 180 secs then turn green ' label41
        ' this routine runs once a second
        Dim SolarPower As Long
        Dim LastOffCounter As Long
        Dim NotChangingCounter As Long
        Dim Solar4800 As Boolean
        Static LastPower As Long
        Static averagePower As Long
        Dim difference As Long

        SolarPower = Strings.Val(Label35.Text)
        LastOffCounter = Strings.Val(Label17.Text)
        NotChangingCounter = Strings.Val(Label41.Text)
        ' do an average to avoid glitches
        difference = SolarPower - averagePower
        averagePower = averagePower + (difference / 50)
        If averagePower > 20000 Then averagePower = 20000
        If averagePower < 0 Then averagePower = 0
        ' logic
        Label61.Text = Int(Strings.Str(averagePower))
        If averagePower < 4800 Then
            LastOffCounter = 60 ' reset if goes under 4800W and wait a while for clouds etc
            Solar4800 = False
        End If
        If LastPower <> SolarPower Then ' has changed so reset counter to 60 - power over a kw is lots of changes
            NotChangingCounter = 60
        End If
        If averagePower > 4800 And LastOffCounter = 0 And NotChangingCounter > 0 Then
            ' solar on if has been off for over 3 mins and number keeps changing
            Solar4800 = True
        End If
        If NotChangingCounter = 0 Then
            ' solar off, hasn't changed for a long time
            Solar4800 = False
        End If

        LastOffCounter -= 1 ' subtract one
        NotChangingCounter -= 1 ' subtract one

        LastPower = SolarPower
        If LastOffCounter < 0 Then LastOffCounter = 0
        If NotChangingCounter < 0 Then NotChangingCounter = 0
        ' restore all the labels
        Label17.Text = Strings.Str(LastOffCounter)
        Label41.Text = Strings.Str(NotChangingCounter)
        If Solar4800 = True Then
            Label37.Text = "True"
        Else
            Label37.Text = "False"
        End If
    End Sub
    Private Sub CheckTime()
        'TextBox7.Text = Format(Now, "yyyy-MM-dd hh:mm:ss")
        Dim Offpeak As Boolean
        TextBox7.Text = Format(Now, "ddd") ' dd is a number, ddd is a 3 letter string
        TextBox8.Text = Format(Now, "HH") ' capital H is 24h, small h is 12h clock
        TextBox9.Text = Format(Now, "mm")
        Select Case TextBox7.Text
            Case "Mon", "Tue", "Wed", "Thu", "Fri"
                If Strings.Val(TextBox8.Text) >= 8 And Strings.Val(TextBox8.Text) < 21 Then ' off peak is before 8am and after 9pm
                    Offpeak = False
                Else
                    Offpeak = True
                End If
            Case "Sat", "Sun"
                Offpeak = True
        End Select
        If CheckBox2.Checked = True Then ' manual override
            Offpeak = True
        End If
        If Offpeak = True Then
            Label14.Text = "True"
        Else
            Label14.Text = "False"
        End If
    End Sub
    Private Sub AnalogInputs()
        Label7.Text = Strings.Str(AnalogValues(0))
        Label21.Text = Strings.Str(AnalogValues(1))
        Label18.Text = Strings.Str(AnalogValues(2))
    End Sub
    Private Sub Button10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button10.Click
        ' Show all available COM ports. 
        For Each sp As String In My.Computer.Ports.SerialPortNames
            ListBox2.Items.Add(sp)
        Next
    End Sub
    Private Sub DrawGraph()
        Dim Hour As Integer
        Dim Minute As Integer
        Dim GraphX As Integer
        Dim GraphY As Integer
        Dim Solar As Integer
        Dim n As Single
        Hour = Format(Now, "HH")  ' capital H is 24h, small h is 12h clock
        Minute = Format(Now, "mm")
        Solar = Strings.Val(Label35.Text) ' get the solar power
        GraphX = (Hour * 60 + Minute) / 4 ' 1440 minutes/4 is 360 which is the width of the picturebox
        If GraphX > 359 Then GraphX = 359
        For GraphY = 0 To 99 ' 100 pixels high
            SolarGraph.SetPixel(GraphX, GraphY, Color.Black) ' delete this column
            If GraphX < 356 Then
                SolarGraph.SetPixel(GraphX + 1, GraphY, Color.Black) ' delete next column too
                SolarGraph.SetPixel(GraphX + 2, GraphY, Color.Black) ' and the next one
            End If
        Next
        GraphY = Solar / 200 ' 20000w is 100 on the graph
        If GraphY > 99 Then GraphY = 99
        GraphY = 100 - GraphY ' upside down
        For i = 99 To GraphY Step -1
            SolarGraph.SetPixel(GraphX, i, Color.Orange) ' plot the solar power
        Next i
        If (Minute >= 0 And Minute <= 4) Then
            For GraphY = 95 To 99
                SolarGraph.SetPixel(GraphX, GraphY, Color.Gray) ' put a small line in once an hour
            Next
        End If
        If Label16.Text = "True" Then
            SolarGraph.SetPixel(GraphX, 10, Color.Red) ' red dot if red pump running
        End If
        If Label25.Text = "True" Then
            SolarGraph.SetPixel(GraphX, 15, Color.Yellow) ' yellow dot if yellow pump running
        End If
        If Label32.Text = "True" Then ' top tank was empty
            SolarGraph.SetPixel(GraphX, 20, Color.Magenta)
        End If
        n = 99 - (Strings.Val(Label12.Text) * 30) ' upside down
        SolarGraph.SetPixel(GraphX, n, Color.Green) ' plot the tall tank level
        PictureBox1.Image = SolarGraph ' update the picturebox
        If (Hour = 1 And Minute = 1) Then
            Units = 0 ' reset the kwh total
        End If
        ' this routine every 10s minute so calculate units
        Units += (Solar / (60000 * 6))
        'Label51.Text = Strings.Str(Units) + "kWh"
    End Sub
    Private Sub Button13_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button13.Click
        SendEmail()
    End Sub
    Private Sub SendEmail()
        Dim Smtp_Server As New SmtpClient
        Dim e_mail As New MailMessage()
        Label10.Text = "Wait..."
        System.Windows.Forms.Application.DoEvents()
        Try
            Smtp_Server.UseDefaultCredentials = False
            Smtp_Server.Credentials = New Net.NetworkCredential("moxhamj@internode.on.net", "wibbly") ' username, password
            Smtp_Server.Port = 25 ' same settings as in email program
            'Smtp_Server.EnableSsl = True - need to comment this out
            Smtp_Server.Host = "mail.internode.on.net" ' use same settings as in email account in email programs
            e_mail = New MailMessage()
            e_mail.From = New MailAddress(TextBox28.Text)
            e_mail.To.Add(TextBox29.Text)
            e_mail.Subject = "Email Sending"
            e_mail.IsBodyHtml = False
            'e_mail.Body = Label51.Text ' total kwh
            Smtp_Server.Send(e_mail)
            Label10.Text = "Sent"
        Catch error_t As Exception
            Label10.Text = "Fail"
        End Try
    End Sub
    Sub CheckEmailSent()
        Static EmailSentToday As Boolean
        Dim Hour As Integer
        Hour = Strings.Val(Format(Now, "HH")) ' 24h
        If Hour = 22 And EmailSentToday <> True Then
            SendEmail() ' do just once a day
            EmailSentToday = True
        End If
        If Hour = 23 And EmailSentToday = True Then
            EmailSentToday = False
            ' reset everything
        End If
    End Sub
    Sub xivelyFeedUpdate(ByVal ApiKey As String, ByVal feedId As String, ByVal channel As String, ByVal value As String)
        Dim request As WebRequest = WebRequest.Create("http://api.xively.com/v2/feeds/" + feedId + ".csv")
        Dim postData As String
        postData = channel + "," + value ' eg sensor1,5       ' build string to send
        Dim byteArray As Byte() = Encoding.UTF8.GetBytes(postData)
        request.Method = "PUT"                                ' PUT or GET
        request.ContentLength = byteArray.Length              ' the length of channel and value
        request.ContentType = "text/csv"                      ' text and comma separated data
        request.Headers.Add("X-ApiKey", ApiKey)               ' send the header
        request.Timeout = 5000
        Label56.Text = "Connecting..."
        Try
            Dim dataStream As Stream = request.GetRequestStream() ' Get the request stream.
            dataStream.Write(byteArray, 0, byteArray.Length)      ' Write the data to the request stream.
            dataStream.Close()                                    ' Close the Stream object.
            Dim response As WebResponse = request.GetResponse()   ' Get the response - usually just Ok
            ' need to add a try/catch error routine here in case the internet connection goes down
            Label56.Text += CType(response, HttpWebResponse).StatusDescription        ' Display the status.
            dataStream = response.GetResponseStream()             ' Get the stream containing content returned by the server.
            Dim reader As New StreamReader(dataStream)            ' Open the stream using a StreamReader for easy access.
            Dim responseFromServer As String = reader.ReadToEnd() ' Read the content.
            Label56.Text += responseFromServer                   ' Display the content.
            reader.Close()                                        ' close the streams
            dataStream.Close()
            response.Close()
        Catch ex As Exception
            Label56.Text = "No connection"
        End Try
    End Sub
    Private Sub XivelyUpload()
        ' call this once a minute, if the upload checkbox is checked

        TextBox32.Text = Label61.Text ' solar average power in watts
        TextBox34.Text = Label12.Text ' tall tank level in metres
        If Label32.Text = "True" Then
            TextBox36.Text = "0" ' top tank status, 1 is full, 0 is empty
        Else
            TextBox36.Text = "1"
        End If

        If Label51.Text = "True" Then ' lower pump on (doesn't matter which one)
            TextBox38.Text = 1
        Else
            TextBox38.Text = 0
        End If
        Label11.Text = TextBox31.Text
        System.Windows.Forms.Application.DoEvents() ' update the display
        xivelyFeedUpdate(TextBox24.Text, TextBox25.Text, TextBox31.Text, TextBox32.Text) ' solar power
        Label11.Text = TextBox33.Text
        System.Windows.Forms.Application.DoEvents() ' update the display
        xivelyFeedUpdate(TextBox24.Text, TextBox25.Text, TextBox33.Text, TextBox34.Text) ' tall tank value
        Label11.Text = TextBox35.Text
        System.Windows.Forms.Application.DoEvents() ' update the display
        xivelyFeedUpdate(TextBox24.Text, TextBox25.Text, TextBox35.Text, TextBox36.Text) ' top tank value
        Label11.Text = TextBox37.Text
        System.Windows.Forms.Application.DoEvents() ' update the display
        xivelyFeedUpdate(TextBox24.Text, TextBox25.Text, TextBox37.Text, TextBox38.Text) ' pump on
        Label11.Text = "Xively done"
    End Sub
    Private Sub Button9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button9.Click
        XivelyUpload() ' test button
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        SendString(TextBox2.Text)
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        TextBox3.Clear()
    End Sub
    Sub SendArduino()
        ' send data bytes, recevive them back
        Dim buildString As String
        TextBox3.Clear() ' clear the input box
        buildString = "R"
        If Label16.Text = "True" Then buildString += "1" Else buildString += "0"
        If Label25.Text = "True" Then buildString += "1" Else buildString += "0"
        If Label27.Text = "True" Then buildString += "1" Else buildString += "0"
        buildString += "0" ' last relay spare at the moment
        SendString(buildString) ' send this message
        ' now to receive, wait for a valid message
    End Sub
    Sub ReceiveArduino()
        ' call once a second, look for a > prompt in textbox3
        Dim lineoftext As String
        Dim i As Integer
        Dim st As Integer
        Dim numberstring As String
        lineoftext = TextBox3.Text
        If InStr(lineoftext, ">") > 0 Then
            st = InStr(lineoftext, "Analog Inputs ")
            For i = 0 To 5
                numberstring = Strings.Mid(lineoftext, (st + 14) + (i * 6), 5)
                AnalogValues(i) = Strings.Val(numberstring)
            Next
        End If
        TextBox4.Clear() ' display the analog values
        For i = 0 To 5
            TextBox4.Text += Strings.Str(AnalogValues(i)) + vbCrLf
        Next
    End Sub
    Private Sub TallTankValue()
        Dim n As Single
        n = Strings.Val(Label7.Text)
        n = n / 204.6 ' 1023 is 5.00
        Label12.Text = Strings.Str(n)
        Label12.Text = FormatNumber(CDbl(Label12.Text), 2) ' two decimal places
    End Sub
    Private Sub MetalTank()
        Dim n As Integer
        n = Strings.Val(Label21.Text)
        If n > 512 Then
            Label32.Text = "True"
        Else
            Label32.Text = "False"
        End If
    End Sub
    Private Sub CalculateSolar()
        ' 1023 is 5V which is 20000W
        Dim n As Single
        n = Strings.Val(Label18.Text)
        n = n * 19.55 ' scale factor
        n = Int(n) ' convert to integer
        Label35.Text = Strings.Str(n)
    End Sub

    Private Sub PeakOrSolar()
        If Label37.Text = "True" Or Label14.Text = "True" Then
            Label3.Text = "True"
        Else
            Label3.Text = "False"
        End If
    End Sub
    Private Sub TankLogic()
        If Label32.Text = "True" And Label3.Text = "True" Then
            Label4.Text = "True"
        Else
            Label4.Text = "False"
        End If
    End Sub

    Private Sub TallTank()
        ' allows for the fact the bottom pump can be faster or slower than the top pump
        ' if bottom pump faster, then it oscillates between 0.8m and 1.2m and turns the lower pump on or off
        ' if the bottom pump slower, oscillates between 0.3 and 0.7m

        Dim metresHead As Single
        Dim pumpControl As Boolean
        Static upperPump As Boolean
        Static lowerPump As Boolean
        metresHead = Strings.Val(Label12.Text)
        If Label4.Text = "True" Then
            pumpControl = True
        Else
            pumpControl = False
        End If
        ' be careful changing the thresholds, eg making wider, otherwise there are some startup levels where the pumps never start
        If metresHead < 0.3 Then upperPump = False ' turn off upper pump, tank almost empty
        If metresHead > 0.8 Then upperPump = True ' turn on upper pump, tank half full
        If metresHead < 0.85 Then lowerPump = True ' turn on lower pump, above upper pump threshold
        If metresHead > 1.2 Then lowerPump = False ' turn off lower pump, pumping too much
        Label57.Text = "Ok" ' might get overridden if there is a fault
        If metresHead < 0.2 Then
            upperPump = False ' fault, turn everything off, tall tank almost empty
            lowerPump = False
            Label57.Text = "Fault Low"
        End If
        If metresHead > 1.3 Then
            upperPump = False ' fault, turn everything off, tall tank almost empty
            lowerPump = False
            Label57.Text = "Fault High"
        End If
        If pumpControl = False Then ' overrides everything above if the pump control is off
            upperPump = False
            lowerPump = False
        End If
        ' convert back to text
        If upperPump = True Then
            Label46.Text = "True"
        Else
            Label46.Text = "False"
        End If
        If lowerPump = True Then
            Label51.Text = True
        Else
            Label51.Text = False
        End If


    End Sub
    Private Sub chooseLowerPump()
        ' red or yellow or both
        Dim Yellow As Boolean
        Dim Red As Boolean
        If RadioButton1.Checked = True Then Red = True
        If RadioButton2.Checked = True Then Yellow = True
        If RadioButton3.Checked = True Then
            Red = True
            Yellow = True
        End If
        If Label51.Text = "False" Then ' overrides above if pumps not on
            Red = False
            Yellow = False
        End If
        If Red = True Then ' change th3e text labels
            Label16.Text = "True"
        Else
            Label16.Text = False

        End If
        If Yellow = True Then
            Label25.Text = True
        Else
            Label25.Text = False
        End If
    End Sub
    Private Sub chooseUpperPump()
        ' can add more code here if add a second upper pump
        Label27.Text = Label46.Text
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        SerialPort1.Close() ' already open when program starts so close it
        OpenComPort() ' open the com port
        Timer1.Enabled = True
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        Timer1.Enabled = True
    End Sub

    Private Sub CheckBox6_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox6.CheckedChanged
        If CheckBox6.Checked = True Then
            Label11.Text = "Xively on"
        Else
            Label11.Text = "Xively off"
        End If
    End Sub
End Class
