// Talks to PC vial serial on pins 2,3. Two commands - read pins and write pins
// the computer does all the controlling
// ** self contained relay modules are active LOW ***
// running four relays tends to make the regulator on the arduino quite warm, despite power only being 7V
// so run these modules from a separate 5V supply (switching modules are only $1 now). 
// A0 is the tall tank level
// A1 is the top tank, full is 0, empty is 1006, so look for > or < 512
// A2 is solar volts 0 to 5V (20kw is 5V)
// rest not used.
// Command to set pins is R0010   so just send 5 bytes, module will reply with the analog readings




boolean D4 = false; // four output pins, false is off, true is on
boolean D5 = false;
boolean D6 = false;
boolean D7 = false;
char inbuffer[4];
long lastUpdate = 0;
#include <SoftwareSerial.h>
SoftwareSerial mySerial(2,3); // RX, TX

void setup() {  
  //Serial.begin(115200);  // for debugging
  mySerial.begin(1200);  // software serial baud rate
  pinMode(4, OUTPUT);     
  pinMode(5, OUTPUT);     
  pinMode(6, OUTPUT);     
  pinMode(7, OUTPUT);  
  updateOutputs();  // start with relays off
  mySerial.println();
  mySerial.println("Pump controller Jan 29, 2015 by J. Moxham");
  mySerial.println("Command is R1010 (5 bytes, on or off) and will return with the analog values");
  prompt();
}

void loop() {
  lookForR();
  timeOut(); // timeout if no input for a while
    
}

void timeOut() // all relays off if not input for 60 seconds
{
 if ((millis()-lastUpdate)>60000){
   D4=false;
   D5=false;
   D6=false;
   D7=false;
   updateOutputs();
 }  
  
}  



void updateOutputs() {
  updatePin(4,D4);
  updatePin(5,D5);
  updatePin(6,D6);
  updatePin(7,D7);
}  

void updatePin(int p, boolean s) {
  if (s == false) {
    digitalWrite(p,HIGH); // self contained relay modules tend to be active low
  }else{
    digitalWrite(p,LOW);
  }
}  

void sendInteger(int x) // always 5 bytes, so add leading zeros if needed
{
  if (x<10000) {mySerial.print("0");} // leading zeros
  if (x<1000) {mySerial.print("0");} // leading zeros
  if (x<100) {mySerial.print("0");} // leading zeros
  if (x<10) {mySerial.print("0");} // leading zeros
  mySerial.print(x);
  mySerial.print(" "); // trailing space
}  

void printAnalogInputs() {
  int sensorValue = 0;
  mySerial.print("Analog Inputs "); // send as one line
  sendInteger(analogRead(A0));
  sendInteger(analogRead(A1));
  sendInteger(analogRead(A2));
  sendInteger(analogRead(A3));
  sendInteger(analogRead(A4));
  sendInteger(analogRead(A5));
  mySerial.println(); // crlf
}  

void changeRelays() { // has got a capital R so next 4 characters are the relay state
  if (inbuffer[0] == '1') { D4 = true; }else{ D4 = false; }  
  if (inbuffer[1] == '1') { D5 = true; }else{ D5 = false; }  
  if (inbuffer[2] == '1') { D6 = true; }else{ D6 = false; }  
  if (inbuffer[3] == '1') { D7 = true; }else{ D7 = false; }  
  updateOutputs(); // print out the analog values
  lastUpdate = millis();
}

void prompt() {
  mySerial.print(">");
}  

void lookForR() {
  char c;
  if (mySerial.available()) {
    c = mySerial.read();
    if ((c == 'R') || (c == 'r')) {
       mySerial.write("R"); // echo the start command
       collectBytes();
    }else{
      mySerial.println("?");
      prompt();
    }  
  }  
}


void collectBytes() { // collects 4 bytes and echos them back
  int count = 0;
  while (count < 4) {
   if (mySerial.available()) {
     inbuffer[count] = mySerial.read(); // store the character
     mySerial.write(inbuffer[count]); // echo back the character
     count += 1;
   }  
  }  
  changeRelays();
  mySerial.println(); // new line
  printAnalogInputs();
  prompt(); // print the prompt again
}
