// virtual analog connnection - volts in analog A0 comes out of another arduino via radio link
// Using Yishi 1200 baud modules but any RS232 radio module will do
// can use RS232 voltage levels, or TTL levels. If TTL, use 5V radio modules, or 3V to 5V level converters.
// there are RS232 shields available, or use a max232 and 4 1uF caps.
// Voltage output is via a low pass filter 10uF and 10k which has a cutoff of 4Hz. Then a ca3140 voltage follower 
// input to pin 3(+), pin 2(-) and output(6) joined. The ca3140 is supplied by Vin, as it can't quite get to 5V if run from 5V.
// For debugging, if the arduino is powered from just the serial cable, output will only be max 3.5V from the op amp.
// can power from a higher supply (>7V) and from USB at the same time - arduino selects whichever is higher
// the ca3140 has two local power supply capacitors - 470uF 25V, and 0.1uF.
// this circuit uses pin 3 as the pwm output, pin 4 is Rx from max232, pin 5 is tx to max232
// Yishi 1020 pinout 1=gnd, 2=-5V, 3 and 4 NC, 5=gnd, 6=Tx,7=Rx, 8=5V (sleep when low), 9=NC

#define pwmPin 3 // pwm out pin
#define ledPin 13 // for diagnostics

#include <SoftwareSerial.h>
SoftwareSerial radioSerial(4,5); // RX, TX

int voltsReceived = 0; // only updated if valid packet comes through. 50000 is 5V


void setup()
{
  Serial.begin(115200); // for debugging
  radioSerial.begin(1200);
  pinMode(ledPin, OUTPUT);   
  Serial.println("Start");
  randomSeed(analogRead(0));
 }
 
void loop()
{
  flashLed(); // flash led
  sendInteger(sampleVolts()); // sample my analog A0 and send it
  listenRadio(); // listen for any data coming back
  delay(random(100,300)); // short random delay so nodes don't happen to synchronise
}

void listenRadio()
{
  int i;
  for (i=0;i<5;i++) { // how many times to loop, n in seconds
     radioReceiveInteger(); // listen for another 1 second, times out after this
     outputVolts(); // output the value from the other node, either new or existing value if no messages have come in
  }   
}

void outputVolts()
{
  float n;
  n = (float) voltsReceived; // convert to a floating value
  n = n / 19.607;  // 5000 to 255 is divide by 19.607
  n = constrain(n,0,255); // constrain to this range
  analogWrite(pwmPin,n);
}  

int sampleVolts() // sample analog input 0 and returns a number 0 to 5000
{
  float n;
  int v;
  n = analogRead(0); // read voltage
  n = n * 4.8875; // scale so 1023 becomes 5000 which is 5V
  Serial.println(n);
  v = (int) n; // convert to integer
  v = constrain(v,0,5000); // make sure in range 
  return v;
}  

/*void dumpData()
{
   if (radioSerial.available())
    Serial.write(radioSerial.read());
}  
*/
void sendInteger(int x) // packet is SnnnnnF and always 7 bytes long
{
  radioSerial.print("S"); // start
  if (x<10000) {radioSerial.print("0");} // leading zeros
  if (x<1000) {radioSerial.print("0");} // leading zeros
  if (x<100) {radioSerial.print("0");} // leading zeros
  if (x<10) {radioSerial.print("0");} // leading zeros
  radioSerial.print(x);
  radioSerial.print("F"); // finish marker
}  

void radioReceiveInteger()
{
  int i;
  char c;
  String numberString = "";
  if (radioSerial.find("S")) { // got a start byte, times out after 1 second
    delay(200); // wait for rest of packet to come in
    if (radioSerial.available() == 6) {// should be 6 bytes, if yes, then fetch them, if no, something is wrong
      for(i=0;i<5;i++) {// get five bytes
        c=radioSerial.read();  // read in the byte
        numberString += c; // build the string
      }
      c=radioSerial.read(); // get the finish byte
      if (c == 'F') { // if valid, update the global voltsReceived number
        Serial.println(numberString);
        voltsReceived = numberString.toInt();
        longFlashLed();
      }  
    }  
  }
}
void flashLed()
{
  digitalWrite(ledPin, HIGH); // turn the LED on (HIGH is the voltage level)
  delay(50);                  // wait a bit
  digitalWrite(ledPin, LOW);    // turn the LED off by making the voltage LOW\
  delay(100);
}  

void longFlashLed()
{
  digitalWrite(ledPin, HIGH); // turn the LED on (HIGH is the voltage level)
  delay(500);                  // wait a bit
  digitalWrite(ledPin, LOW);    // turn the LED off by making the voltage LOW\
  delay(100);
}  

