// pulse circuit: 5V to 1k to +ve of RCA. Then negative RCA to X to 100k to ground. X goes to D2.
// output display - ca3140 op amp with about 4x gain (22k/82k) and a 22V supply - displays 0-20V on pin 3
// there is some scaling on the 20V output - not sure why this is needed but trial and error determine the correct values
// also output 0-5V on pin 5 (5kw = 20Kw)

boolean pulse = false; // if interrupt has happened

unsigned long lastTime; //Used to measure power.
double power; //power in watts
double pulseDelay;
int ppwh = 1; //1000 pulses/kwh = 1 pulse per wh
int led = 13; // pin 13 is led on most boards

void setup()
{
  attachInterrupt(0, onPulse, FALLING); // KWH interrupt attached to IRQ 1  = pin2
  pinMode(led, OUTPUT);     // initialize the led digital pin as an output.
  power = 5000; // for debugging startup, should output 1.25V and display 5.000
  outputPower();
  //analogWrite(3,scaleValue(5000)); // for testing startup, should display 5.00 and output 1.25V
  //analogWrite(5,128);
}
void loop()
{
  if (pulse == true) {
    outputPower();
  }  
}

void outputPower()
{
    int powerInteger=0;
    int fiveVolt;
    powerInteger = (int)(power); // remove decimal points
    analogWrite(3,scaleValue(powerInteger)); // 0-5V and scaled for the 4x amplifier
    fiveVolt = power/78; // scale 20000 becomes 255 which is 5V
    analogWrite(5,fiveVolt); // 0 to 5V but not scaled
    digitalWrite(led,HIGH);
    delay(100); // flash led
    digitalWrite(led,LOW);
    delay(100);
    pulse = false;
}

void onPulse() // interrupt routine if a pulse comes in
{
  pulseDelay = micros() - lastTime; // delay in microseconds
  if (pulseDelay > 10000) // if more than 10ms (debounce)
  {
    lastTime = micros(); //  store the time now
    power = (3600000000.0 / (pulseDelay))/ppwh; // power
    power = power * 5; // adjust for the meter I have - 200 imp/kwh, not 1000/kwh
    power = constrain(power,0,20000); // max and min values
    pulse = true; // can't use delays in interrupt routines and need to keep routines very short otherwise serial probs
  }
}

double scaleValue(double n) // pass kw, returns value 0-255 ready for analog write
// output is non linear so scale with different values
{
  double answer;
  if (n >= 0 && n<=999) { answer = n/83;}
  if (n >=1000 && n<=1999) { answer = n/88;}
  if (n >=2000 && n<=2999) { answer = n/90;}  
  if (n >=3000 && n<=3999) { answer = n/91;}
  if (n >=4000 && n<=4999) { answer = n/91;}
  if (n >=5000 && n<=5999) { answer = n/91;}
  if (n >=6000 && n<=6999) { answer = n/91;}
  if (n >=7000 && n<=7999) { answer = n/92;}
  if (n >=8000 && n<=8999) { answer = n/92;}
  if (n >=9000 && n<=9999) { answer = n/92;}
  if (n >=10000 && n<=10999) { answer = n/92;}
  if (n >=11000 && n<=11999) { answer = n/92;}
  if (n >=12000 && n<=12999) { answer = n/92;}
  if (n >=13000 && n<=13999) { answer = n/92;}
  if (n >=14000 && n<=14999) { answer = n/92;}  
  if (n >=15000 && n<=15999) { answer = n/92;}
  if (n >=16000 && n<=16999) { answer = n/92;}
  if (n >=17000 && n<=17999) { answer = n/92;}
  if (n >=18000 && n<=18999) { answer = n/91;}  
  if (n >=19000 && n<=19999) { answer = n/89;}
  return answer;
}
