//written by Lisa Winter 2013

int buttonPin = 7;  // button is connected to pin 7
int ledPin = 3;  // LED is connected to pin 3
int buttonStatus; // variable we'll use to store the button's status
int potPin = 3;    // the potentiometer is connected to analog pin 3
int ledPin10 = 10;   // RGB LED green connected to pin 10
int ledPin9 = 9;   // RGB LED red connected to pin 9
int ledPin5 = 5;   // RGB LED blue connected to pin 5
int val = 0; // variable to store the value coming from the sensor
int buttonMomStatus; // variable we'll use to store the momentary button's status
int momButton = 6; // momentary button is connected to pin 6
int buzzer = 8; // buzzer is connected to pin 8

void setup() {
  Serial.begin(9600); // initialize serial communications at 9600 bps:
  pinMode(buttonPin, INPUT);  // Initialize the buttonPin as input
  pinMode(ledPin, OUTPUT);  // The LED is an output
  pinMode(ledPin10, OUTPUT);  // declare the ledPin10 as an OUTPUT
  pinMode(ledPin9, OUTPUT);  // declare the ledPin9 as an OUTPUT
  pinMode(ledPin5, OUTPUT);  // declare the ledPin5 as an OUTPUT
  pinMode(momButton, INPUT);  // Initialize the momButton as input
  pinMode (buzzer, OUTPUT); //buzzer is output
}

void loop() {
  buttonStatus = digitalRead(buttonPin);
  if (buttonStatus == HIGH) {
    digitalWrite(ledPin, HIGH);  // If the button is pressed turn the LED on
  }
  else {
    digitalWrite(ledPin, LOW);  // Otherwise, turn the LED off
  }
  
  val = analogRead(potPin); // read the potentiometer value
  analogWrite(ledPin10, val/4);  // PWM the LED with the pot value (divided by 4 to fit in a byte)
  analogWrite(ledPin9, val/4);  // PWM the LED with the pot value (divided by 4 to fit in a byte)
  analogWrite(ledPin5, val/4);  // PWM the LED with the pot value (divided by 4 to fit in a byte)
  delay(10);                     // wait 10 milliseconds before the next loop
  
  buttonMomStatus = digitalRead(momButton);
  if (buttonMomStatus == HIGH) {
    digitalWrite(buzzer, HIGH);  // If the momentary button is pressed turn the LED on
  }
  else {
    digitalWrite(buzzer, LOW);  // Otherwise, turn the LED off
  }
  
  //bonus section
  if (buttonStatus == HIGH  && buttonMomStatus == HIGH) { //if rocker and momentary switches are on at the same time
    digitalWrite(ledPin10, LOW);   // turn the ledPin off
    digitalWrite(ledPin5, LOW);   // turn the ledPin off, by turning them off the RGB LED turns red
    delay(500); 
  } 
}

