/***************************************************
  Arduino TFT graphics library for the SH1106

  typical use is:
      #include <Wire.h>
      #include "SimpleSH1106.h"
      Wire.begin(); // join i2c bus as master
      TWBR = 5; // freq=615kHz period=1.625uS
      initSH1106();
      DrawImageSH1106(20,1,imgSmiley);

  typical I2C speed values are:
      TWBR = 1; // freq=888kHz period=1.125uS
      TWBR = 2; // freq=800kHz period=1.250uS
      TWBR = 3; // freq=727kHz period=1.375uS
      TWBR = 4; // freq=666kHz period=1.500uS
      TWBR = 5; // freq=615kHz period=1.625uS
      TWBR = 10; // freq=444kHz period=2.250uS
      TWBR = 20; // freq=285kHz period=3.500uS
      TWBR = 30; // freq=210kHz period=4.750uS
      TWBR = 40; // freq=166kHz period=6.000uS
      TWBR = 50; // freq=137kHz period=7.250uS

***************************************************/

#ifndef SimpleSH1106_h
#define SimpleSH1106_h 

#include <Wire.h>
#include <Arduino.h>

const int addr = 0x3C;

void DrawByteSH1106(byte x, byte page, byte i);
void setupPageCol(int page, int col);
void setupCol(int col);
void setupPage(int page);
void clearSH1106();
void initSH1106();
void DrawBarSH1106(byte bar);
int DrawImageSH1106(int16_t x, int16_t p, const uint8_t *bitmap);
int DrawCharSH1106(uint8_t c, byte x, byte page, word Font);
int DrawStringSH1106(char *s, byte x, byte page, word Font);
int DrawIntSH1106(long i, byte x, byte page, word Font);

extern bool BoldSH1106;

const byte SmallFont[] PROGMEM = {
  ' ', // first char
  1, // height in pages
  4, 0x00,0x00,0x00,0x00,  //
  1, 0x5F,  // !
  3, 0x03,0x00,0x03,  // "
  5, 0x14,0x7F,0x14,0x7F,0x14,  // #
  5, 0x24,0x4A,0xFF,0x52,0x24,  // $
  6, 0x46,0x26,0x10,0x08,0x64,0x62,  // %
  5, 0x3A,0x45,0x4A,0x30,0x48,  // &
  1, 0x03,  // '
  2, 0x7E,0x81,  // (
  2, 0x81,0x7E,  // )
  2, 0x03,0x03,  // *
  3, 0x10,0x38,0x10,  // +
  1, 0xC0,  // ,
  2, 0x10,0x10,  // -
  1, 0x40,  // .
  2, 0x78,0x0F,  // /
  4, 0x3E,0x41,0x41,0x3E,  // 0
  2, 0x02,0x7F,  // 1
  4, 0x62,0x51,0x49,0x46,  // 2
  4, 0x22,0x41,0x49,0x36,  // 3
  4, 0x18,0x16,0x7F,0x10,  // 4
  4, 0x2F,0x45,0x45,0x39,  // 5
  4, 0x3E,0x49,0x49,0x32,  // 6
  4, 0x01,0x71,0x0D,0x03,  // 7
  4, 0x36,0x49,0x49,0x36,  // 8
  4, 0x26,0x49,0x49,0x3E,  // 9
  1, 0x48,  // :
  1, 0xC8,  // ;
  3, 0x10,0x28,0x44,  // <
  3, 0x28,0x28,0x28,  // =
  3, 0x44,0x28,0x10,  // >
  4, 0x02,0x51,0x09,0x06,  // ?
  8, 0x3C,0x42,0x99,0xA5,0x9D,0xA1,0x22,0x1C,  // @
  6, 0x60,0x1C,0x13,0x13,0x1C,0x60,  // A
  6, 0x7F,0x49,0x49,0x49,0x49,0x36,  // B
  6, 0x3E,0x41,0x41,0x41,0x41,0x22,  // C
  6, 0x7F,0x41,0x41,0x41,0x41,0x3E,  // D
  5, 0x7F,0x49,0x49,0x49,0x41,  // E
  5, 0x7F,0x09,0x09,0x09,0x01,  // F
  6, 0x3E,0x41,0x41,0x49,0x29,0x7A,  // G
  6, 0x7F,0x08,0x08,0x08,0x08,0x7F,  // H
  1, 0x7F,  // I
  4, 0x30,0x40,0x40,0x3F,  // J
  5, 0x7F,0x08,0x14,0x22,0x41,  // K
  4, 0x7F,0x40,0x40,0x40,  // L
  8, 0x7F,0x03,0x0C,0x30,0x30,0x0C,0x03,0x7F,  // M
  6, 0x7F,0x03,0x0C,0x30,0x40,0x7F,  // N
  6, 0x3E,0x41,0x41,0x41,0x41,0x3E,  // O
  6, 0x7F,0x09,0x09,0x09,0x09,0x06,  // P
  6, 0x3E,0x41,0x41,0x51,0x61,0xBE,  // Q
  6, 0x7F,0x09,0x09,0x09,0x09,0x76,  // R
  5, 0x26,0x49,0x49,0x49,0x32,  // S
  5, 0x01,0x01,0x7F,0x01,0x01,  // T
  5, 0x3F,0x40,0x40,0x40,0x3F,  // U
  5, 0x03,0x1C,0x60,0x1C,0x03,  // V
  7, 0x03,0x1C,0x60,0x18,0x60,0x1C,0x03,  // W
  5, 0x63,0x14,0x08,0x14,0x63,  // X
  5, 0x03,0x04,0x78,0x04,0x03,  // Y
  5, 0x61,0x51,0x49,0x45,0x43,  // Z
  2, 0xFF,0x81,  // [
  2, 0x1E,0x70,
  2, 0x81,0xFF,  // ]
  3, 0x02,0x01,0x02,  // ^
  4, 0x00,0x00,0x00,0x00,  // _
  2, 0x01,0x02,  // `
  4, 0x20,0x54,0x54,0x78,  // a
  4, 0x7F,0x44,0x44,0x38,  // b
  4, 0x38,0x44,0x44,0x28,  // c
  4, 0x38,0x44,0x44,0x7F,  // d
  4, 0x38,0x54,0x54,0x18,  // e
  2, 0x7E,0x09,  // f
  4, 0x18,0xA4,0xA4,0x7C,  // g
  4, 0x7F,0x08,0x04,0x78,  // h
  1, 0x7D,  // i
  1, 0xFD,  // j
  4, 0x7F,0x18,0x24,0x40,  // k
  1, 0x7F,  // l
  7, 0x7C,0x04,0x04,0x7C,0x04,0x04,0x78,  // m
  4, 0x7C,0x04,0x04,0x78,  // n
  5, 0x38,0x44,0x44,0x44,0x38,  // o
  4, 0xFC,0x24,0x24,0x18,  // p
  4, 0x18,0x24,0x24,0xFC,  // q
  2, 0x7C,0x04,  // r
  4, 0x48,0x54,0x54,0x24,  // s
  2, 0x3E,0x44,  // t
  4, 0x3C,0x40,0x40,0x7C,  // u
  4, 0x1C,0x60,0x60,0x1C,  // v
  5, 0x1C,0x60,0x18,0x60,0x1C,  // w
  3, 0x6C,0x10,0x6C,  // x
  3, 0x9C,0xA0,0x7C,  // y
  3, 0x64,0x54,0x4C,  // z
  2, 0x91,0x6E,  // {
  1, 0xFE,  // |
  2, 0x6E,0x91,  // }
  4, 0x04,0x02,0x04,0x02,  // ~
  1, 0xFE,  // 
  0};

const byte DigitsFont[] PROGMEM = {
  '-', //first char
  1, // height in pages
  4, 0x10,0x10,0x10,0x10,       // -
  1, 0x40,                      // .
  3, 0x60,0x1C,0x03,            // /
  4, 0x3E,0x41,0x41,0x3E,       // 0
  2, 0x02,0x7F,                 // 1
  4, 0x62,0x51,0x49,0x46,       // 2
  4, 0x22,0x41,0x49,0x36,       // 3
  4, 0x18,0x16,0x7F,0x10,       // 4
  4, 0x2F,0x45,0x45,0x39,       // 5
  4, 0x3E,0x49,0x49,0x32,       // 6
  4, 0x01,0x71,0x0D,0x03,       // 7
  4, 0x36,0x49,0x49,0x36,       // 8
  4, 0x26,0x49,0x49,0x3E,       // 9
  0}; // end

const byte LargeDigitsFont[] PROGMEM = {
  '+', // first char
  2, // height in pages
  12, 0x00,0x00,0x00,0x00,0x00,0xF0,0xF0,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0xFF,0xFF,0x06,0x06,0x06,0x06,0x06,  // +
  4, 0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x40,  // ,
  6, 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x06,0x06,0x06,0x06,  // -
  2, 0x00,0x00,0xC0,0xC0,  // .
  6, 0x00,0x00,0xC0,0xFC,0xFE,0x0E,0xE0,0xFC,0x7F,0x07,0x00,0x00,  // /
  10, 0xF0,0xFC,0x1E,0x0E,0x06,0x06,0x0E,0x1E,0xFC,0xF0,0x1F,0x7F,0xF0,0xE0,0xC0,0xC0,0xE0,0xF0,0x7F,0x1F,  // 0
  5, 0x70,0x38,0x1C,0xFE,0xFE,0x00,0x00,0x00,0xFF,0xFF,  // 1
  10, 0x18,0x1C,0x0E,0x06,0x06,0x06,0x0E,0x8E,0xFC,0xF8,0xC0,0xE0,0xF0,0xD8,0xDC,0xCE,0xC7,0xC3,0xC1,0xC0,  // 2
  10, 0x18,0x1C,0x0E,0x06,0x86,0x86,0xCE,0xFC,0x78,0x00,0x30,0x70,0xE0,0xC0,0xC1,0xC1,0xC1,0xE3,0x7F,0x3E,  // 3
  10, 0x00,0x00,0xC0,0xE0,0x70,0x38,0xFC,0xFE,0x00,0x00,0x0E,0x0F,0x0F,0x0C,0x0C,0x0C,0xFF,0xFF,0x0C,0x0C,  // 4
  10, 0xC0,0xFE,0xFE,0xCE,0xC6,0xC6,0xC6,0xC6,0x86,0x00,0x31,0x71,0xE1,0xC0,0xC0,0xC0,0xC0,0xF1,0x7F,0x3F,  // 5
  10, 0xF0,0xF8,0xBC,0xCE,0xC6,0xC6,0xC6,0xCE,0x9C,0x18,0x1F,0x7F,0x73,0xE1,0xC0,0xC0,0xC0,0xF1,0x7F,0x3F,  // 6
  10, 0x06,0x06,0x06,0x06,0x86,0xC6,0xF6,0x3E,0x1E,0x06,0x00,0x00,0xF0,0xFE,0x3F,0x03,0x00,0x00,0x00,0x00,  // 7
  10, 0x00,0x78,0xFC,0xCE,0x86,0x86,0xCE,0xFC,0x78,0x00,0x3E,0x7F,0xE3,0xC1,0xC1,0xC1,0xC1,0xE3,0x7E,0x3E,  // 8
  10, 0xF8,0xFC,0x1E,0x0E,0x06,0x06,0x06,0x9C,0xFC,0xF0,0x31,0x73,0xE7,0xC6,0xC6,0xC6,0xE7,0x7B,0x3F,0x1F,  // 9
  0};

const byte imgSmiley[] PROGMEM = {
  21, // width
  3, // pages
  4,0,192,48,8,130,4,130,130,133,1,130,130,130,4,7,8,48,192,0,31,96,128,130,0,1,67,130,132,1,3,131,0,
  1,3,130,132,1,67,130,0,3,128,96,31,130,0,2,1,2,130,4,130,8,133,17,130,8,130,4,2,2,1,130,0};

#endif


