//
//  Motor.m
//  Roboticcccccc
//
//  Created by Timothy Chong on 1/24/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import "Motor.h"

@implementation Motor

-(id) initWithAngle:(double) ang name: (NSString*) lab serialPort: (NSString*) sp min: (double)mi max: (double) ma range :(double)rg{
    self = [super init];
    if(self)
    {
        angle = ang;
        label = [[NSString alloc]initWithFormat:lab];
        serialPort = sp;
        MIN = mi;
        MAX = ma;
        range = rg;
        [serialPort retain];
        [self moveActualTo:ang];
    }
    return self;
}

-(void) moveTo: (double) ang {  
    targetAngle = ang;
    while (targetAngle != angle) {[self calculateChange];}
}

-(void) calculateChange {
    [NSThread sleepForTimeInterval:0.03];
    if(abs(targetAngle-angle)<= 2) {angle = targetAngle;}
   
    double diff = (targetAngle - angle) * 0.1;
    
    [self moveActualTo:(angle + diff)];
}

-(void) moveActualTo:(double)ang {
    angle = ang;
    [self inputWithInt:[self toCorrectForm:ang]];
}

-(NSString*) toCorrectForm:(double)number {
    double re = MIN +((MAX-MIN)/range*number);
    
    if(re >= 100 && re < 1000) {return [[NSString alloc] initWithFormat:@"0%d",(int)re];}
    else                       {return [[NSString alloc] initWithFormat:@"%d",(int)re];}
}

-(void) inputWithInt:(NSString*)toBeSent {
    NSMutableString *str = [[NSMutableString alloc]initWithFormat:@"echo %@%@ > %@",label,toBeSent,serialPort];
    NSLog(@"%@",str);
    char *toSend = [str UTF8String]; 
    [str release];
    FILE *f = popen(toSend, "r");
    pclose(f);
}

-(double) getAngle {return angle;}

-(void) report {
    NSMutableString* str = [[NSMutableString alloc]init];
    [str appendFormat:@"\nlabel : %@\n",label];
    [str appendFormat:@"current Angle :%d\n",angle];
    [str appendFormat:@"min :%d\n",MIN];
    [str appendFormat:@"max :%d\n",MAX];
    [str appendFormat:@"SerialPort: %@\n\n\n",serialPort];

    NSLog(@"%@",str);
    [str release];
    str = nil;
}


@end
