#include <xc.h>         
#include <stdint.h>       
#include <stdbool.h>       
#include "system.h"        
#include "user.h" 
#include <pic16f628a.h>  

// CONFIG
#pragma config FOSC = XT        // Oscillator Selection bits (XT oscillator: Crystal/resonator on RA6/OSC2/CLKOUT and RA7/OSC1/CLKIN)
#pragma config WDTE = OFF       // Watchdog Timer Enable bit (WDT disabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config MCLRE = ON       // RA5/MCLR/VPP Pin Function Select bit (RA5/MCLR/VPP pin function is MCLR)
#pragma config BOREN = OFF      // Brown-out Detect Enable bit (BOD disabled)
#pragma config LVP = OFF        // Low-Voltage Programming Enable bit (RB4/PGM pin has digital I/O function, HV on MCLR must be used for programming)
#pragma config CPD = OFF        // Data EE Memory Code Protection bit (Data memory code protection off)
#pragma config CP = OFF         // Flash Program Memory Code Protection bit (Code protection off)

// used in place the std xc8 delay.

void delay_us(volatile unsigned char us_count) {
    // 10 clk gives 2us at 5 MHz instr / 20 MHz system    
    // 5 clk gives 2us at 2.5 MHz instr / 10 MHz system     
#asm
dlyloop:

    nop; // 1 clk (1clk per nop)
    nop; // 1 clk (1clk per nop)  
    nop; // 1 clk (1clk per nop)
    nop; // 1 clk (1clk per nop)  
    nop; // 1 clk (1clk per nop)
    nop; // 1 clk (1clk per nop)
    addlw 0xFE; // 1 clk
    btfsc STATUS, 0; // 1 ck
    goto dlyloop; // 2 clk
#endasm
}

void ms_delay(int amount){
    
    for(int k=0; k<amount; k++){
        for(int j=0; j<100; j++){
                delay_us(10);
        }
    }
    
}

void main(void) {
    
    InitApp();

    while (1) {

                                       
                           PORTBbits.RB3 = MOTOR_DIS; //left motor enable
                           PORTBbits.RB5 = MOTOR_DIS; // right motor enabled
                           PORTBbits.RB2 = MOTOR_REV;
                           PORTBbits.RB4 = MOTOR_REV;
                           PORTBbits.RB6 = LED_OFF; // set left led on 
                           PORTBbits.RB7 = LED_OFF; // set left led on 
       
                            if(PORTBbits.RB0 == 1){ // feeler left was pressed... //PORTBbits.RB0;

                                        PORTBbits.RB2 = MOTOR_REV; // set left motor reversed
                                        PORTBbits.RB3 = MOTOR_EN; // set left motor enable on

                                        PORTBbits.RB4 = MOTOR_REV; // set right motor reversed
                                        PORTBbits.RB5 = MOTOR_EN; // set right motor enable on

                                        PORTBbits.RB6 = LED_ON; // set left led on 

                                        ms_delay(200);

                                        PORTBbits.RB2 = MOTOR_REV; // set left motor reversed
                                        PORTBbits.RB3 = MOTOR_DIS; // set left motor enable off

                                        PORTBbits.RB4 = MOTOR_REV; // set right motor reversed
                                        PORTBbits.RB5 = MOTOR_EN; // set right motor enable on

                                        PORTBbits.RB6 = LED_ON; // set left led on 

                                        ms_delay(100);

                                        PORTBbits.RB4 = MOTOR_REV; // set right motor reversed
                                        PORTBbits.RB5 = MOTOR_DIS; // set right motor enable on

                                        PORTBbits.RB6 = LED_OFF; // set left led off 
                            };

                            if(PORTBbits.RB1 == 1){ // feeler right was pressed...

                                       PORTBbits.RB2 = MOTOR_REV; // set left motor reversed
                                       PORTBbits.RB3 = MOTOR_EN; // set left motor enable on

                                       PORTBbits.RB4 = MOTOR_REV; // set right motor reversed
                                       PORTBbits.RB5 = MOTOR_EN; // set right motor enable on

                                       PORTBbits.RB7 = LED_ON; // set right led on 

                                       ms_delay(200);

                                       PORTBbits.RB2 = MOTOR_REV; // set left motor reversed
                                       PORTBbits.RB3 = MOTOR_EN; // set left motor enable on

                                       PORTBbits.RB4 = MOTOR_REV; // set right motor reversed
                                       PORTBbits.RB5 = MOTOR_DIS; // set right motor enable off

                                       PORTBbits.RB7 = LED_ON; // set right led on 

                                       ms_delay(100);

                                       PORTBbits.RB2 = MOTOR_REV; // set right motor reversed
                                       PORTBbits.RB3 = MOTOR_DIS; // set right motor enable off

                                       PORTBbits.RB7 = LED_OFF; // set right led off 
                            };

                            if( (PORTAbits.RA0 == 1) & (PORTAbits.RA1 == 0)  ){ // if left LDR is on 

                                        PORTBbits.RB4 = MOTOR_FWD; // right motor goes forwards
                                        PORTBbits.RB5 = MOTOR_EN; // right motor enabled

                                        PORTBbits.RB7 = LED_ON; // set left led on

                                        ms_delay(100);

                           }else

                           if( (PORTAbits.RA0 == 0) & (PORTAbits.RA1 == 1)  ){ // if right LDR is

                                        PORTBbits.RB2 = MOTOR_FWD; //left motor goes forwards
                                        PORTBbits.RB3 = MOTOR_EN; //left motor enable

                                        PORTBbits.RB6 = LED_ON; // set left led on 

                                        ms_delay(100);

                           }else
                                
                               
                          if( (PORTAbits.RA0 == 1) & (PORTAbits.RA1 == 1)){ // both on
                                    
                                        PORTBbits.RB2 = MOTOR_FWD; //left motor goes forwards
                                        PORTBbits.RB3 = MOTOR_EN; //left motor enable

                                        PORTBbits.RB6 = LED_ON; // set left led on 
                                        
                                        PORTBbits.RB4 = MOTOR_FWD; // right motor goes forwards
                                        PORTBbits.RB5 = MOTOR_EN; // right motor enabled

                                        PORTBbits.RB7 = LED_ON; // set left led on

                                        ms_delay(100);
                               
                          };

                            
    };

};