/*

OLED ROBOT EYES CONTROLLER V1.0
By Allan Murray 2015

USES:
Universal 8bit Graphics Library, http://code.google.com/p/u8glib/

BUT NEED TO CHANGE THIS TO ALLOW CONTROL OF TWO DISPLAYS:

In the file called: u8g_com_arduino_ssd_i2c.c
Located in directory: Arduino\libraries\U8glib\utility

CHANGE THE LINE: #define I2C_SLA         (0x3c*2)
TO:              uint8_t I2C_SLA = 0x3d*2;

*/


#include "U8glib.h"

extern uint8_t I2C_SLA; 

U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NONE|U8G_I2C_OPT_DEV_0);	// I2C / TWI 

/* Images are 48x48 pixels
   Dumps can be generated from bitmap using LCD Assistant
   http://en.radzio.dxp.pl/bitmap_converter/
*/

const uint8_t heart []  PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, 0x00, 0xFF, 0xF0, 0x0F, 0xFF, 0x00, 0x03, 0xFF,
0xF8, 0x1F, 0xFF, 0xC0, 0x07, 0xFF, 0xFE, 0x7F, 0xFF, 0xE0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF,
0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF,
0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE,
0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF,
0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF,
0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF,
0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x03, 0xFF,
0xFF, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x3F, 0xFF, 0xFF,
0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x07,
0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00,
0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC0, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t spiral [] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8,
0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x1F, 0xE0, 0x00, 0x00, 0x07,
0xC0, 0x00, 0xF8, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x78, 0x1F, 0xFE, 0x0E, 0x00,
0x00, 0xF0, 0xFF, 0xFF, 0x87, 0x00, 0x01, 0xC3, 0xF0, 0x03, 0xE3, 0x80, 0x03, 0x87, 0x80, 0x00,
0xF1, 0xC0, 0x07, 0x1E, 0x07, 0xF8, 0x38, 0xE0, 0x06, 0x3C, 0x3F, 0xFE, 0x1C, 0x60, 0x0E, 0x70,
0xF8, 0x0F, 0x8E, 0x30, 0x1C, 0x61, 0xE0, 0x03, 0xC7, 0x38, 0x18, 0xE3, 0x81, 0xE0, 0xE3, 0x18,
0x39, 0xC7, 0x0F, 0xF8, 0x73, 0x9C, 0x31, 0x8E, 0x3F, 0x3E, 0x31, 0x8C, 0x33, 0x9C, 0x70, 0x0F,
0x39, 0xCC, 0x73, 0x18, 0xE0, 0x03, 0x18, 0xCE, 0x63, 0x39, 0xC7, 0xE3, 0x9C, 0xC6, 0x67, 0x31,
0x8F, 0xF1, 0x8C, 0xC6, 0x66, 0x33, 0x9C, 0x39, 0xCC, 0xE6, 0x66, 0x33, 0x18, 0x18, 0xCC, 0x66,
0x66, 0x33, 0x39, 0x98, 0xCC, 0x66, 0x06, 0x73, 0x39, 0x98, 0xCC, 0x66, 0x06, 0x33, 0x39, 0xF8,
0xCC, 0x66, 0x06, 0x33, 0x19, 0xF1, 0x8C, 0xE6, 0x07, 0x33, 0x9C, 0x03, 0x8C, 0xC6, 0x03, 0x31,
0x8C, 0x07, 0x18, 0xC6, 0x03, 0x39, 0xCF, 0x3E, 0x39, 0xCC, 0x03, 0x18, 0xC7, 0xFC, 0x71, 0x8C,
0x03, 0x9C, 0xE1, 0xE0, 0xF3, 0x9C, 0x01, 0x8C, 0x70, 0x01, 0xE3, 0x18, 0x01, 0xCE, 0x3C, 0x0F,
0x87, 0x38, 0x00, 0xC7, 0x1F, 0xFF, 0x0E, 0x30, 0x00, 0xE3, 0x87, 0xF8, 0x3C, 0x70, 0x00, 0x71,
0xC0, 0x00, 0x78, 0xE0, 0x00, 0x38, 0xF0, 0x03, 0xE1, 0xC0, 0x00, 0x1C, 0x7F, 0xFF, 0xC3, 0x80,
0x00, 0x0E, 0x1F, 0xFE, 0x0F, 0x00, 0x00, 0x07, 0x01, 0xE0, 0x1E, 0x00, 0x00, 0x03, 0xC0, 0x00,
0xF8, 0x00, 0x00, 0x00, 0xFC, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00,
0x07, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t  LOL [] PROGMEM = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x3F, 0xC0,
0x1F, 0xF0, 0x1F, 0xE0, 0x3F, 0xC0, 0x3F, 0xF8, 0x1F, 0xE0, 0x3F, 0xC0, 0x7F, 0xFC, 0x1F, 0xE0,
0x3F, 0xC0, 0x7F, 0xFC, 0x1F, 0xE0, 0x3F, 0xC0, 0xFF, 0xFE, 0x1F, 0xE0, 0x3F, 0xC0, 0xFF, 0xFE,
0x1F, 0xE0, 0x3F, 0xC0, 0xFF, 0xFF, 0x1F, 0xE0, 0x3F, 0xC0, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1,
0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0,
0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF,
0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1,
0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0,
0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF,
0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1,
0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0,
0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF, 0x1F, 0xE0, 0x3F, 0xC1, 0xFE, 0xFF,
0x1F, 0xE0, 0x3F, 0xFD, 0xFE, 0xFF, 0x1F, 0xFE, 0x3F, 0xFC, 0xFF, 0xFF, 0x1F, 0xFE, 0x3F, 0xFC,
0xFF, 0xFE, 0x1F, 0xFE, 0x3F, 0xFC, 0xFF, 0xFE, 0x1F, 0xFE, 0x3F, 0xFC, 0x7F, 0xFC, 0x1F, 0xFE,
0x3F, 0xFC, 0x7F, 0xFC, 0x1F, 0xFE, 0x3F, 0xFC, 0x3F, 0xF8, 0x1F, 0xFE, 0x3F, 0xFC, 0x1F, 0xF0,
0x1F, 0xFE, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


const uint8_t normal [] PROGMEM = {
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};


char cmdbuffer[19];
byte cmdlen=0;;
bool cmdinput   =false;
byte cmd=0;

void draw(byte d) {
  
if (d==0)  u8g.drawBitmapP( 40, 16, 6, 48, normal);
if (d==1)  u8g.drawBitmapP( 40, 16, 6, 48, spiral);
if (d==2)  u8g.drawBitmapP( 40, 16, 6, 48, heart);
if (d==3)  u8g.drawBitmapP( 40, 16, 6, 48, LOL);

}

void setup(void) {
  
  Serial.begin(9600);
   Serial.println(9999);
   
   I2C_SLA = 0x078;
  u8g.firstPage();  
  do {
    draw(0);
  } while( u8g.nextPage() );
  
   I2C_SLA = 0x07A;
  u8g.firstPage();  
  do {
    draw(0);
  } while( u8g.nextPage() );
  
}

void loop(void) {
  
cmdinput=false;

    while (Serial.available()>0 ) {
      char s=Serial.read();
      if ((s<33) || (cmdlen>=18)) {
       if (cmdlen>0) { 
       cmdinput=true;
       cmdbuffer[cmdlen]=0;
       break;
       }
      }
      else
      {
      cmdbuffer[cmdlen]=s;
      cmdlen++;
      cmdbuffer[cmdlen]=0;
      }
    }
 

  if (cmdinput) {
    
     Serial.println(cmdbuffer);
    
    if ( (strcmp(cmdbuffer,"OK")==0) ) cmd=0;  
    if ( (strcmp(cmdbuffer,"CRAZY")==0) ) cmd=1;
    if ( (strcmp(cmdbuffer,"LOVE")==0) ) cmd=2;
    if ( (strcmp(cmdbuffer,"FUNNY")==0) ) cmd=3;

     cmdlen=0;
     cmdbuffer[cmdlen]=0;

     I2C_SLA = 0x078;
     u8g.firstPage();  
  do {
    draw(cmd);
  } while( u8g.nextPage() );
  
    I2C_SLA = 0x07A;
    u8g.firstPage();  
  do {
    draw(cmd);
  } while( u8g.nextPage() );


  }

}

