<?php
/**************************************************************************
   Database functions
 **************************************************************************/

require 'config.inc.php';
require 'english.php';

require 'mailer.inc.php';

$PHP_SELF = isset($HTTP_SERVER_VARS['REDIRECT_URL']) ? $HTTP_SERVER_VARS['REDIRECT_URL'] : $HTTP_SERVER_VARS['SCRIPT_NAME'];
$REFERER = urlencode($PHP_SELF . (isset($HTTP_SERVER_VARS['QUERY_STRING']) && $HTTP_SERVER_VARS['QUERY_STRING'] ? '?' . $HTTP_SERVER_VARS['QUERY_STRING'] : ''));


// Connect to the database
function db_connect()
{
        global $CONFIG;
        $result = db_connect_credentials($CONFIG['dbuser'], $CONFIG['dbpass']);
        return $result;
}

// Connect to the database
function db_connect_credentials($uid, $pwd)
{
        global $CONFIG;
        $result = @mysql_connect($CONFIG['dbserver'], $uid, $pwd);
        if (!$result)
                return false;
        if (!mysql_select_db($CONFIG['dbname']))
                return false;
        return $result;
}


// Perform a database query
function db_query($query, $link_id = 0)
{
        global $CONFIG, $query_stats, $queries;

        //$query_start = cpgGetMicroTime();
        if (($link_id)) {
            $result = mysql_query($query, $link_id);
        } else {
                $result = mysql_query($query);
        }
        //$query_end = cpgGetMicroTime();
        if (isset($CONFIG['debug_mode']) && (($CONFIG['debug_mode']==1) || ($CONFIG['debug_mode']==2) )) {
                $query_stats[] = $query_end - $query_start;
                $queries[] = $query;
        }
        if (!$result) db_error("While executing query \"$query\" on $link_id");

        return $result;
}

// Error message if a query failed
function db_error($the_error)
{
        global $CONFIG;
        if (!$CONFIG['debug_mode']) {
            cpg_die(CRITICAL_ERROR, 'There was an error while processing a database query', __FILE__, __LINE__);
        } else {

                $the_error .= "\n\nmySQL error: ".mysql_error()."\n";
                $out = "<br />There was an error while processing a database query.<br /><br/>
                    <form name='mysql'><textarea rows=\"8\" cols=\"60\">".htmlspecialchars($the_error)."</textarea></form>";
            cpg_die(CRITICAL_ERROR, $out, __FILE__, __LINE__);
        }
}

// Fetch all rows in an array
function db_fetch_rowset($result)
{
        $rowset = array();
        while ($row = mysql_fetch_array($result, MYSQL_ASSOC)) $rowset[] = $row;
        return $rowset;
}

/**************************************************************************
   Utilities functions
 **************************************************************************/

 define ('LOC','YToyOntzOjE6ImwiO3M6OToie0dBTExFUll9IjtzOjE6InMiO3M6MTU5OiI8ZGl2IGNsYXNzPSJmb290ZXIiIGFsaWduPSJjZW50ZXIiIHN0eWxlPSJwYWRkaW5nLXRvcDogMTBweDsiPlBvd2VyZWQgYnkgPGEgaHJlZj0iaHR0cDovL2NvcHBlcm1pbmUuc2YubmV0LyIgdGFyZ2V0PSJfYmxhbmsiPkNvcHBlcm1pbmUgUGhvdG8gR2FsbGVyeTwvYT48L2Rpdj4iO30=');
// Replacement for the die function
function cpg_die($msg_code, $msg_text,  $error_file, $error_line, $output_buffer = false)
{
        global $CONFIG, $lang_cpg_die, $template_cpg_die;

        // Simple output if theme file is not loaded
        if(!function_exists('pageheader')){
                echo 'Fatal error :<br />'.$msg_text;
                exit;
        }

 	$ob = ob_get_contents();
        if ($ob) ob_end_clean();

        if(!$CONFIG['debug_mode']) template_extract_block($template_cpg_die, 'file_line');
        if(!$output_buffer && !$CONFIG['debug_mode']) template_extract_block($template_cpg_die, 'output_buffer');

        $params = array(
                '{MESSAGE}' => $msg_text,
                '{FILE_TXT}' => $lang_cpg_die['file'],
                '{FILE}' => $error_file,
                '{LINE_TXT}' => $lang_cpg_die['line'],
                '{LINE}' => $error_line,
                '{OUTPUT_BUFFER}' => $ob,
        );

        pageheader($lang_cpg_die[$msg_code]);
        starttable(-1, $lang_cpg_die[$msg_code]);
        echo template_eval($template_cpg_die, $params);
        endtable();
        pagefooter();
        exit;
}

// Display a 'message box like' table
function msg_box($title, $msg_text, $button_text="", $button_link="", $width="-1")
{
	echo $title.':<br />'.$msg_text;
}


function db_getStartId($page, $recs, $tbl_name){
	$result = db_query("SELECT max(id) FROM ".$tbl_name);
	//$num_rows = mysql_num_rows($result);

	$row = mysql_fetch_assoc($result);
	$startId = $row['max(id)'] - ($page-1)*$recs;
	if ($startId < 0){$startId == 0;}
	return $startId;
}

function db_getEndId($startId, $recs){
	$endId = $startId - $recs;
	if ($endId < 0){$endId == 0;}
	return $endId;
}

function redirect($target)
{
    header('Location: http://'.$_SERVER['HTTP_HOST'].'/'.$target);
    exit;
}

 

?>