<?php

require 'include/functions.inc.php';
require 'include/gui.inc.php';

//----------------------------------------------------
//----- Processing images by means of GD library -----
//----------------------------------------------------

define("ALIGN_LEFT", "left");
define("ALIGN_CENTER", "center");
define("ALIGN_RIGHT", "right");
define("VALIGN_TOP", "top");
define("VALIGN_MIDDLE", "middle");
define("VALIGN_BOTTOM", "bottom");

function imagestringbox(&$image, $font, $left, $top, $right, $bottom, $align, $valign, $leading, $text, $color)
{
   // Get size of box
   $height = $bottom - $top;
   $width = $right - $left;
 
   // Break the text into lines, and into an array
   $lines = wordwrap($text, floor($width / imagefontwidth($font)), "\n", true);
   $lines = explode("\n", $lines);
 
   // Other important numbers
   $line_height = imagefontheight($font) + $leading;
   $line_count = floor($height / $line_height);
   $line_count = ($line_count > count($lines)) ? (count($lines)) : ($line_count);
 
   // Loop through lines
   for ($i = 0; $i < $line_count; $i++){
       // Vertical Align
       switch($valign){
           case VALIGN_TOP: // Top
               $y = $top + ($i * $line_height);
               break;
           case VALIGN_MIDDLE: // Middle
               $y = $top + (($height - ($line_count * $line_height)) / 2) + ($i * $line_height);
               break;
           case VALIGN_BOTTOM: // Bottom
               $y = ($top + $height) - ($line_count * $line_height) + ($i * $line_height);
               break;
           default:
               return false;
       }
     
       // Horizontal Align
       $line_width = strlen($lines[$i]) * imagefontwidth($font);
       switch($align){
           case ALIGN_LEFT: // Left
               $x = $left;
               break;
           case ALIGN_CENTER: // Center
               $x = $left + (($width - $line_width) / 2);
               break;
           case ALIGN_RIGHT: // Right
               $x = $left + ($width - $line_width);
               break;
           default:
               return false;
       }
     
       // Draw
       imagestring($image, $font, $x, $y, $lines[$i], $color);
   }
   return true;
}

function imagecreatefromfile($filename)
{
    static $image_creators;

    if (!isset($image_creators)) {
        $image_creators = array(
            1  => "imagecreatefromgif",
            2  => "imagecreatefromjpeg",
            3  => "imagecreatefrompng",
            16 => "imagecreatefromxbm"
        );
    }

    $image_size = getimagesize($filename);
    if (is_array($image_size)) {
        $file_type = $image_size[2];
        if (isset($image_creators[$file_type])) {
            $image_creator = $image_creators[$file_type];
            if (function_exists($image_creator)) {
                return $image_creator($filename);
            }
        }
    }
    return "";
}

function mix_picture($name, $subj_body, $id_softver, $ext_temp)
{
        global $CONFIG;

        $sourceFile = $CONFIG['upload_dir'].'/'.$name;
        $destinationFile = $CONFIG['mixed_dir'].'/'.$name;
        $output;
        $retval;

	$timeStamp = getCX65TimeStamp($name);

        if(file_exists($destinationFile)) { 
                //chmod($destinationFile, 0777); unlink($destinationFile); 
        }else{
                //--- Using GD ---
                $image = imagecreatefromfile($sourceFile);
                $transparentBlue = imagecolorallocatealpha($image, 50, 50, 214, 70);
                $transparentYellow = imagecolorallocatealpha($image, 255, 255, 0, 75);

                list($width,$height)=getimagesize($sourceFile);

                imagefilledrectangle($image, 0, 0, $width-1, 33, $transparentBlue);
                imagefilledrectangle($image, 0, $height-1, $width-1, $height-31, $transparentBlue);

                $x1 = $width-110;
                $y1 = 10;
                $x2 = $width-11;
                $y2 = 80;
                imagefilledrectangle($image, $x1, $y1, $x2, $y2, $transparentYellow);

                $fontColorWhite = imagecolorallocate($image, 255, 255, 255);
                $font = 3;
                imagestringbox($image, $font, 10, 0, $width, $height, "left", "bottom", 10, $timeStamp, $fontColorWhite);
                imagestringbox($image, $font, 10, 10, $width, $height, "left", "top", 0, $subj_body, $fontColorWhite);
                imagestringbox($image, $font, 0, 0, $width-10, $height, "right", "bottom", 10, $id_softver, $fontColorWhite);
                
                $fontColorBlue = imagecolorallocate($image, 0, 0, 255);
                imagestringbox($image, $font, $x1, $y1, $x2, $y2, "center", "top", 10, "Ext. temp.", $fontColorBlue);
                imagestringbox($image, 5, $x1, $y1+30, $x2, $y2, "center", "top", 10, $ext_temp, $fontColorBlue);
        
                $result = imagejpeg($image, $destinationFile);
        }
}
//----------------------------------------------------
//-----             End of GD usage              -----
//----------------------------------------------------


function getCX65TimeStamp($name)
{
        $deviceDate = substr($name, strpos($name, "_")+1);
        $deviceYear = '20'.substr($deviceDate, 0, 2);
        $deviceMonth = substr($deviceDate, 2, 2);
        $deviceDay = substr($deviceDate, 4, 2);
        $deviceHour = substr($deviceDate, 7, 2);
        $deviceMins = substr($deviceDate, 9, 2);
        $deviceSecs = substr($deviceDate, 11, 2);
        return ("Date: $deviceYear-$deviceMonth-$deviceDay $deviceHour:$deviceMins:$deviceSecs");
}

/**
 * Main code starts here
 */

global $PHP_SELF;
global $CONFIG;

drawHeader('DL Picture');

if (!isset($HTTP_GET_VARS['id']) && !isset($HTTP_POST_VARS['id'])) {
        cpg_die(CRITICAL_ERROR, $lang_errors['param_missing'], __FILE__, __LINE__);
}
$id = isset($HTTP_GET_VARS['id']) ? $HTTP_GET_VARS['id'] : $HTTP_POST_VARS['id'];


$page=1;
if (isset($HTTP_GET_VARS['page']) || isset($HTTP_POST_VARS['page'])) {
        $page = isset($HTTP_GET_VARS['page']) ? $HTTP_GET_VARS['page'] : $HTTP_POST_VARS['page'];
}
$ret_page=$page-1;

$orig=0;
if (isset($HTTP_GET_VARS['orig']) || isset($HTTP_POST_VARS['orig'])) {
        $orig = isset($HTTP_GET_VARS['orig']) ? $HTTP_GET_VARS['orig'] : $HTTP_POST_VARS['orig'];
}


db_connect() || die("<b>DefendLine critical error</b>:<br />Unable to connect to database !<br /><br />MySQL said: <b>" . mysql_error() . "</b>");
$result = db_query("SELECT id, date, deviceid, softver, subject, body, ext_temp, filename FROM defendline_eventlog WHERE (id = $id)");


$num_rows = mysql_num_rows($result);
if ($num_rows > 0) {

        $rowset = db_fetch_rowset($result);
        $row = $rowset[0];
        $name = $row['filename'];
        $deviceId = $row['deviceid'];
        $softver = $row['softver'];
        $subject = $row['subject'];
        $body = $row['body'];
        $ext_temp = $row['ext_temp'];
        
        $id_softver = "DeviceID: $deviceId \\ SoftVersion: $softver";
        $subj_body = "$subject \\ $body";

        mix_picture($name, $subj_body, $id_softver, $ext_temp);
}

echo <<<EOT
<TABLE cellSpacing="0" cellPadding="0" border="0" align="center">
  <TBODY>
  <TR>
    <TD>
EOT;

if (!$orig){
echo "<div><img alt=\"No picture\" src=\"{$CONFIG['mixed_dir']}/{$name}\"></div>";
}else{
echo "<div><img alt=\"No picture\" src=\"{$CONFIG['upload_dir']}/{$name}\"></div>";
}

echo <<<EOT
    </TD>
  </TR>
</TBODY></TABLE>


<div>
<table border="0" width="100%">
        <tr>
                <td width="50%" align="center">
                </td>
EOT;

if ($orig==1){
echo <<<EOT
                <td>
                        <form action="{$PHP_SELF}" method="post">
                                <input type="hidden" name="id" value="{$id}">
                                <input type="hidden" name="page" value="{$page}">
                                <input type="hidden" name="orig" value="0">
                                <div align="center">
                                <input value="Mixed" type="submit">
                                </div>
                        </form>
                </td>
EOT;
}else{
echo <<<EOT
                <td>
                        <form action="{$PHP_SELF}" method="post">
                                <input type="hidden" name="id" value="{$id}">
                                <input type="hidden" name="page" value="{$page}">
                                <input type="hidden" name="orig" value="1">
                                <div align="center">
                                <input value="Original" type="submit">
                                </div>
                        </form>
                </td>
EOT;
}

echo <<<EOT
                <td>
                        <form action="dlRep.php" method="post">
                                <input type="hidden" name="page" value="{$ret_page}">
                                <div align="center">
                                <input value="Back" type="submit">
                                </div>
                        </form>
                </td>

                <td width="50%" align="center">
                </td>
        </tr>
</table>
</div>

EOT;

drawFooter('29.07.2009');

?>
