/*
  ZModem.h - ZModem protocol implementation based on Radu Hristea 
  (radu.hristea@aptrans-group.com; transeast@programmer.net) code

  Copyright (c) 2010 Dmitry Pakhomenko.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef ZModem_h
#define ZModem_h

#include <inttypes.h>

// frametypes
#define ZPAD			'*'
#define ZBIN 			'A'
#define ZHEX 			'B'
#define ZBIN32 			'C'

// headertypes
#define ZRQINIT			0	/* Request attention */
#define ZRINIT			1	/* Attention header */
#define ZSINIT			2	/* */
#define ZACK			3	/* Acknowlege request */
#define ZFILE			4	/* File name from sender */
#define ZSKIP			5	/* To sender: skip this file */
#define ZNAK			6	/* Last packet was garbled */
#define ZABORT			7	/* Abort batch transfers */
#define ZFIN			8	/* Finish session */
#define ZRPOS			9	/* Resume data trans at this position */
#define ZDATA			10	/* Data packet(s) follow */
#define ZEOF			11	/* End of file */
#define ZFERR			12	/* Fatal Read or Write error Detected */
#define ZCRC			13	/* Request for file CRC and response */
#define ZCHALLENGE		14	/* Receiver's Challenge */
#define ZCOMPL			15	/* Request is complete */
#define ZCAN			16	/* Other end canned session with CAN*5 */
#define ZFREECNT		17	/* Request for free bytes on filesystem */
#define ZCOMMAND		18	/* Command from sending program */
#define ZSTDERR			19	/* Output to standard error, data follows */

// ZDLE sequences
#define ZCRCE 'h'	/* CRC next, frame ends, header packet follows */
#define ZCRCG 'i'	/* CRC next, frame continues nonstop */
#define ZCRCQ 'j'	/* CRC next, frame continues, ZACK expected */
#define ZCRCW 'k'	/* CRC next, ZACK expected, end of frame */
#define ZRUB0 'l'	/* Translate to rubout 0177 */
#define ZRUB1 'm'	/* Translate to rubout 0377 */

// misc ZModem properties
#define CANFC32		0x20
#define CANFDX		0x01
#define CANOVIO		0x02

// special chars and flags
#define ZDLE		0x18
#define CAN			0x18 // same as ZDLE
#define ZCNL		0x02
#define ZCBIN		0x01
#define ZCRECOV		0x03

// states of the zmodem state machine
#define SM_SENDZDATA	0	//sending / receiving file information
#define SM_SENDZEOF		1	//finishing file
#define SM_SENDDATA		2	//data transfer is running
#define SM_ACTIONRPOS	3	//reposition the filepointer during sending or receiving
#define SM_WAITZRINIT	4	//waiting for initalisation finish
#define SM_GETHEADER	5   //waiting for a header from the receiver

// errors used by this implementation
#define NO_ERROR    				0x00    //just ... no error  
#define ZMODEM_INIT					0x01	//zmodem-initialization failed
#define ZMODEM_POS					0x02	//force reposition
#define ZMODEM_ZDATA				0x03	//
#define ZMODEM_CRC  				0x04	//16-bit-checksum error
#define ZMODEM_LONGSP				0x05	//too long subpaket recieved
#define ZMODEM_CRC32				0x06	//32-bit-checksum error
#define ZMODEM_FILEDATA				0x07	//filedata has errors or missing
#define ZMODEM_BADHEX				0x08	//unexpected hex-char received (in a hex header)
#define ZMODEM_TIMEOUT				0x09	//by name
#define ZMODEM_GOTZCAN				0x0A	//cancel recieved (form other side)
#define ZMODEM_ABORTFROMOUTSIDE		0x0B	//user break
#define ZMODEM_ERROR_FILE			0x0C	//file handling error (during open, create, read, write)

#define ALLOK  			(lastError == NO_ERROR)
#define ZMAX_RETRY	 	10		// nr of retries
#define XON				0x11

class ZModem
{
  private:
  	HardwareSerial* ser;
	uint8_t gotSpecial;
	uint8_t gotHeader;
	uint8_t moreData;
	uint8_t allowFileWrite;
	uint8_t lastError; 
	uint8_t ch;
	uint8_t needZACK;  
	uint8_t headerType;
	uint8_t headerData[4]; 
	uint16_t nrBytes;
	uint32_t goodOffset;
	uint32_t fileSize;
	uint8_t fileName[13]; 

  public:
    ZModem(HardwareSerial* serial);

	uint8_t send(void);
	uint8_t sendFiles(void);
	uint8_t sendFile(void);
	void getHeader(void);
	void getOO(void);
	void sendFileInfo(void);
	void sendHexHeader(uint8_t hType);
	void sendBinHeader(uint8_t hType);
	uint8_t positionMatch(void);
	void sendData(uint8_t frameEnd);
	void getNextHexCh(void);
	void getNextDLECh(void);
	void sendDLEChar(void);
	void sendHexChar(void);
	uint16_t crcUpdate(uint16_t crc, uint8_t serialData);
};

extern ZModem zModem;

#endif

