/*
  ZModem.h - ZModem protocol implementation based on Radu Hristea 
  (radu.hristea@aptrans-group.com; transeast@programmer.net) code

  Copyright (c) 2010 Dmitry Pakhomenko.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "hardwareserial.h"
#include "ZModem.h"

// Initialize Class Variables //////////////////////////////////////////////////

// Constructors ////////////////////////////////////////////////////////////////

ZModem::ZModem(HardwareSerial* serial)
{
	ser = serial;
}

// Public Methods //////////////////////////////////////////////////////////////


uint8_t ZModem::send(void)
{
	uint8_t fin   = false;
	uint8_t quit  = false;
	uint8_t ok    = false;
	uint8_t tries = 0;
	// 
	goodOffset = 0;
	lastError = NO_ERROR;
	//	
	// HERE: open the file 
	// send initialization string 
	ser->print("rz\r");
/*	while(ALLOK && !fin && (tries++ < ZMAX_RETRY)) // Send
	{
		//wdogtrig();
		sendHexHeader(ZRQINIT);//send ZRQINIT
		getZMHeader();
		if(ALLOK)
		{
			switch(HeaderType)
			{
				case ZCAN://canceled from other side ???
					 return FALSE;
				break;
				
				case ZRINIT:// OK, let's communicate
					 // start sending files
					 ok = rZModem_sendFiles();
					 fin = TRUE;
				break;
			}//switch
		}//if(ALLOK)
		else
		{
			if((LastError == ZMODEM_TIMEOUT) || (LastError == ZMODEM_CRC) || // Send
			   (LastError == ZMODEM_BADHEX))    
			{
				LastError = NO_ERROR;
			}
		}
	}//while(...)

	// sendig is over, finish session
	if(ALLOK) 
	{
	   tries = 0;
	   while(!quit && (tries++ < ZMAX_RETRY))
	   {
      		 wdogtrig();
      		 rZModem_sendHexHeader(ZFIN); 
      		 rZModem_getZMHeader();
			 if(ALLOK)
			 { 
			    switch(HeaderType)
			    { 
         	      case ZCAN:
         	      	   return FALSE;
         	      break;	

			      case ZFIN:
         	           quit = TRUE; //other side has finish accepted
         	      break;
         	    }       
			 }
			 else
			 {
				LastError = NO_ERROR;
			 }
	   }
	   putchar1('O');putchar1('O'); //over and out
	}
    delay_ms(100);
    rComm_clearInBound(); // reject the garbage
*/
	return (fin && ok && quit);
}

void ZModem::sendHexHeader(uint8_t hType)
{
	uint16_t crc = 0;
	uint8_t i;
      
	switch(hType)
	{
	  case ZRINIT :
	  case ZFIN   :
	  case ZRQINIT:
	       for(i = 0; i < 4; i++)
	           headerData[i] = 0;
	       if(hType == ZRINIT)
	           headerData[3] = CANOVIO;
	  break;                           
	  
	  case ZRPOS  :  
	       /*seek(GoodOffset);*/
	  case ZEOF   :
	  case ZACK   :
	       for(i = 0; i < 4; i++)
	           headerData[i] = (uint8_t)(goodOffset >> (uint8_t)(8 * i));
	  break;
	}
	// sending now ...
	ser->write(ZPAD);
	ser->write(ZPAD);
	ser->write(ZDLE);
    ser->write(ZHEX);

   	ch = hType;
	ser->print(ch, HEX);
    crc = crcUpdate(crc, ch); 
	ser->print(ch, HEX);
	for(i = 0; i < 4; i++)
	{
	   	ch = headerData[i];
		crc = crcUpdate(crc, ch);
		ser->print(ch, HEX);
	}
   	ch = (uint8_t)(crc >> 8); 
	ser->print(ch, HEX);
   	ch = (uint8_t)crc; 
	ser->print(ch, HEX);
	//**************************
	ser->print("\r\n");
	if(hType != ZFIN && hType != ZACK)
	   ser->write(XON);
}


uint16_t ZModem::crcUpdate(uint16_t crc, uint8_t serialData)
{
	return 0;
}

// Preinstantiate Objects //////////////////////////////////////////////////////

ZModem zmodem = ZModem(&Serial);
