/*
  Utils.h - headers, global function prototypes and typedefs 
  for DefendLineII.
  Copyright (c) 2012 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef Utils_h
#define Utils_h


#include <stdio.h>
#include <string.h>

#ifndef byte
typedef unsigned char byte;
typedef unsigned short ushort;
typedef unsigned long ulong;
#endif


#ifndef _WIN32
#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/boot.h>
#include <util/delay.h>
#include <stdlib.h>
#include <avr/sleep.h>

#include "Print.h"
#include "twi.h"
#include "Wire.h"
#include "WProgram.h"
#include "HardwareSerial.h"
#include "DS1621.h"
#include "PCF8563.h"

#include "byteordering.h"
#include "sd_raw_config.h"
#include "sd_raw.h"
#include "sd-reader_config.h"
#include "partition_config.h"
#include "partition.h"
#include "fat_config.h"
#include "fat.h"
#include "C328Camera.h"
#include "MicroSD.h"
#include "ZModem.h"
#include "SIM900Modem.h"
#include "ModemHelper.h"
#include "LiquidCrystal.h"
#include "Tone.h"
#include "SoundHelper.h"
#include "IRremote.h"
#include "Board.h"
#include "Messages.h"
#include "ConsoleHelper.h"
#include "CameraHelper.h"
#include "FormatDataHelper.h"
#include "IRHelper.h"
#include "CopernicusGps.h"

#include "NokiaLCD.h"


#else
#include "stdafx.h"
#define PROGMEM 
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long uint32_t;
#define pgm_read_byte(_x) (*(_x))
#define pgm_read_word(_x) (*(_x))

#endif

#define ASSERT(_x) if (!(_x)) assertFailed(NULL,__LINE__);

uint8_t strtobcd(char** str);
uint32_t strtolong(const char* str);
void flash_led_orange(uint8_t count);
void flash_led_blue(uint8_t count);
void set_relay(uint8_t output_num, uint8_t value);
void test_relay_outputs();
void appendCRLF(char** buf);
uint16_t get_voltage(uint16_t adc_value);
void stripCRLF(char* str);
uint8_t bcdtobin(uint8_t bcd);
uint8_t bintobcd(uint8_t bin);
void incHour(RtcTimeType* rtc);

#endif



