/*
  DefendLineII.c - utilities
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <util/delay.h>

#include "Utils.h"


uint8_t strtobcd(char** str)
{
    uint8_t l = 0;
    while(**str >= '0' && **str <= '9')
    {
	    l = l * 16 + (**str - '0');
		*str+= 1;
	}
    return l;
}

uint32_t strtolong(const char* str)
{
    uint32_t l = 0;
    while(*str >= '0' && *str <= '9')
        l = l * 10 + (*str++ - '0');

    return l;
}

void stripCRLF(char* str)
{
    while (*str)
    {   if (*str == 0xD || *str == 0xA)
        {
            *str = 0;
            return;
        }
        *str++;
    }
}

uint8_t bcdtobin(uint8_t bcd)
{
    uint8_t rightN = (bcd & 0xF0) >> 4;
    uint8_t leftN = bcd & 0xF;
    return (rightN * 10 + leftN);
}

uint8_t bintobcd(uint8_t bin)
{
    uint8_t res = 0;
    char i = 0;
    do
    {
       res |= (bin % 10) << i;
       bin /= 10;
       i += 4;
    } while(i < 16);   
   return res; 
}

//Obsoleted. This fuctionality is implemented
//by timer means
/*void flash_led_orange(uint8_t count)
{
    if (count == 0)
      	count = 3;    
    while (count--) {
	    LED_ORANGE_1;
	    _delay_ms(100);
		if (termCmd) 
		{
			LED_ORANGE_0;
			return;
		}
	    LED_ORANGE_0;
	    _delay_ms(100);
		if (termCmd) return;
    }
}

//Obsoleted. This fuctionality is implemented
//by timer means
void flash_led_blue(uint8_t count)
{
    if (count == 0)
     	count = 3;    
    while (count--) {
	    LED_BLUE_1;

	    _delay_ms(100);
		if (termCmd) 
		{
			LED_BLUE_0;
			return;
		}

	    LED_BLUE_0;
	    _delay_ms(100);
		if (termCmd) return;
    }
}*/

void set_relay(uint8_t output_num, uint8_t value)
{
	if (output_num == 0)
	{
		if (value == 0)	RELAY_0_0;
		else RELAY_0_1;

	}else if (output_num == 1)
	{
		if (value == 0)	RELAY_1_0;
		else RELAY_1_1;
	}
}

//Obsoleted. This fuctionality is implemented
//by timer means
/*void test_relay_outputs()
{
	set_relay(0, 1);
	_delay_ms(100);
	set_relay(1, 1);
	_delay_ms(1000);
	set_relay(0, 0);
	_delay_ms(100);
	set_relay(1, 0);
}*/

void appendCRLF(char** buf)
{
	*buf[0] = '\r';
	*buf+=1;
	*buf[0] = '\n';
	*buf+=1;
}

uint16_t get_voltage(uint16_t adc_value)
{
    uint32_t u2 = (uint32_t)REF_VOLTAGE * adc_value / ADC_MAX_VALUE;
    uint32_t u1 = u2 * R12BYR11;
    return (uint16_t)(u1 + u2) / 10;
}

void incHour(RtcTimeType* rtc)
{
        if (rtc == NULL) return;
        rtc->hours = bintobcd( bcdtobin(rtc->hours) + 1);
        if (rtc->hours > 0x23)
        {
            rtc->hours = 0;
            rtc->day = bintobcd( bcdtobin(rtc->day) + 1 );
            if (rtc->day > 0x31)  //for simplicity sake
            {
                rtc->day = 0;
                rtc->month = bintobcd( bcdtobin(rtc->month) + 1 );
                if (rtc->month > 0x12)
                {
                   rtc->month = 0;
                   rtc->year = bintobcd( MIN_YEAR + (bcdtobin(rtc->year & 0xF) + 1 ) );
                }
            }
        }

}


