/*
  SIM900Modem.h - SIM900 GSM module library for DefendLineII
  Copyright (c) 2011 Dmitry Pakhomenko.  All right reserved.

  http://atmega.magictale.com

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef SIM900Modem_h
#define SIM900Modem_h

#include <inttypes.h>
#include "PCF8563.h"

#define MDM_TIMEOUT 10 //number of retries (each one is 10 msec)
#define MDM_HTTP_DATA_TIMEOUT 10000

const PROGMEM char MDM_CMD_PREFIX[] = "AT";
const PROGMEM char MDM_OK_REPLY[] = "OK";
const PROGMEM char MDM_ERROR_REPLY[] = "ERROR";

class SIM900Modem
{
  private:
    HardwareSerial* mdm;
    HardwareSerial* dbg;

    uint8_t sendATCmdWaitResp(const char* cmd);
    uint8_t sendATCmdWaitResp_p(const prog_char cmd[]);
    uint8_t sendATCmdWaitResp(const char* cmd, const prog_char expectedResp[], uint8_t delayCntr);
    uint8_t sendATCmdWaitResp_p(const prog_char cmd[], const prog_char expectedResp[], uint8_t delayCntr);
    uint8_t atCmdWaitResp(const prog_char expectedResp[], uint8_t delayCntr);
    uint8_t extractReply(char* out_buf, uint16_t len);
	uint8_t extractReply(char* outBuf, uint16_t len, uint8_t line);
  public:
    SIM900Modem(HardwareSerial* mdm, HardwareSerial* dbg);
    uint8_t init();
    uint8_t powerOff();
    void    forcedPowerOff();
    uint8_t getManufacturerID(char* buf, uint16_t len);
    uint8_t getModelID(char* buf, uint16_t len);
    uint8_t getTARevision(char* buf, uint16_t len);
    uint8_t getIMEI(char* buf, uint16_t len);

    uint8_t enableRTC();
    uint8_t getRTC(RtcTimeType* rtc);

    uint8_t setTxtSMSMsgFormat();
    uint8_t setGSMCharSet();
    uint8_t sendSMS(char* destAddr, char* msg);
    //uint8_t receiveSMS(uint8_t* smsID, char* txt, char* origAddr);
    //uint8_t deleteSMS(uint8_t smsID);
    //uint8_t deleteAllSMS();

    uint8_t getNetworkRegistration();
    uint8_t waitForNetworkRegistration();
    uint8_t getNetworkOperator(char* buf, uint16_t len);
    //uint8_t setNetworkRegistration(uint8_t n);
       
    uint8_t openGPRSContext(char* buf);
    uint8_t closeGPRSContext();
    uint8_t queryGPRSContext(char* buf, uint16_t len);

    //uint8_t getTime(RtcTimeType* rtc);

    uint8_t httpInit();
    uint8_t httpSetURL(char* buf);
    uint8_t httpSetData(char* buf, uint16_t len, uint16_t timeout);
    uint8_t httpAction(uint8_t isPostMethod, uint16_t* responseLen);
    uint8_t httpRead(char* buf, uint16_t startIdx, uint16_t len);
    uint8_t httpTerm();

    uint8_t startSingleIPConnMode();
    uint8_t getLocalIP(char* buf, uint16_t len);
    uint8_t getGPRSPDPStatus(char* buf, uint16_t len);
    uint8_t startIPConn(uint8_t isTCP, char* buf, uint16_t port);
    uint8_t sendIPConn(char* buf, uint16_t len, uint16_t delayCntr);
    uint8_t sendAndCheckHTTPRespIPConn(char* buf, uint16_t len, uint16_t  bufsize, 
        uint16_t delayCntr, RtcTimeType* rtc);
    uint8_t closeIPConn();
    uint8_t deactGPRSPDPContext();
    uint8_t setGPRSPDPAPN(char* apn, char* username, char* pwd);
    uint8_t actGPRSPDPContext();

    uint8_t actGPRSPDPContext(char* buf, uint16_t len);


    //uint8_t postDLEvent(char* extTemp, char* detectorID, char* deviceID, char* host, char* port,
    //    char* uriPath, char* subject, char* body, char* file, char* fileName);

};

extern SIM900Modem GsmModem;

#endif

