/*
  PCF8563.h - Real-Time Clock/Calendar library for DefendLineII
  Copyright (c) 2010 Dmitry Pakhomenko.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef PCF8563_h
#define PCF8563_h

#include <inttypes.h>

#include "Wire.h"

#define PCF8563_I2C_ADDR			0x51	///< Base I2C address of PCF8563 devices


typedef struct struct_RtcTime
{	
	uint8_t seconds;
	uint8_t minutes;
	uint8_t hours;
	uint8_t day;
	uint8_t weekday;
	uint8_t month;
	uint16_t year;
} RtcTimeType;

class PCF8563
{
  private:
  public:
    PCF8563();
	uint8_t init(uint8_t i2cAddr);
	uint8_t getTime(uint8_t i2cAddr, RtcTimeType* rtc);
	void setTime(uint8_t i2cAddr, RtcTimeType* rtc);
	uint8_t getAlarm(uint8_t i2cAddr, RtcTimeType* rtc);
	void setAlarm(uint8_t i2cAddr, RtcTimeType* rtc);

/*	uint8_t reset(uint8_t i2cAddr);
	uint8_t setConfig(uint8_t i2cAddr, uint8_t config);
	uint8_t getConfig(uint8_t i2cAddr);

	unsigned char rtc_read(unsigned char address);
	void rtc_write(unsigned char address, unsigned char data)
	void rtc_alarm_off(void)
	void rtc_alarm_on(void)
	void rtc_set_timer(unsigned char val)*/
};

extern PCF8563 RTClock;

#endif

