/*
  PCF8563.c - Real-Time Clock/Calendar library for DefendLineII
  Copyright (c) 2010 Dmitry Pakhomenko.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "PCF8563.h"

// Initialize Class Variables //////////////////////////////////////////////////

// Constructors ////////////////////////////////////////////////////////////////

PCF8563::PCF8563()
{
}

// Public Methods //////////////////////////////////////////////////////////////
uint8_t PCF8563::init(uint8_t i2cAddr)
{
	Wire.beginTransmission(i2cAddr);
	return Wire.endTransmission();
}

uint8_t PCF8563::getTime(uint8_t i2cAddr, RtcTimeType* rtc)
{
	Wire.beginTransmission(i2cAddr);
	Wire.send(2);
	Wire.endTransmission();

	Wire.requestFrom(i2cAddr, (uint8_t)7);

	uint8_t res = 0; 	

	if(7 <= Wire.available())
	{
    	rtc->seconds = Wire.receive() & 0x7F;
		rtc->minutes = Wire.receive() & 0x7F;
		rtc->hours = Wire.receive() & 0x3F;
		rtc->day = Wire.receive() & 0x3F;
		rtc->weekday = Wire.receive() & 0x7;
		rtc->month = Wire.receive() & 0x1F;
		rtc->year = 0x2000 + Wire.receive();
  	}else res = -1;

	return res;
}

void PCF8563::setTime(uint8_t i2cAddr, RtcTimeType* rtc)
{
	Wire.beginTransmission(i2cAddr);
	Wire.send(2);

   	Wire.send(rtc->seconds & 0x7F);
	Wire.send(rtc->minutes & 0x7F);
	Wire.send(rtc->hours & 0x3F);
	Wire.send(rtc->day & 0x3F);
	Wire.send(rtc->weekday & 0x7);
	Wire.send(rtc->month & 0x1F);
	Wire.send((uint8_t)(rtc->year - 0x2000));

	Wire.endTransmission();
}

uint8_t PCF8563::getAlarm(uint8_t i2cAddr, RtcTimeType* rtc)
{
	Wire.beginTransmission(i2cAddr);
	Wire.send(9);
	Wire.endTransmission();

	Wire.requestFrom(i2cAddr, (uint8_t)4);

	uint8_t res = 0; 	

	if(4 <= Wire.available())
	{
		rtc->minutes = Wire.receive() & 0x7F;
		rtc->hours = Wire.receive() & 0x3F;
		rtc->day = Wire.receive() & 0x3F;
		rtc->weekday = Wire.receive() & 0x7;
  	}else res = -1;

	return res;
}

void PCF8563::setAlarm(uint8_t i2cAddr, RtcTimeType* rtc)
{
	Wire.beginTransmission(i2cAddr);
	Wire.send(9);

	Wire.send(rtc->minutes & 0x7F);
	Wire.send(rtc->hours & 0x3F);
	Wire.send(rtc->day & 0x3F);
	Wire.send(rtc->weekday & 0x7);

	Wire.endTransmission();
}

/*uint8_t PCF8563::reset(uint8_t i2cAddr)
{
	uint8_t buffer[1];
	// return the DS1621 to power-on reset defaults
	buffer[0] = DS1621_CMD_SWPOR;

	Wire.beginTransmission(i2cAddr);
	Wire.send(buffer, 1);
	return Wire.endTransmission();
}*/

/*uint8_t PCF8563::setConfig(uint8_t i2cAddr, uint8_t config)
{
	uint8_t buffer[2];
	// write the DS1621 configuration byte
	buffer[0] = DS1621_CMD_ACCESSCONFIG;
	buffer[1] = config;

	Wire.beginTransmission(i2cAddr);
	Wire.send(buffer, 2);
	return Wire.endTransmission();
}*/



// Preinstantiate Objects //////////////////////////////////////////////////////

PCF8563 RTClock = PCF8563();
